/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.reflect.TypeToken;
import java.nio.ByteBuffer;

public abstract class MappingCodec<O, I>
extends TypeCodec<O> {
    protected final TypeCodec<I> innerCodec;

    public MappingCodec(TypeCodec<I> innerCodec, Class<O> javaType) {
        this(innerCodec, TypeToken.of(javaType));
    }

    public MappingCodec(TypeCodec<I> innerCodec, TypeToken<O> javaType) {
        super(innerCodec.getCqlType(), javaType);
        this.innerCodec = innerCodec;
    }

    public ByteBuffer serialize(O value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        return this.innerCodec.serialize(this.serialize(value), protocolVersion);
    }

    public O deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        return this.deserialize(this.innerCodec.deserialize(bytes, protocolVersion));
    }

    public O parse(String value) throws InvalidTypeException {
        return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : (O)this.deserialize(this.innerCodec.parse(value));
    }

    public String format(O value) throws InvalidTypeException {
        return value == null ? null : this.innerCodec.format(this.serialize(value));
    }

    protected abstract O deserialize(I var1);

    protected abstract I serialize(O var1);
}

