/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.ProtocolEvent;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

class Requests {
    private Requests() {
    }

    static class AuthResponse
    extends Message.Request {
        static final Message.Coder<AuthResponse> coder = new Message.Coder<AuthResponse>(){

            @Override
            public void encode(AuthResponse response, ByteBuf dest, ProtocolVersion version) {
                CBUtil.writeValue(response.token, dest);
            }

            @Override
            public int encodedSize(AuthResponse response, ProtocolVersion version) {
                return CBUtil.sizeOfValue(response.token);
            }
        };
        private final byte[] token;

        AuthResponse(byte[] token) {
            super(Message.Request.Type.AUTH_RESPONSE);
            this.token = token;
        }

        @Override
        protected Message.Request copyInternal() {
            return new AuthResponse(this.token);
        }
    }

    static class Register
    extends Message.Request {
        static final Message.Coder<Register> coder = new Message.Coder<Register>(){

            @Override
            public void encode(Register msg, ByteBuf dest, ProtocolVersion version) {
                dest.writeShort(msg.eventTypes.size());
                for (ProtocolEvent.Type type : msg.eventTypes) {
                    CBUtil.writeEnumValue(type, dest);
                }
            }

            @Override
            public int encodedSize(Register msg, ProtocolVersion version) {
                int size = 2;
                for (ProtocolEvent.Type type : msg.eventTypes) {
                    size += CBUtil.sizeOfEnumValue(type);
                }
                return size;
            }
        };
        private final List<ProtocolEvent.Type> eventTypes;

        Register(List<ProtocolEvent.Type> eventTypes) {
            super(Message.Request.Type.REGISTER);
            this.eventTypes = eventTypes;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Register(this.eventTypes);
        }

        public String toString() {
            return "REGISTER " + this.eventTypes;
        }
    }

    static class Prepare
    extends Message.Request {
        static final Message.Coder<Prepare> coder = new Message.Coder<Prepare>(){

            @Override
            public void encode(Prepare msg, ByteBuf dest, ProtocolVersion version) {
                CBUtil.writeLongString(msg.query, dest);
            }

            @Override
            public int encodedSize(Prepare msg, ProtocolVersion version) {
                return CBUtil.sizeOfLongString(msg.query);
            }
        };
        private final String query;

        Prepare(String query) {
            super(Message.Request.Type.PREPARE);
            this.query = query;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Prepare(this.query);
        }

        public String toString() {
            return "PREPARE " + this.query;
        }
    }

    static class BatchProtocolOptions {
        private final EnumSet<QueryFlag> flags = EnumSet.noneOf(QueryFlag.class);
        final ConsistencyLevel consistency;
        final ConsistencyLevel serialConsistency;
        final long defaultTimestamp;

        BatchProtocolOptions(ConsistencyLevel consistency, ConsistencyLevel serialConsistency, long defaultTimestamp) {
            this.consistency = consistency;
            this.serialConsistency = serialConsistency;
            this.defaultTimestamp = defaultTimestamp;
            if (serialConsistency != ConsistencyLevel.SERIAL) {
                this.flags.add(QueryFlag.SERIAL_CONSISTENCY);
            }
            if (defaultTimestamp != Long.MIN_VALUE) {
                this.flags.add(QueryFlag.DEFAULT_TIMESTAMP);
            }
        }

        BatchProtocolOptions copy(ConsistencyLevel newConsistencyLevel) {
            return new BatchProtocolOptions(newConsistencyLevel, this.serialConsistency, this.defaultTimestamp);
        }

        void encode(ByteBuf dest, ProtocolVersion version) {
            switch (version) {
                case V2: {
                    CBUtil.writeConsistencyLevel(this.consistency, dest);
                    break;
                }
                case V3: 
                case V4: {
                    CBUtil.writeConsistencyLevel(this.consistency, dest);
                    dest.writeByte((int)((byte)QueryFlag.serialize(this.flags)));
                    if (this.flags.contains((Object)QueryFlag.SERIAL_CONSISTENCY)) {
                        CBUtil.writeConsistencyLevel(this.serialConsistency, dest);
                    }
                    if (!this.flags.contains((Object)QueryFlag.DEFAULT_TIMESTAMP)) break;
                    dest.writeLong(this.defaultTimestamp);
                    break;
                }
                default: {
                    throw version.unsupported();
                }
            }
        }

        int encodedSize(ProtocolVersion version) {
            switch (version) {
                case V2: {
                    return CBUtil.sizeOfConsistencyLevel(this.consistency);
                }
                case V3: 
                case V4: {
                    int size = 0;
                    size += CBUtil.sizeOfConsistencyLevel(this.consistency);
                    ++size;
                    if (this.flags.contains((Object)QueryFlag.SERIAL_CONSISTENCY)) {
                        size += CBUtil.sizeOfConsistencyLevel(this.serialConsistency);
                    }
                    if (this.flags.contains((Object)QueryFlag.DEFAULT_TIMESTAMP)) {
                        size += 8;
                    }
                    return size;
                }
            }
            throw version.unsupported();
        }

        public String toString() {
            return String.format("[cl=%s, serialCl=%s, defaultTs=%d]", new Object[]{this.consistency, this.serialConsistency, this.defaultTimestamp});
        }
    }

    static class Batch
    extends Message.Request {
        static final Message.Coder<Batch> coder = new Message.Coder<Batch>(){

            @Override
            public void encode(Batch msg, ByteBuf dest, ProtocolVersion version) {
                int queries = msg.queryOrIdList.size();
                assert (queries <= 65535);
                dest.writeByte((int)this.fromType(msg.type));
                dest.writeShort(queries);
                for (int i = 0; i < queries; ++i) {
                    Object q = msg.queryOrIdList.get(i);
                    dest.writeByte((int)((byte)(!(q instanceof String) ? 1 : 0)));
                    if (q instanceof String) {
                        CBUtil.writeLongString((String)q, dest);
                    } else {
                        CBUtil.writeBytes(((MD5Digest)q).bytes, dest);
                    }
                    CBUtil.writeValueList(msg.values.get(i), dest);
                }
                msg.options.encode(dest, version);
            }

            @Override
            public int encodedSize(Batch msg, ProtocolVersion version) {
                int size = 3;
                for (int i = 0; i < msg.queryOrIdList.size(); ++i) {
                    Object q = msg.queryOrIdList.get(i);
                    size += 1 + (q instanceof String ? CBUtil.sizeOfLongString((String)q) : CBUtil.sizeOfBytes(((MD5Digest)q).bytes));
                    size += CBUtil.sizeOfValueList(msg.values.get(i));
                }
                return size += msg.options.encodedSize(version);
            }

            private byte fromType(BatchStatement.Type type) {
                switch (type) {
                    case LOGGED: {
                        return 0;
                    }
                    case UNLOGGED: {
                        return 1;
                    }
                    case COUNTER: {
                        return 2;
                    }
                }
                throw new AssertionError();
            }
        };
        final BatchStatement.Type type;
        final List<Object> queryOrIdList;
        final List<List<ByteBuffer>> values;
        final BatchProtocolOptions options;

        Batch(BatchStatement.Type type, List<Object> queryOrIdList, List<List<ByteBuffer>> values, BatchProtocolOptions options, boolean tracingRequested) {
            super(Message.Request.Type.BATCH, tracingRequested);
            this.type = type;
            this.queryOrIdList = queryOrIdList;
            this.values = values;
            this.options = options;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Batch(this.type, this.queryOrIdList, this.values, this.options, this.isTracingRequested());
        }

        @Override
        protected Message.Request copyInternal(ConsistencyLevel newConsistencyLevel) {
            return new Batch(this.type, this.queryOrIdList, this.values, this.options.copy(newConsistencyLevel), this.isTracingRequested());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("BATCH of [");
            for (int i = 0; i < this.queryOrIdList.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.queryOrIdList.get(i)).append(" with ").append(this.values.get(i).size()).append(" values");
            }
            sb.append("] with options ").append(this.options);
            return sb.toString();
        }
    }

    static class QueryProtocolOptions {
        static final QueryProtocolOptions DEFAULT = new QueryProtocolOptions(Message.Request.Type.QUERY, ConsistencyLevel.ONE, Collections.<ByteBuffer>emptyList(), Collections.<String, ByteBuffer>emptyMap(), false, -1, null, ConsistencyLevel.SERIAL, Long.MIN_VALUE);
        private final EnumSet<QueryFlag> flags = EnumSet.noneOf(QueryFlag.class);
        private final Message.Request.Type requestType;
        final ConsistencyLevel consistency;
        final List<ByteBuffer> positionalValues;
        final Map<String, ByteBuffer> namedValues;
        final boolean skipMetadata;
        final int pageSize;
        final ByteBuffer pagingState;
        final ConsistencyLevel serialConsistency;
        final long defaultTimestamp;

        QueryProtocolOptions(Message.Request.Type requestType, ConsistencyLevel consistency, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, ConsistencyLevel serialConsistency, long defaultTimestamp) {
            Preconditions.checkArgument((positionalValues.isEmpty() || namedValues.isEmpty() ? 1 : 0) != 0);
            this.requestType = requestType;
            this.consistency = consistency;
            this.positionalValues = positionalValues;
            this.namedValues = namedValues;
            this.skipMetadata = skipMetadata;
            this.pageSize = pageSize;
            this.pagingState = pagingState;
            this.serialConsistency = serialConsistency;
            this.defaultTimestamp = defaultTimestamp;
            if (!positionalValues.isEmpty()) {
                this.flags.add(QueryFlag.VALUES);
            }
            if (!namedValues.isEmpty()) {
                this.flags.add(QueryFlag.VALUES);
                this.flags.add(QueryFlag.VALUE_NAMES);
            }
            if (skipMetadata) {
                this.flags.add(QueryFlag.SKIP_METADATA);
            }
            if (pageSize >= 0) {
                this.flags.add(QueryFlag.PAGE_SIZE);
            }
            if (pagingState != null) {
                this.flags.add(QueryFlag.PAGING_STATE);
            }
            if (serialConsistency != ConsistencyLevel.SERIAL) {
                this.flags.add(QueryFlag.SERIAL_CONSISTENCY);
            }
            if (defaultTimestamp != Long.MIN_VALUE) {
                this.flags.add(QueryFlag.DEFAULT_TIMESTAMP);
            }
        }

        QueryProtocolOptions copy(ConsistencyLevel newConsistencyLevel) {
            return new QueryProtocolOptions(this.requestType, newConsistencyLevel, this.positionalValues, this.namedValues, this.skipMetadata, this.pageSize, this.pagingState, this.serialConsistency, this.defaultTimestamp);
        }

        void encode(ByteBuf dest, ProtocolVersion version) {
            switch (version) {
                case V1: {
                    if (this.requestType == Message.Request.Type.EXECUTE) {
                        CBUtil.writeValueList(this.positionalValues, dest);
                    }
                    CBUtil.writeConsistencyLevel(this.consistency, dest);
                    break;
                }
                case V2: 
                case V3: 
                case V4: {
                    CBUtil.writeConsistencyLevel(this.consistency, dest);
                    dest.writeByte((int)((byte)QueryFlag.serialize(this.flags)));
                    if (this.flags.contains((Object)QueryFlag.VALUES)) {
                        if (this.flags.contains((Object)QueryFlag.VALUE_NAMES)) {
                            assert (version.compareTo(ProtocolVersion.V3) >= 0);
                            CBUtil.writeNamedValueList(this.namedValues, dest);
                        } else {
                            CBUtil.writeValueList(this.positionalValues, dest);
                        }
                    }
                    if (this.flags.contains((Object)QueryFlag.PAGE_SIZE)) {
                        dest.writeInt(this.pageSize);
                    }
                    if (this.flags.contains((Object)QueryFlag.PAGING_STATE)) {
                        CBUtil.writeValue(this.pagingState, dest);
                    }
                    if (this.flags.contains((Object)QueryFlag.SERIAL_CONSISTENCY)) {
                        CBUtil.writeConsistencyLevel(this.serialConsistency, dest);
                    }
                    if (version.compareTo(ProtocolVersion.V3) < 0 || !this.flags.contains((Object)QueryFlag.DEFAULT_TIMESTAMP)) break;
                    dest.writeLong(this.defaultTimestamp);
                    break;
                }
                default: {
                    throw version.unsupported();
                }
            }
        }

        int encodedSize(ProtocolVersion version) {
            switch (version) {
                case V1: {
                    return (this.requestType == Message.Request.Type.EXECUTE ? CBUtil.sizeOfValueList(this.positionalValues) : 0) + CBUtil.sizeOfConsistencyLevel(this.consistency);
                }
                case V2: 
                case V3: 
                case V4: {
                    int size = 0;
                    size += CBUtil.sizeOfConsistencyLevel(this.consistency);
                    ++size;
                    if (this.flags.contains((Object)QueryFlag.VALUES)) {
                        if (this.flags.contains((Object)QueryFlag.VALUE_NAMES)) {
                            assert (version.compareTo(ProtocolVersion.V3) >= 0);
                            size += CBUtil.sizeOfNamedValueList(this.namedValues);
                        } else {
                            size += CBUtil.sizeOfValueList(this.positionalValues);
                        }
                    }
                    if (this.flags.contains((Object)QueryFlag.PAGE_SIZE)) {
                        size += 4;
                    }
                    if (this.flags.contains((Object)QueryFlag.PAGING_STATE)) {
                        size += CBUtil.sizeOfValue(this.pagingState);
                    }
                    if (this.flags.contains((Object)QueryFlag.SERIAL_CONSISTENCY)) {
                        size += CBUtil.sizeOfConsistencyLevel(this.serialConsistency);
                    }
                    if (version == ProtocolVersion.V3 && this.flags.contains((Object)QueryFlag.DEFAULT_TIMESTAMP)) {
                        size += 8;
                    }
                    return size;
                }
            }
            throw version.unsupported();
        }

        public String toString() {
            return String.format("[cl=%s, positionalVals=%s, namedVals=%s, skip=%b, psize=%d, state=%s, serialCl=%s]", new Object[]{this.consistency, this.positionalValues, this.namedValues, this.skipMetadata, this.pageSize, this.pagingState, this.serialConsistency});
        }
    }

    static enum QueryFlag {
        VALUES,
        SKIP_METADATA,
        PAGE_SIZE,
        PAGING_STATE,
        SERIAL_CONSISTENCY,
        DEFAULT_TIMESTAMP,
        VALUE_NAMES;


        static EnumSet<QueryFlag> deserialize(int flags) {
            EnumSet<QueryFlag> set = EnumSet.noneOf(QueryFlag.class);
            QueryFlag[] values = QueryFlag.values();
            for (int n = 0; n < values.length; ++n) {
                if ((flags & 1 << n) == 0) continue;
                set.add(values[n]);
            }
            return set;
        }

        static int serialize(EnumSet<QueryFlag> flags) {
            int i = 0;
            for (QueryFlag flag : flags) {
                i |= 1 << flag.ordinal();
            }
            return i;
        }
    }

    static class Execute
    extends Message.Request {
        static final Message.Coder<Execute> coder = new Message.Coder<Execute>(){

            @Override
            public void encode(Execute msg, ByteBuf dest, ProtocolVersion version) {
                CBUtil.writeBytes(msg.statementId.bytes, dest);
                msg.options.encode(dest, version);
            }

            @Override
            public int encodedSize(Execute msg, ProtocolVersion version) {
                return CBUtil.sizeOfBytes(msg.statementId.bytes) + msg.options.encodedSize(version);
            }
        };
        final MD5Digest statementId;
        final QueryProtocolOptions options;

        Execute(MD5Digest statementId, QueryProtocolOptions options, boolean tracingRequested) {
            super(Message.Request.Type.EXECUTE, tracingRequested);
            this.statementId = statementId;
            this.options = options;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Execute(this.statementId, this.options, this.isTracingRequested());
        }

        @Override
        protected Message.Request copyInternal(ConsistencyLevel newConsistencyLevel) {
            return new Execute(this.statementId, this.options.copy(newConsistencyLevel), this.isTracingRequested());
        }

        public String toString() {
            return "EXECUTE " + this.statementId + " (" + this.options + ')';
        }
    }

    static class Query
    extends Message.Request {
        static final Message.Coder<Query> coder = new Message.Coder<Query>(){

            @Override
            public void encode(Query msg, ByteBuf dest, ProtocolVersion version) {
                CBUtil.writeLongString(msg.query, dest);
                msg.options.encode(dest, version);
            }

            @Override
            public int encodedSize(Query msg, ProtocolVersion version) {
                return CBUtil.sizeOfLongString(msg.query) + msg.options.encodedSize(version);
            }
        };
        final String query;
        final QueryProtocolOptions options;

        Query(String query) {
            this(query, QueryProtocolOptions.DEFAULT, false);
        }

        Query(String query, QueryProtocolOptions options, boolean tracingRequested) {
            super(Message.Request.Type.QUERY, tracingRequested);
            this.query = query;
            this.options = options;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Query(this.query, this.options, this.isTracingRequested());
        }

        @Override
        protected Message.Request copyInternal(ConsistencyLevel newConsistencyLevel) {
            return new Query(this.query, this.options.copy(newConsistencyLevel), this.isTracingRequested());
        }

        public String toString() {
            return "QUERY " + this.query + '(' + this.options + ')';
        }
    }

    static class Options
    extends Message.Request {
        static final Message.Coder<Options> coder = new Message.Coder<Options>(){

            @Override
            public void encode(Options msg, ByteBuf dest, ProtocolVersion version) {
            }

            @Override
            public int encodedSize(Options msg, ProtocolVersion version) {
                return 0;
            }
        };

        Options() {
            super(Message.Request.Type.OPTIONS);
        }

        @Override
        protected Message.Request copyInternal() {
            return new Options();
        }

        public String toString() {
            return "OPTIONS";
        }
    }

    static class Credentials
    extends Message.Request {
        static final Message.Coder<Credentials> coder = new Message.Coder<Credentials>(){

            @Override
            public void encode(Credentials msg, ByteBuf dest, ProtocolVersion version) {
                assert (version == ProtocolVersion.V1);
                CBUtil.writeStringMap(msg.credentials, dest);
            }

            @Override
            public int encodedSize(Credentials msg, ProtocolVersion version) {
                assert (version == ProtocolVersion.V1);
                return CBUtil.sizeOfStringMap(msg.credentials);
            }
        };
        private final Map<String, String> credentials;

        Credentials(Map<String, String> credentials) {
            super(Message.Request.Type.CREDENTIALS);
            this.credentials = credentials;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Credentials(this.credentials);
        }
    }

    static class Startup
    extends Message.Request {
        private static final String CQL_VERSION_OPTION = "CQL_VERSION";
        private static final String CQL_VERSION = "3.0.0";
        static final String COMPRESSION_OPTION = "COMPRESSION";
        static final Message.Coder<Startup> coder = new Message.Coder<Startup>(){

            @Override
            public void encode(Startup msg, ByteBuf dest, ProtocolVersion version) {
                CBUtil.writeStringMap(msg.options, dest);
            }

            @Override
            public int encodedSize(Startup msg, ProtocolVersion version) {
                return CBUtil.sizeOfStringMap(msg.options);
            }
        };
        private final Map<String, String> options;
        private final ProtocolOptions.Compression compression;

        Startup(ProtocolOptions.Compression compression) {
            super(Message.Request.Type.STARTUP);
            this.compression = compression;
            ImmutableMap.Builder map = new ImmutableMap.Builder();
            map.put((Object)CQL_VERSION_OPTION, (Object)CQL_VERSION);
            if (compression != ProtocolOptions.Compression.NONE) {
                map.put((Object)COMPRESSION_OPTION, (Object)compression.toString());
            }
            this.options = map.build();
        }

        @Override
        protected Message.Request copyInternal() {
            return new Startup(this.compression);
        }

        public String toString() {
            return "STARTUP " + this.options;
        }
    }
}

