/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ExceptionCode;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.ProtocolEvent;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SchemaElement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.BootstrappingException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.FunctionExecutionException;
import com.datastax.driver.core.exceptions.InvalidConfigurationInQueryException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.ProtocolError;
import com.datastax.driver.core.exceptions.ReadFailureException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.ServerError;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.TruncateException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.UnpreparedException;
import com.datastax.driver.core.exceptions.WriteFailureException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.utils.Bytes;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

class Responses {
    private Responses() {
    }

    public static class AuthSuccess
    extends Message.Response {
        public static final Message.Decoder<AuthSuccess> decoder = new Message.Decoder<AuthSuccess>(){

            @Override
            public AuthSuccess decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                ByteBuffer b = CBUtil.readValue(body);
                if (b == null) {
                    return new AuthSuccess(null);
                }
                byte[] token = new byte[b.remaining()];
                b.get(token);
                return new AuthSuccess(token);
            }
        };
        public final byte[] token;

        private AuthSuccess(byte[] token) {
            super(Message.Response.Type.AUTH_SUCCESS);
            this.token = token;
        }
    }

    public static class AuthChallenge
    extends Message.Response {
        public static final Message.Decoder<AuthChallenge> decoder = new Message.Decoder<AuthChallenge>(){

            @Override
            public AuthChallenge decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                ByteBuffer b = CBUtil.readValue(body);
                if (b == null) {
                    return new AuthChallenge(null);
                }
                byte[] token = new byte[b.remaining()];
                b.get(token);
                return new AuthChallenge(token);
            }
        };
        public final byte[] token;

        private AuthChallenge(byte[] token) {
            super(Message.Response.Type.AUTH_CHALLENGE);
            this.token = token;
        }
    }

    public static class Event
    extends Message.Response {
        public static final Message.Decoder<Event> decoder = new Message.Decoder<Event>(){

            @Override
            public Event decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                return new Event(ProtocolEvent.deserialize(body, version));
            }
        };
        public final ProtocolEvent event;

        public Event(ProtocolEvent event) {
            super(Message.Response.Type.EVENT);
            this.event = event;
        }

        public String toString() {
            return "EVENT " + this.event;
        }
    }

    public static abstract class Result
    extends Message.Response {
        public static final Message.Decoder<Result> decoder = new Message.Decoder<Result>(){

            @Override
            public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                Kind kind = Kind.fromId(body.readInt());
                return kind.subDecoder.decode(body, version, codecRegistry);
            }
        };
        public final Kind kind;

        protected Result(Kind kind) {
            super(Message.Response.Type.RESULT);
            this.kind = kind;
        }

        public static class SchemaChange
        extends Result {
            public final Change change;
            public final SchemaElement targetType;
            public final String targetKeyspace;
            public final String targetName;
            public final List<String> targetSignature;
            public static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    switch (version) {
                        case V1: 
                        case V2: {
                            Change change = CBUtil.readEnumValue(Change.class, body);
                            String targetKeyspace = CBUtil.readString(body);
                            String targetName = CBUtil.readString(body);
                            SchemaElement targetType = targetName.isEmpty() ? SchemaElement.KEYSPACE : SchemaElement.TABLE;
                            List targetSignature = Collections.emptyList();
                            return new SchemaChange(change, targetType, targetKeyspace, targetName, targetSignature);
                        }
                        case V3: 
                        case V4: {
                            Change change = CBUtil.readEnumValue(Change.class, body);
                            SchemaElement targetType = CBUtil.readEnumValue(SchemaElement.class, body);
                            String targetKeyspace = CBUtil.readString(body);
                            String targetName = targetType == SchemaElement.KEYSPACE ? "" : CBUtil.readString(body);
                            List<String> targetSignature = targetType == SchemaElement.FUNCTION || targetType == SchemaElement.AGGREGATE ? CBUtil.readStringList(body) : Collections.emptyList();
                            return new SchemaChange(change, targetType, targetKeyspace, targetName, targetSignature);
                        }
                    }
                    throw version.unsupported();
                }
            };

            private SchemaChange(Change change, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature) {
                super(Kind.SCHEMA_CHANGE);
                this.change = change;
                this.targetType = targetType;
                this.targetKeyspace = targetKeyspace;
                this.targetName = targetName;
                this.targetSignature = targetSignature;
            }

            public String toString() {
                return "RESULT schema change " + (Object)((Object)this.change) + " on " + (Object)((Object)this.targetType) + ' ' + this.targetKeyspace + (this.targetName.isEmpty() ? "" : '.' + this.targetName);
            }

            public static enum Change {
                CREATED,
                UPDATED,
                DROPPED;

            }
        }

        public static class Prepared
        extends Result {
            public static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    MD5Digest id = MD5Digest.wrap(CBUtil.readBytes(body));
                    boolean withPkIndices = version.compareTo(ProtocolVersion.V4) >= 0;
                    Rows.Metadata metadata = Rows.Metadata.decode(body, withPkIndices, version, codecRegistry);
                    Rows.Metadata resultMetadata = this.decodeResultMetadata(body, version, codecRegistry);
                    return new Prepared(id, metadata, resultMetadata);
                }

                private Rows.Metadata decodeResultMetadata(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    switch (version) {
                        case V1: {
                            return Rows.Metadata.EMPTY;
                        }
                        case V2: 
                        case V3: 
                        case V4: {
                            return Rows.Metadata.decode(body, version, codecRegistry);
                        }
                    }
                    throw version.unsupported();
                }
            };
            public final MD5Digest statementId;
            public final Rows.Metadata metadata;
            public final Rows.Metadata resultMetadata;

            private Prepared(MD5Digest statementId, Rows.Metadata metadata, Rows.Metadata resultMetadata) {
                super(Kind.PREPARED);
                this.statementId = statementId;
                this.metadata = metadata;
                this.resultMetadata = resultMetadata;
            }

            public String toString() {
                return "RESULT PREPARED " + this.statementId + ' ' + this.metadata + " (resultMetadata=" + this.resultMetadata + ')';
            }
        }

        public static class Rows
        extends Result {
            public static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    Metadata metadata = Metadata.decode(body, version, codecRegistry);
                    int rowCount = body.readInt();
                    int columnCount = metadata.columnCount;
                    ArrayDeque data = new ArrayDeque(rowCount);
                    for (int i = 0; i < rowCount; ++i) {
                        ArrayList<ByteBuffer> row = new ArrayList<ByteBuffer>(columnCount);
                        for (int j = 0; j < columnCount; ++j) {
                            row.add(CBUtil.readValue(body));
                        }
                        data.add(row);
                    }
                    return new Rows(metadata, data, version);
                }
            };
            public final Metadata metadata;
            public final Queue<List<ByteBuffer>> data;
            private final ProtocolVersion version;

            private Rows(Metadata metadata, Queue<List<ByteBuffer>> data, ProtocolVersion version) {
                super(Kind.ROWS);
                this.metadata = metadata;
                this.data = data;
                this.version = version;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("ROWS ").append(this.metadata).append('\n');
                for (List list : this.data) {
                    for (int i = 0; i < list.size(); ++i) {
                        ByteBuffer v = (ByteBuffer)list.get(i);
                        if (v == null) {
                            sb.append(" | null");
                            continue;
                        }
                        sb.append(" | ");
                        if (this.metadata.columns != null) {
                            DataType dataType = this.metadata.columns.getType(i);
                            sb.append(dataType);
                            sb.append(" ");
                            TypeCodec codec = this.metadata.columns.codecRegistry.codecFor(dataType);
                            Object o = codec.deserialize(v, this.version);
                            String s = codec.format(o);
                            if (s.length() > 100) {
                                s = s.substring(0, 100) + "...";
                            }
                            sb.append(s);
                            continue;
                        }
                        sb.append(Bytes.toHexString(v));
                    }
                    sb.append('\n');
                }
                sb.append("---");
                return sb.toString();
            }

            public static class Metadata {
                static final Metadata EMPTY = new Metadata(0, null, null, null);
                public final int columnCount;
                public final ColumnDefinitions columns;
                public final ByteBuffer pagingState;
                public final int[] pkIndices;

                private Metadata(int columnCount, ColumnDefinitions columns, ByteBuffer pagingState, int[] pkIndices) {
                    this.columnCount = columnCount;
                    this.columns = columns;
                    this.pagingState = pagingState;
                    this.pkIndices = pkIndices;
                }

                public static Metadata decode(ByteBuf body, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
                    return Metadata.decode(body, false, protocolVersion, codecRegistry);
                }

                public static Metadata decode(ByteBuf body, boolean withPkIndices, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
                    int pkCount;
                    EnumSet<Flag> flags = Flag.deserialize(body.readInt());
                    int columnCount = body.readInt();
                    int[] pkIndices = null;
                    if (withPkIndices && (pkCount = body.readInt()) > 0) {
                        pkIndices = new int[pkCount];
                        for (int i = 0; i < pkCount; ++i) {
                            pkIndices[i] = body.readShort();
                        }
                    }
                    ByteBuffer state = null;
                    if (flags.contains((Object)Flag.HAS_MORE_PAGES)) {
                        state = CBUtil.readValue(body);
                    }
                    if (flags.contains((Object)Flag.NO_METADATA)) {
                        return new Metadata(columnCount, null, state, pkIndices);
                    }
                    boolean globalTablesSpec = flags.contains((Object)Flag.GLOBAL_TABLES_SPEC);
                    String globalKsName = null;
                    String globalCfName = null;
                    if (globalTablesSpec) {
                        globalKsName = CBUtil.readString(body);
                        globalCfName = CBUtil.readString(body);
                    }
                    ColumnDefinitions.Definition[] defs = new ColumnDefinitions.Definition[columnCount];
                    for (int i = 0; i < columnCount; ++i) {
                        String ksName = globalTablesSpec ? globalKsName : CBUtil.readString(body);
                        String cfName = globalTablesSpec ? globalCfName : CBUtil.readString(body);
                        String name = CBUtil.readString(body);
                        DataType type = DataType.decode(body, protocolVersion, codecRegistry);
                        defs[i] = new ColumnDefinitions.Definition(ksName, cfName, name, type);
                    }
                    return new Metadata(columnCount, new ColumnDefinitions(defs, codecRegistry), state, pkIndices);
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder();
                    if (this.columns == null) {
                        sb.append('[').append(this.columnCount).append(" columns]");
                    } else {
                        for (ColumnDefinitions.Definition column : this.columns) {
                            sb.append('[').append(column.getName());
                            sb.append(" (").append(column.getType()).append(")]");
                        }
                    }
                    if (this.pagingState != null) {
                        sb.append(" (to be continued)");
                    }
                    return sb.toString();
                }

                private static enum Flag {
                    GLOBAL_TABLES_SPEC,
                    HAS_MORE_PAGES,
                    NO_METADATA;


                    public static EnumSet<Flag> deserialize(int flags) {
                        EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                        Flag[] values = Flag.values();
                        for (int n = 0; n < values.length; ++n) {
                            if ((flags & 1 << n) == 0) continue;
                            set.add(values[n]);
                        }
                        return set;
                    }

                    public static int serialize(EnumSet<Flag> flags) {
                        int i = 0;
                        for (Flag flag : flags) {
                            i |= 1 << flag.ordinal();
                        }
                        return i;
                    }
                }
            }
        }

        public static class SetKeyspace
        extends Result {
            public final String keyspace;
            public static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    return new SetKeyspace(CBUtil.readString(body));
                }
            };

            private SetKeyspace(String keyspace) {
                super(Kind.SET_KEYSPACE);
                this.keyspace = keyspace;
            }

            public String toString() {
                return "RESULT set keyspace " + this.keyspace;
            }
        }

        public static class Void
        extends Result {
            public static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                    return new Void();
                }
            };

            public Void() {
                super(Kind.VOID);
            }

            public String toString() {
                return "EMPTY RESULT";
            }
        }

        public static enum Kind {
            VOID(1, Void.subcodec),
            ROWS(2, Rows.subcodec),
            SET_KEYSPACE(3, SetKeyspace.subcodec),
            PREPARED(4, Prepared.subcodec),
            SCHEMA_CHANGE(5, SchemaChange.subcodec);

            private final int id;
            final Message.Decoder<Result> subDecoder;
            private static final Kind[] ids;

            private Kind(int id, Message.Decoder<Result> subDecoder) {
                this.id = id;
                this.subDecoder = subDecoder;
            }

            public static Kind fromId(int id) {
                Kind k = ids[id];
                if (k == null) {
                    throw new DriverInternalError(String.format("Unknown kind id %d in RESULT message", id));
                }
                return k;
            }

            static {
                int maxId = -1;
                for (Kind k : Kind.values()) {
                    maxId = Math.max(maxId, k.id);
                }
                ids = new Kind[maxId + 1];
                for (Kind k : Kind.values()) {
                    if (ids[k.id] != null) {
                        throw new IllegalStateException("Duplicate kind id");
                    }
                    Kind.ids[k.id] = k;
                }
            }
        }
    }

    public static class Supported
    extends Message.Response {
        public static final Message.Decoder<Supported> decoder = new Message.Decoder<Supported>(){

            @Override
            public Supported decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                return new Supported(CBUtil.readStringToStringListMap(body));
            }
        };
        public final Map<String, List<String>> supported;
        public final Set<ProtocolOptions.Compression> supportedCompressions = EnumSet.noneOf(ProtocolOptions.Compression.class);

        public Supported(Map<String, List<String>> supported) {
            super(Message.Response.Type.SUPPORTED);
            this.supported = supported;
            this.parseCompressions();
        }

        private void parseCompressions() {
            List<String> compList = this.supported.get("COMPRESSION");
            if (compList == null) {
                return;
            }
            for (String compStr : compList) {
                ProtocolOptions.Compression compr = ProtocolOptions.Compression.fromString(compStr);
                if (compr == null) continue;
                this.supportedCompressions.add(compr);
            }
        }

        public String toString() {
            return "SUPPORTED " + this.supported;
        }
    }

    public static class Authenticate
    extends Message.Response {
        public static final Message.Decoder<Authenticate> decoder = new Message.Decoder<Authenticate>(){

            @Override
            public Authenticate decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                String authenticator = CBUtil.readString(body);
                return new Authenticate(authenticator);
            }
        };
        public final String authenticator;

        public Authenticate(String authenticator) {
            super(Message.Response.Type.AUTHENTICATE);
            this.authenticator = authenticator;
        }

        public String toString() {
            return "AUTHENTICATE " + this.authenticator;
        }
    }

    public static class Ready
    extends Message.Response {
        public static final Message.Decoder<Ready> decoder = new Message.Decoder<Ready>(){

            @Override
            public Ready decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                return new Ready();
            }
        };

        public Ready() {
            super(Message.Response.Type.READY);
        }

        public String toString() {
            return "READY";
        }
    }

    public static class Error
    extends Message.Response {
        public static final Message.Decoder<Error> decoder = new Message.Decoder<Error>(){

            @Override
            public Error decode(ByteBuf body, ProtocolVersion version, CodecRegistry codecRegistry) {
                ExceptionCode code = ExceptionCode.fromValue(body.readInt());
                String msg = CBUtil.readString(body);
                Object infos = null;
                switch (code) {
                    case UNAVAILABLE: {
                        ConsistencyLevel clu = CBUtil.readConsistencyLevel(body);
                        int required = body.readInt();
                        int alive = body.readInt();
                        infos = new UnavailableException(clu, required, alive);
                        break;
                    }
                    case WRITE_TIMEOUT: 
                    case READ_TIMEOUT: {
                        ConsistencyLevel clt = CBUtil.readConsistencyLevel(body);
                        int received = body.readInt();
                        int blockFor = body.readInt();
                        if (code == ExceptionCode.WRITE_TIMEOUT) {
                            WriteType writeType = Enum.valueOf(WriteType.class, CBUtil.readString(body));
                            infos = new WriteTimeoutException(clt, writeType, received, blockFor);
                            break;
                        }
                        byte dataPresent = body.readByte();
                        infos = new ReadTimeoutException(clt, received, blockFor, dataPresent != 0);
                        break;
                    }
                    case WRITE_FAILURE: 
                    case READ_FAILURE: {
                        ConsistencyLevel clt = CBUtil.readConsistencyLevel(body);
                        int received = body.readInt();
                        int blockFor = body.readInt();
                        int failures = body.readInt();
                        if (code == ExceptionCode.WRITE_FAILURE) {
                            WriteType writeType = Enum.valueOf(WriteType.class, CBUtil.readString(body));
                            infos = new WriteFailureException(clt, writeType, received, blockFor, failures);
                            break;
                        }
                        byte dataPresent = body.readByte();
                        infos = new ReadFailureException(clt, received, blockFor, failures, dataPresent != 0);
                        break;
                    }
                    case UNPREPARED: {
                        infos = MD5Digest.wrap(CBUtil.readBytes(body));
                        break;
                    }
                    case ALREADY_EXISTS: {
                        String ksName = CBUtil.readString(body);
                        String cfName = CBUtil.readString(body);
                        infos = new AlreadyExistsException(ksName, cfName);
                    }
                }
                return new Error(version, code, msg, infos);
            }
        };
        public final ProtocolVersion serverProtocolVersion;
        public final ExceptionCode code;
        public final String message;
        public final Object infos;

        private Error(ProtocolVersion serverProtocolVersion, ExceptionCode code, String message, Object infos) {
            super(Message.Response.Type.ERROR);
            this.serverProtocolVersion = serverProtocolVersion;
            this.code = code;
            this.message = message;
            this.infos = infos;
        }

        public DriverException asException(InetSocketAddress host) {
            switch (this.code) {
                case SERVER_ERROR: {
                    return new ServerError(host, this.message);
                }
                case PROTOCOL_ERROR: {
                    return new ProtocolError(host, this.message);
                }
                case BAD_CREDENTIALS: {
                    return new AuthenticationException(host, this.message);
                }
                case UNAVAILABLE: {
                    return ((UnavailableException)this.infos).copy(host);
                }
                case OVERLOADED: {
                    return new OverloadedException(host, this.message);
                }
                case IS_BOOTSTRAPPING: {
                    return new BootstrappingException(host, this.message);
                }
                case TRUNCATE_ERROR: {
                    return new TruncateException(host, this.message);
                }
                case WRITE_TIMEOUT: {
                    return ((WriteTimeoutException)this.infos).copy(host);
                }
                case READ_TIMEOUT: {
                    return ((ReadTimeoutException)this.infos).copy(host);
                }
                case WRITE_FAILURE: {
                    return ((WriteFailureException)this.infos).copy(host);
                }
                case READ_FAILURE: {
                    return ((ReadFailureException)this.infos).copy(host);
                }
                case FUNCTION_FAILURE: {
                    return new FunctionExecutionException(host, this.message);
                }
                case SYNTAX_ERROR: {
                    return new SyntaxError(host, this.message);
                }
                case UNAUTHORIZED: {
                    return new UnauthorizedException(host, this.message);
                }
                case INVALID: {
                    return new InvalidQueryException(host, this.message);
                }
                case CONFIG_ERROR: {
                    return new InvalidConfigurationInQueryException(host, this.message);
                }
                case ALREADY_EXISTS: {
                    return ((AlreadyExistsException)this.infos).copy(host);
                }
                case UNPREPARED: {
                    return new UnpreparedException(host, this.message);
                }
            }
            return new DriverInternalError(String.format("Unknown protocol error code %s returned by %s. The error message was: %s", new Object[]{this.code, host, this.message}));
        }

        public String toString() {
            return "ERROR " + (Object)((Object)this.code) + ": " + this.message;
        }
    }
}

