/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SchemaElement;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;

class ProtocolEvent {
    public final Type type;

    private ProtocolEvent(Type type) {
        this.type = type;
    }

    public static ProtocolEvent deserialize(ByteBuf bb, ProtocolVersion version) {
        switch (CBUtil.readEnumValue(Type.class, bb)) {
            case TOPOLOGY_CHANGE: {
                return TopologyChange.deserializeEvent(bb);
            }
            case STATUS_CHANGE: {
                return StatusChange.deserializeEvent(bb);
            }
            case SCHEMA_CHANGE: {
                return SchemaChange.deserializeEvent(bb, version);
            }
        }
        throw new AssertionError();
    }

    public static class SchemaChange
    extends ProtocolEvent {
        public final Change change;
        public final SchemaElement targetType;
        public final String targetKeyspace;
        public final String targetName;
        public final List<String> targetSignature;

        public SchemaChange(Change change, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature) {
            super(Type.SCHEMA_CHANGE);
            this.change = change;
            this.targetType = targetType;
            this.targetKeyspace = targetKeyspace;
            this.targetName = targetName;
            this.targetSignature = targetSignature;
        }

        private static SchemaChange deserializeEvent(ByteBuf bb, ProtocolVersion version) {
            switch (version) {
                case V1: 
                case V2: {
                    Change change = CBUtil.readEnumValue(Change.class, bb);
                    String targetKeyspace = CBUtil.readString(bb);
                    String targetName = CBUtil.readString(bb);
                    SchemaElement targetType = targetName.isEmpty() ? SchemaElement.KEYSPACE : SchemaElement.TABLE;
                    List<String> targetSignature = Collections.emptyList();
                    return new SchemaChange(change, targetType, targetKeyspace, targetName, targetSignature);
                }
                case V3: 
                case V4: {
                    Change change = CBUtil.readEnumValue(Change.class, bb);
                    SchemaElement targetType = CBUtil.readEnumValue(SchemaElement.class, bb);
                    String targetKeyspace = CBUtil.readString(bb);
                    String targetName = targetType == SchemaElement.KEYSPACE ? "" : CBUtil.readString(bb);
                    List<String> targetSignature = targetType == SchemaElement.FUNCTION || targetType == SchemaElement.AGGREGATE ? CBUtil.readStringList(bb) : Collections.emptyList();
                    return new SchemaChange(change, targetType, targetKeyspace, targetName, targetSignature);
                }
            }
            throw version.unsupported();
        }

        public String toString() {
            return this.change.toString() + ' ' + (Object)((Object)this.targetType) + ' ' + this.targetKeyspace + (this.targetName.isEmpty() ? "" : '.' + this.targetName);
        }

        public static enum Change {
            CREATED,
            UPDATED,
            DROPPED;

        }
    }

    public static class StatusChange
    extends ProtocolEvent {
        public final Status status;
        public final InetSocketAddress node;

        private StatusChange(Status status, InetSocketAddress node) {
            super(Type.STATUS_CHANGE);
            this.status = status;
            this.node = node;
        }

        private static StatusChange deserializeEvent(ByteBuf bb) {
            Status status = CBUtil.readEnumValue(Status.class, bb);
            InetSocketAddress node = CBUtil.readInet(bb);
            return new StatusChange(status, node);
        }

        public String toString() {
            return (Object)((Object)this.status) + " " + this.node;
        }

        public static enum Status {
            UP,
            DOWN;

        }
    }

    public static class TopologyChange
    extends ProtocolEvent {
        public final Change change;
        public final InetSocketAddress node;

        private TopologyChange(Change change, InetSocketAddress node) {
            super(Type.TOPOLOGY_CHANGE);
            this.change = change;
            this.node = node;
        }

        private static TopologyChange deserializeEvent(ByteBuf bb) {
            Change change = CBUtil.readEnumValue(Change.class, bb);
            InetSocketAddress node = CBUtil.readInet(bb);
            return new TopologyChange(change, node);
        }

        public String toString() {
            return (Object)((Object)this.change) + " " + this.node;
        }

        public static enum Change {
            NEW_NODE,
            REMOVED_NODE,
            MOVED_NODE;

        }
    }

    public static enum Type {
        TOPOLOGY_CHANGE,
        STATUS_CHANGE,
        SCHEMA_CHANGE;

    }
}

