/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleJSONParser;
import com.datastax.driver.core.VersionNumber;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

abstract class TableOrView {
    static final Comparator<ColumnMetadata> columnMetadataComparator = new Comparator<ColumnMetadata>(){

        @Override
        public int compare(ColumnMetadata c1, ColumnMetadata c2) {
            return c1.getName().compareTo(c2.getName());
        }
    };
    protected final KeyspaceMetadata keyspace;
    protected final String name;
    protected final UUID id;
    protected final List<ColumnMetadata> partitionKey;
    protected final List<ColumnMetadata> clusteringColumns;
    protected final Map<String, ColumnMetadata> columns;
    protected final Options options;
    protected final List<Order> clusteringOrder;
    protected final VersionNumber cassandraVersion;

    TableOrView(KeyspaceMetadata keyspace, String name, UUID id, List<ColumnMetadata> partitionKey, List<ColumnMetadata> clusteringColumns, Map<String, ColumnMetadata> columns, Options options, List<Order> clusteringOrder, VersionNumber cassandraVersion) {
        this.keyspace = keyspace;
        this.name = name;
        this.id = id;
        this.partitionKey = partitionKey;
        this.clusteringColumns = clusteringColumns;
        this.columns = columns;
        this.options = options;
        this.clusteringOrder = clusteringOrder;
        this.cassandraVersion = cassandraVersion;
    }

    protected static <T> List<T> nullInitializedList(int size) {
        ArrayList<Object> l = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            l.add(null);
        }
        return l;
    }

    public String getName() {
        return this.name;
    }

    public UUID getId() {
        return this.id;
    }

    public KeyspaceMetadata getKeyspace() {
        return this.keyspace;
    }

    public ColumnMetadata getColumn(String name) {
        return this.columns.get(Metadata.handleId(name));
    }

    public List<ColumnMetadata> getColumns() {
        return new ArrayList<ColumnMetadata>(this.columns.values());
    }

    public List<ColumnMetadata> getPrimaryKey() {
        ArrayList<ColumnMetadata> pk = new ArrayList<ColumnMetadata>(this.partitionKey.size() + this.clusteringColumns.size());
        pk.addAll(this.partitionKey);
        pk.addAll(this.clusteringColumns);
        return pk;
    }

    public List<ColumnMetadata> getPartitionKey() {
        return Collections.unmodifiableList(this.partitionKey);
    }

    public List<ColumnMetadata> getClusteringColumns() {
        return Collections.unmodifiableList(this.clusteringColumns);
    }

    public List<Order> getClusteringOrder() {
        return this.clusteringOrder;
    }

    public Options getOptions() {
        return this.options;
    }

    void add(ColumnMetadata column) {
        this.columns.put(column.getName(), column);
    }

    public String exportAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.asCQLQuery(true));
        return sb.toString();
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    protected abstract String asCQLQuery(boolean var1);

    protected StringBuilder appendOptions(StringBuilder sb, boolean formatted) {
        sb.append(" WITH ");
        if (this.options.isCompactStorage) {
            this.and(sb.append("COMPACT STORAGE"), formatted);
        }
        if (!Iterables.all(this.clusteringOrder, Order.isAscending)) {
            this.and(this.appendClusteringOrder(sb), formatted);
        }
        sb.append("read_repair_chance = ").append(this.options.readRepair);
        this.and(sb, formatted).append("dclocal_read_repair_chance = ").append(this.options.localReadRepair);
        if (this.cassandraVersion.getMajor() < 2 || this.cassandraVersion.getMajor() == 2 && this.cassandraVersion.getMinor() == 0) {
            this.and(sb, formatted).append("replicate_on_write = ").append(this.options.replicateOnWrite);
        }
        this.and(sb, formatted).append("gc_grace_seconds = ").append(this.options.gcGrace);
        this.and(sb, formatted).append("bloom_filter_fp_chance = ").append(this.options.bfFpChance);
        if (this.cassandraVersion.getMajor() < 2 || this.cassandraVersion.getMajor() == 2 && this.cassandraVersion.getMinor() < 1) {
            this.and(sb, formatted).append("caching = '").append((String)this.options.caching.get("keys")).append('\'');
        } else {
            this.and(sb, formatted).append("caching = ").append(TableOrView.formatOptionMap(this.options.caching));
        }
        if (this.options.comment != null) {
            this.and(sb, formatted).append("comment = '").append(this.options.comment.replace("'", "''")).append('\'');
        }
        this.and(sb, formatted).append("compaction = ").append(TableOrView.formatOptionMap(this.options.compaction));
        this.and(sb, formatted).append("compression = ").append(TableOrView.formatOptionMap(this.options.compression));
        if (this.cassandraVersion.getMajor() >= 2) {
            this.and(sb, formatted).append("default_time_to_live = ").append(this.options.defaultTTL);
            this.and(sb, formatted).append("speculative_retry = '").append(this.options.speculativeRetry).append('\'');
            if (this.options.indexInterval != null) {
                this.and(sb, formatted).append("index_interval = ").append(this.options.indexInterval);
            }
        }
        if (this.cassandraVersion.getMajor() > 2 || this.cassandraVersion.getMajor() == 2 && this.cassandraVersion.getMinor() >= 1) {
            this.and(sb, formatted).append("min_index_interval = ").append(this.options.minIndexInterval);
            this.and(sb, formatted).append("max_index_interval = ").append(this.options.maxIndexInterval);
        }
        if (this.cassandraVersion.getMajor() > 2) {
            this.and(sb, formatted).append("crc_check_chance = ").append(this.options.crcCheckChance);
        }
        sb.append(';');
        return sb;
    }

    public String toString() {
        return this.asCQLQuery();
    }

    private StringBuilder appendClusteringOrder(StringBuilder sb) {
        sb.append("CLUSTERING ORDER BY (");
        for (int i = 0; i < this.clusteringColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.clusteringColumns.get(i).getName()).append(' ').append((Object)this.clusteringOrder.get(i));
        }
        return sb.append(')');
    }

    private static String formatOptionMap(Map<String, String> m) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append('\'').append(entry.getKey()).append('\'');
            sb.append(" : ");
            try {
                sb.append(Integer.parseInt(entry.getValue()));
            }
            catch (NumberFormatException e) {
                sb.append('\'').append(entry.getValue()).append('\'');
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    private StringBuilder and(StringBuilder sb, boolean formatted) {
        return TableOrView.newLine(sb, formatted).append(TableOrView.spaces(2, formatted)).append(" AND ");
    }

    static String spaces(int n, boolean formatted) {
        if (!formatted) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    static StringBuilder newLine(StringBuilder sb, boolean formatted) {
        if (formatted) {
            sb.append('\n');
        }
        return sb;
    }

    static StringBuilder spaceOrNewLine(StringBuilder sb, boolean formatted) {
        sb.append(formatted ? (char)'\n' : ' ');
        return sb;
    }

    public static class Options {
        private static final String COMMENT = "comment";
        private static final String READ_REPAIR = "read_repair_chance";
        private static final String DCLOCAL_READ_REPAIR = "dclocal_read_repair_chance";
        private static final String LOCAL_READ_REPAIR = "local_read_repair_chance";
        private static final String REPLICATE_ON_WRITE = "replicate_on_write";
        private static final String GC_GRACE = "gc_grace_seconds";
        private static final String BF_FP_CHANCE = "bloom_filter_fp_chance";
        private static final String CACHING = "caching";
        private static final String COMPACTION = "compaction";
        private static final String COMPACTION_CLASS = "compaction_strategy_class";
        private static final String COMPACTION_OPTIONS = "compaction_strategy_options";
        private static final String POPULATE_CACHE_ON_FLUSH = "populate_io_cache_on_flush";
        private static final String COMPRESSION = "compression";
        private static final String COMPRESSION_PARAMS = "compression_parameters";
        private static final String MEMTABLE_FLUSH_PERIOD_MS = "memtable_flush_period_in_ms";
        private static final String DEFAULT_TTL = "default_time_to_live";
        private static final String SPECULATIVE_RETRY = "speculative_retry";
        private static final String INDEX_INTERVAL = "index_interval";
        private static final String MIN_INDEX_INTERVAL = "min_index_interval";
        private static final String MAX_INDEX_INTERVAL = "max_index_interval";
        private static final String CRC_CHECK_CHANCE = "crc_check_chance";
        private static final boolean DEFAULT_REPLICATE_ON_WRITE = true;
        private static final double DEFAULT_BF_FP_CHANCE = 0.01;
        private static final boolean DEFAULT_POPULATE_CACHE_ON_FLUSH = false;
        private static final int DEFAULT_MEMTABLE_FLUSH_PERIOD = 0;
        private static final int DEFAULT_DEFAULT_TTL = 0;
        private static final String DEFAULT_SPECULATIVE_RETRY = "NONE";
        private static final int DEFAULT_INDEX_INTERVAL = 128;
        private static final int DEFAULT_MIN_INDEX_INTERVAL = 128;
        private static final int DEFAULT_MAX_INDEX_INTERVAL = 2048;
        private static final double DEFAULT_CRC_CHECK_CHANCE = 1.0;
        private final boolean isCompactStorage;
        private final String comment;
        private final double readRepair;
        private final double localReadRepair;
        private final boolean replicateOnWrite;
        private final int gcGrace;
        private final double bfFpChance;
        private final Map<String, String> caching;
        private final boolean populateCacheOnFlush;
        private final int memtableFlushPeriodMs;
        private final int defaultTTL;
        private final String speculativeRetry;
        private final Integer indexInterval;
        private final Integer minIndexInterval;
        private final Integer maxIndexInterval;
        private final Map<String, String> compaction;
        private final Map<String, String> compression;
        private final Double crcCheckChance;

        Options(Row row, boolean isCompactStorage, VersionNumber version) {
            boolean is120 = version.getMajor() < 2;
            boolean is200 = version.getMajor() == 2 && version.getMinor() == 0;
            boolean is210 = version.getMajor() == 2 && version.getMinor() >= 1;
            boolean is300OrHigher = version.getMajor() > 2;
            boolean is210OrHigher = is210 || is300OrHigher;
            this.isCompactStorage = isCompactStorage;
            this.comment = Options.isNullOrAbsent(row, COMMENT) ? "" : row.getString(COMMENT);
            this.readRepair = row.getDouble(READ_REPAIR);
            this.localReadRepair = is300OrHigher ? row.getDouble(DCLOCAL_READ_REPAIR) : row.getDouble(LOCAL_READ_REPAIR);
            this.replicateOnWrite = is210OrHigher || Options.isNullOrAbsent(row, REPLICATE_ON_WRITE) ? true : row.getBool(REPLICATE_ON_WRITE);
            this.gcGrace = row.getInt(GC_GRACE);
            this.bfFpChance = Options.isNullOrAbsent(row, BF_FP_CHANCE) ? 0.01 : row.getDouble(BF_FP_CHANCE);
            this.populateCacheOnFlush = Options.isNullOrAbsent(row, POPULATE_CACHE_ON_FLUSH) ? false : row.getBool(POPULATE_CACHE_ON_FLUSH);
            this.memtableFlushPeriodMs = is120 || Options.isNullOrAbsent(row, MEMTABLE_FLUSH_PERIOD_MS) ? 0 : row.getInt(MEMTABLE_FLUSH_PERIOD_MS);
            this.defaultTTL = is120 || Options.isNullOrAbsent(row, DEFAULT_TTL) ? 0 : row.getInt(DEFAULT_TTL);
            String string = this.speculativeRetry = is120 || Options.isNullOrAbsent(row, SPECULATIVE_RETRY) ? DEFAULT_SPECULATIVE_RETRY : row.getString(SPECULATIVE_RETRY);
            this.indexInterval = is200 ? Integer.valueOf(Options.isNullOrAbsent(row, INDEX_INTERVAL) ? 128 : row.getInt(INDEX_INTERVAL)) : null;
            if (is210OrHigher) {
                this.minIndexInterval = Options.isNullOrAbsent(row, MIN_INDEX_INTERVAL) ? 128 : row.getInt(MIN_INDEX_INTERVAL);
                this.maxIndexInterval = Options.isNullOrAbsent(row, MAX_INDEX_INTERVAL) ? 2048 : row.getInt(MAX_INDEX_INTERVAL);
            } else {
                this.minIndexInterval = null;
                this.maxIndexInterval = null;
            }
            this.caching = is300OrHigher ? ImmutableMap.copyOf(row.getMap(CACHING, String.class, String.class)) : (is210 ? ImmutableMap.copyOf(SimpleJSONParser.parseStringMap(row.getString(CACHING))) : ImmutableMap.of((Object)"keys", (Object)row.getString(CACHING)));
            this.compaction = is300OrHigher ? ImmutableMap.copyOf(row.getMap(COMPACTION, String.class, String.class)) : ImmutableMap.builder().put((Object)"class", (Object)row.getString(COMPACTION_CLASS)).putAll(SimpleJSONParser.parseStringMap(row.getString(COMPACTION_OPTIONS))).build();
            this.compression = is300OrHigher ? ImmutableMap.copyOf(row.getMap(COMPRESSION, String.class, String.class)) : ImmutableMap.copyOf(SimpleJSONParser.parseStringMap(row.getString(COMPRESSION_PARAMS)));
            this.crcCheckChance = is300OrHigher ? Double.valueOf(Options.isNullOrAbsent(row, CRC_CHECK_CHANCE) ? 1.0 : row.getDouble(CRC_CHECK_CHANCE)) : null;
        }

        private static boolean isNullOrAbsent(Row row, String name) {
            return row.getColumnDefinitions().getIndexOf(name) < 0 || row.isNull(name);
        }

        public boolean isCompactStorage() {
            return this.isCompactStorage;
        }

        public String getComment() {
            return this.comment;
        }

        public double getReadRepairChance() {
            return this.readRepair;
        }

        public double getLocalReadRepairChance() {
            return this.localReadRepair;
        }

        public boolean getReplicateOnWrite() {
            return this.replicateOnWrite;
        }

        public int getGcGraceInSeconds() {
            return this.gcGrace;
        }

        public double getBloomFilterFalsePositiveChance() {
            return this.bfFpChance;
        }

        public Map<String, String> getCaching() {
            return this.caching;
        }

        public boolean getPopulateIOCacheOnFlush() {
            return this.populateCacheOnFlush;
        }

        public int getMemtableFlushPeriodInMs() {
            return this.memtableFlushPeriodMs;
        }

        public int getDefaultTimeToLive() {
            return this.defaultTTL;
        }

        public String getSpeculativeRetry() {
            return this.speculativeRetry;
        }

        public Integer getIndexInterval() {
            return this.indexInterval;
        }

        public Integer getMinIndexInterval() {
            return this.minIndexInterval;
        }

        public Integer getMaxIndexInterval() {
            return this.maxIndexInterval;
        }

        public Double getCrcCheckChance() {
            return this.crcCheckChance;
        }

        public Map<String, String> getCompaction() {
            return this.compaction;
        }

        public Map<String, String> getCompression() {
            return this.compression;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Options)) {
                return false;
            }
            Options that = (Options)other;
            return this.isCompactStorage == that.isCompactStorage && Objects.equal((Object)this.comment, (Object)that.comment) && this.readRepair == that.readRepair && this.localReadRepair == that.localReadRepair && this.replicateOnWrite == that.replicateOnWrite && this.gcGrace == that.gcGrace && this.bfFpChance == that.bfFpChance && Objects.equal(this.caching, that.caching) && this.populateCacheOnFlush == that.populateCacheOnFlush && this.memtableFlushPeriodMs == that.memtableFlushPeriodMs && this.defaultTTL == that.defaultTTL && Objects.equal((Object)this.speculativeRetry, (Object)that.speculativeRetry) && Objects.equal((Object)this.indexInterval, (Object)that.indexInterval) && Objects.equal((Object)this.minIndexInterval, (Object)that.minIndexInterval) && Objects.equal((Object)this.maxIndexInterval, (Object)that.maxIndexInterval) && Objects.equal(this.compaction, that.compaction) && Objects.equal(this.compression, that.compression);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.isCompactStorage, this.comment, this.readRepair, this.localReadRepair, this.replicateOnWrite, this.gcGrace, this.bfFpChance, this.caching, this.populateCacheOnFlush, this.memtableFlushPeriodMs, this.defaultTTL, this.speculativeRetry, this.indexInterval, this.minIndexInterval, this.maxIndexInterval, this.compaction, this.compression});
        }
    }

    public static enum Order {
        ASC,
        DESC;

        static final Predicate<Order> isAscending;

        static {
            isAscending = new Predicate<Order>(){

                public boolean apply(Order o) {
                    return o == ASC;
                }
            };
        }
    }
}

