/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CassandraTypeParser;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionMetadata {
    private static final Logger logger = LoggerFactory.getLogger(FunctionMetadata.class);
    private final KeyspaceMetadata keyspace;
    private final String fullName;
    private final String simpleName;
    private final Map<String, DataType> arguments;
    private final String body;
    private final boolean calledOnNullInput;
    private final String language;
    private final DataType returnType;

    private FunctionMetadata(KeyspaceMetadata keyspace, String fullName, String simpleName, Map<String, DataType> arguments, String body, boolean calledOnNullInput, String language, DataType returnType) {
        this.keyspace = keyspace;
        this.fullName = fullName;
        this.simpleName = simpleName;
        this.arguments = arguments;
        this.body = body;
        this.calledOnNullInput = calledOnNullInput;
        this.language = language;
        this.returnType = returnType;
    }

    static FunctionMetadata build(KeyspaceMetadata ksm, Row row, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        String simpleName = row.getString("function_name");
        List<String> signature = row.getList("signature", String.class);
        String fullName = Metadata.fullFunctionName(simpleName, signature);
        List<String> argumentNames = row.getList("argument_names", String.class);
        List<String> argumentTypes = row.getList("argument_types", String.class);
        if (argumentNames.size() != argumentTypes.size()) {
            logger.error(String.format("Error parsing definition of function %1$s.%2$s: the number of argument names and types don't match.Cluster.getMetadata().getKeyspace(\"%1$s\").getFunction(\"%2$s\") will be missing.", ksm.getName(), fullName));
            return null;
        }
        Map<String, DataType> arguments = FunctionMetadata.buildArguments(argumentNames, argumentTypes, protocolVersion, codecRegistry);
        String body = row.getString("body");
        boolean calledOnNullInput = row.getBool("called_on_null_input");
        String language = row.getString("language");
        DataType returnType = CassandraTypeParser.parseOne(row.getString("return_type"), protocolVersion, codecRegistry);
        FunctionMetadata function = new FunctionMetadata(ksm, fullName, simpleName, arguments, body, calledOnNullInput, language, returnType);
        ksm.add(function);
        return function;
    }

    private static Map<String, DataType> buildArguments(List<String> names, List<String> types, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        if (names.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterator<String> iterTypes = types.iterator();
        for (String name : names) {
            DataType type = CassandraTypeParser.parseOne(iterTypes.next(), protocolVersion, codecRegistry);
            builder.put((Object)name, (Object)type);
        }
        return builder.build();
    }

    public String exportAsString() {
        return this.asCQLQuery(true);
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    public String toString() {
        return this.asCQLQuery(false);
    }

    private String asCQLQuery(boolean formatted) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE FUNCTION ").append(Metadata.escapeId(this.keyspace.getName())).append('.').append(Metadata.escapeId(this.simpleName)).append('(');
        boolean first = true;
        for (Map.Entry<String, DataType> entry : this.arguments.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            TableMetadata.newLine(sb, formatted);
            String name = entry.getKey();
            DataType type = entry.getValue();
            sb.append(TableMetadata.spaces(4, formatted)).append(Metadata.escapeId(name)).append(' ').append(type);
        }
        sb.append(')');
        TableMetadata.spaceOrNewLine(sb, formatted).append(this.calledOnNullInput ? "CALLED ON NULL INPUT" : "RETURNS NULL ON NULL INPUT");
        TableMetadata.spaceOrNewLine(sb, formatted).append("RETURNS ").append(this.returnType);
        TableMetadata.spaceOrNewLine(sb, formatted).append("LANGUAGE ").append(this.language);
        TableMetadata.spaceOrNewLine(sb, formatted).append("AS '").append(this.body).append("';");
        return sb.toString();
    }

    public KeyspaceMetadata getKeyspace() {
        return this.keyspace;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public Map<String, DataType> getArguments() {
        return this.arguments;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isCalledOnNullInput() {
        return this.calledOnNullInput;
    }

    public String getLanguage() {
        return this.language;
    }

    public DataType getReturnType() {
        return this.returnType;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof FunctionMetadata) {
            FunctionMetadata that = (FunctionMetadata)other;
            return this.keyspace.getName().equals(that.keyspace.getName()) && this.fullName.equals(that.fullName) && this.arguments.equals(that.arguments) && this.body.equals(that.body) && this.calledOnNullInput == that.calledOnNullInput && this.language.equals(that.language) && this.returnType.equals(that.returnType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyspace.getName(), this.fullName, this.arguments, this.body, this.calledOnNullInput, this.language, this.returnType});
    }
}

