/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CassandraTypeParser;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.IndexMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleJSONParser;
import com.datastax.driver.core.VersionNumber;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetadata {
    private static final Logger logger = LoggerFactory.getLogger(TableMetadata.class);
    private static final String CF_ID_V2 = "cf_id";
    private static final String CF_ID_V3 = "id";
    private static final String KEY_VALIDATOR = "key_validator";
    private static final String COMPARATOR = "comparator";
    private static final String VALIDATOR = "default_validator";
    private static final String KEY_ALIASES = "key_aliases";
    private static final String COLUMN_ALIASES = "column_aliases";
    private static final String VALUE_ALIAS = "value_alias";
    private static final String DEFAULT_KEY_ALIAS = "key";
    private static final String DEFAULT_COLUMN_ALIAS = "column";
    private static final String DEFAULT_VALUE_ALIAS = "value";
    private static final String FLAGS = "flags";
    private static final String DENSE = "dense";
    private static final String SUPER = "super";
    private static final String COMPOUND = "compound";
    private static final String EMPTY_TYPE = "org.apache.cassandra.db.marshal.EmptyType";
    private static final Comparator<ColumnMetadata> columnMetadataComparator = new Comparator<ColumnMetadata>(){

        @Override
        public int compare(ColumnMetadata c1, ColumnMetadata c2) {
            return c1.getName().compareTo(c2.getName());
        }
    };
    private final KeyspaceMetadata keyspace;
    private final String name;
    private final UUID id;
    private final List<ColumnMetadata> partitionKey;
    private final List<ColumnMetadata> clusteringColumns;
    private final Map<String, ColumnMetadata> columns;
    private final Map<String, IndexMetadata> indexes;
    private final Options options;
    private final List<Order> clusteringOrder;
    private final VersionNumber cassandraVersion;

    private TableMetadata(KeyspaceMetadata keyspace, String name, UUID id, List<ColumnMetadata> partitionKey, List<ColumnMetadata> clusteringColumns, Map<String, ColumnMetadata> columns, Map<String, IndexMetadata> indexes, Options options, List<Order> clusteringOrder, VersionNumber cassandraVersion) {
        this.keyspace = keyspace;
        this.name = name;
        this.id = id;
        this.partitionKey = partitionKey;
        this.clusteringColumns = clusteringColumns;
        this.columns = columns;
        this.indexes = indexes;
        this.options = options;
        this.clusteringOrder = clusteringOrder;
        this.cassandraVersion = cassandraVersion;
    }

    static TableMetadata build(KeyspaceMetadata ksm, Row row, Map<String, ColumnMetadata.Raw> rawCols, List<Row> indexRows, String nameColumn, VersionNumber cassandraVersion, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        int clusteringSize;
        boolean isCompact;
        boolean isDense;
        String name = row.getString(nameColumn);
        UUID id = null;
        if (cassandraVersion.getMajor() == 2 && cassandraVersion.getMinor() >= 1) {
            id = row.getUUID(CF_ID_V2);
        } else if (cassandraVersion.getMajor() > 2) {
            id = row.getUUID(CF_ID_V3);
        }
        CassandraTypeParser.ParseResult comparator = null;
        CassandraTypeParser.ParseResult keyValidator = null;
        List<String> columnAliases = null;
        if (cassandraVersion.getMajor() <= 2) {
            comparator = CassandraTypeParser.parseWithComposite(row.getString(COMPARATOR), protocolVersion, codecRegistry);
            keyValidator = CassandraTypeParser.parseWithComposite(row.getString(KEY_VALIDATOR), protocolVersion, codecRegistry);
            columnAliases = cassandraVersion.getMajor() >= 2 || row.getString(COLUMN_ALIASES) == null ? Collections.emptyList() : SimpleJSONParser.parseStringList(row.getString(COLUMN_ALIASES));
        }
        int partitionKeySize = TableMetadata.findPartitionKeySize(rawCols.values(), keyValidator);
        if (cassandraVersion.getMajor() > 2) {
            boolean isStaticCompact;
            Set<String> flags = row.getSet(FLAGS, String.class);
            isDense = flags.contains(DENSE);
            boolean isSuper = flags.contains(SUPER);
            boolean isCompound = flags.contains(COMPOUND);
            isCompact = isSuper || isDense || !isCompound;
            boolean bl = isStaticCompact = !isSuper && !isDense && !isCompound;
            if (isStaticCompact) {
                rawCols = TableMetadata.pruneStaticCompactTableColumns(rawCols);
            }
            if (isDense) {
                rawCols = TableMetadata.pruneDenseTableColumnsV3(rawCols);
            }
            clusteringSize = TableMetadata.findClusteringSize(comparator, rawCols.values(), columnAliases, cassandraVersion);
        } else {
            assert (comparator != null);
            clusteringSize = TableMetadata.findClusteringSize(comparator, rawCols.values(), columnAliases, cassandraVersion);
            boolean bl = isDense = clusteringSize != comparator.types.size() - 1;
            if (isDense) {
                rawCols = TableMetadata.pruneDenseTableColumnsV2(rawCols);
            }
            isCompact = isDense || !comparator.isComposite;
        }
        List<ColumnMetadata> partitionKey = TableMetadata.nullInitializedList(partitionKeySize);
        List<ColumnMetadata> clusteringColumns = TableMetadata.nullInitializedList(clusteringSize);
        List<Order> clusteringOrder = TableMetadata.nullInitializedList(clusteringSize);
        LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
        LinkedHashMap<String, IndexMetadata> indexes = new LinkedHashMap<String, IndexMetadata>();
        Options options = null;
        try {
            options = new Options(row, isCompact, cassandraVersion);
        }
        catch (RuntimeException e) {
            logger.error(String.format("Error parsing schema options for table %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getTable(\"%s\").getOptions() will return null", ksm.getName(), name, ksm.getName(), name), (Throwable)e);
        }
        TableMetadata tm = new TableMetadata(ksm, name, id, partitionKey, clusteringColumns, columns, indexes, options, clusteringOrder, cassandraVersion);
        TreeSet<ColumnMetadata> otherColumns = new TreeSet<ColumnMetadata>(columnMetadataComparator);
        if (cassandraVersion.getMajor() < 2) {
            int i;
            assert (comparator != null);
            assert (keyValidator != null);
            assert (columnAliases != null);
            List keyAliases = row.getString(KEY_ALIASES) == null ? Collections.emptyList() : SimpleJSONParser.parseStringList(row.getString(KEY_ALIASES));
            for (i = 0; i < partitionKey.size(); ++i) {
                String string = keyAliases.size() > i ? (String)keyAliases.get(i) : (i == 0 ? DEFAULT_KEY_ALIAS : DEFAULT_KEY_ALIAS + (i + 1));
                partitionKey.set(i, ColumnMetadata.forAlias(tm, string, keyValidator.types.get(i)));
            }
            for (i = 0; i < clusteringSize; ++i) {
                String string = columnAliases.size() > i ? columnAliases.get(i) : DEFAULT_COLUMN_ALIAS + (i + 1);
                clusteringColumns.set(i, ColumnMetadata.forAlias(tm, string, comparator.types.get(i)));
                clusteringOrder.set(i, comparator.reversed.get(i) != false ? Order.DESC : Order.ASC);
            }
            if (isDense) {
                String alias2;
                String string = alias2 = row.isNull(VALUE_ALIAS) ? DEFAULT_VALUE_ALIAS : row.getString(VALUE_ALIAS);
                if (!alias2.isEmpty()) {
                    DataType dataType = CassandraTypeParser.parseOne(row.getString(VALIDATOR), protocolVersion, codecRegistry);
                    otherColumns.add(ColumnMetadata.forAlias(tm, alias2, dataType));
                }
            }
        }
        LinkedHashMap<ColumnMetadata, Set<IndexMetadata>> indexedColumns = new LinkedHashMap<ColumnMetadata, Set<IndexMetadata>>();
        for (ColumnMetadata.Raw raw : rawCols.values()) {
            IndexMetadata index;
            ColumnMetadata col = ColumnMetadata.fromRaw(tm, raw);
            switch (raw.kind) {
                case PARTITION_KEY: {
                    partitionKey.set(raw.componentIndex, col);
                    break;
                }
                case CLUSTERING_COLUMN: {
                    clusteringColumns.set(raw.componentIndex, col);
                    clusteringOrder.set(raw.componentIndex, raw.isReversed ? Order.DESC : Order.ASC);
                    break;
                }
                default: {
                    otherColumns.add(col);
                }
            }
            if ((index = IndexMetadata.fromLegacy(col, raw)) == null) continue;
            indexes.put(index.getName(), index);
            TableMetadata.addIndexToColumn(index, col, indexedColumns);
        }
        for (ColumnMetadata columnMetadata : partitionKey) {
            columns.put(columnMetadata.getName(), columnMetadata);
        }
        for (ColumnMetadata columnMetadata : clusteringColumns) {
            columns.put(columnMetadata.getName(), columnMetadata);
        }
        for (ColumnMetadata columnMetadata : otherColumns) {
            columns.put(columnMetadata.getName(), columnMetadata);
        }
        if (indexRows != null) {
            for (Row row2 : indexRows) {
                IndexMetadata index = IndexMetadata.fromRow(tm, row2);
                indexes.put(index.getName(), index);
                for (ColumnMetadata column : index.getColumns()) {
                    TableMetadata.addIndexToColumn(index, column, indexedColumns);
                }
            }
        }
        for (Map.Entry entry : indexedColumns.entrySet()) {
            ColumnMetadata column = (ColumnMetadata)entry.getKey();
            for (IndexMetadata index : (Set)entry.getValue()) {
                column.indexes.put(index.getName(), index);
            }
        }
        return tm;
    }

    private static void addIndexToColumn(IndexMetadata index, ColumnMetadata column, Map<ColumnMetadata, Set<IndexMetadata>> indexedColumns) {
        Set<IndexMetadata> indexes = indexedColumns.get(column);
        if (indexes == null) {
            indexes = new LinkedHashSet<IndexMetadata>();
            indexedColumns.put(column, indexes);
        }
        indexes.add(index);
    }

    private static Map<String, ColumnMetadata.Raw> pruneStaticCompactTableColumns(Map<String, ColumnMetadata.Raw> rawCols) {
        Collection<ColumnMetadata.Raw> cols = rawCols.values();
        Iterator<ColumnMetadata.Raw> it = cols.iterator();
        while (it.hasNext()) {
            ColumnMetadata.Raw col = it.next();
            if (col.kind == ColumnMetadata.Raw.Kind.CLUSTERING_COLUMN) {
                it.remove();
                continue;
            }
            if (col.kind == ColumnMetadata.Raw.Kind.REGULAR) {
                it.remove();
                continue;
            }
            if (col.kind != ColumnMetadata.Raw.Kind.STATIC) continue;
            col.kind = ColumnMetadata.Raw.Kind.REGULAR;
        }
        return rawCols;
    }

    private static Map<String, ColumnMetadata.Raw> pruneDenseTableColumnsV3(Map<String, ColumnMetadata.Raw> rawCols) {
        Collection<ColumnMetadata.Raw> cols = rawCols.values();
        Iterator<ColumnMetadata.Raw> it = cols.iterator();
        while (it.hasNext()) {
            ColumnMetadata.Raw col = it.next();
            if (col.kind != ColumnMetadata.Raw.Kind.REGULAR || !(col.dataType instanceof DataType.CustomType) || !EMPTY_TYPE.equals(((DataType.CustomType)col.dataType).getCustomTypeClassName())) continue;
            it.remove();
        }
        return rawCols;
    }

    private static Map<String, ColumnMetadata.Raw> pruneDenseTableColumnsV2(Map<String, ColumnMetadata.Raw> rawCols) {
        Collection<ColumnMetadata.Raw> cols = rawCols.values();
        Iterator<ColumnMetadata.Raw> it = cols.iterator();
        while (it.hasNext()) {
            ColumnMetadata.Raw col = it.next();
            if (col.kind != ColumnMetadata.Raw.Kind.COMPACT_VALUE || !col.name.isEmpty()) continue;
            it.remove();
        }
        return rawCols;
    }

    private static int findPartitionKeySize(Collection<ColumnMetadata.Raw> cols, CassandraTypeParser.ParseResult keyValidator) {
        if (keyValidator != null) {
            return keyValidator.types.size();
        }
        int maxId = -1;
        for (ColumnMetadata.Raw col : cols) {
            if (col.kind != ColumnMetadata.Raw.Kind.PARTITION_KEY) continue;
            maxId = Math.max(maxId, col.componentIndex);
        }
        return maxId + 1;
    }

    private static int findClusteringSize(CassandraTypeParser.ParseResult comparator, Collection<ColumnMetadata.Raw> cols, List<String> columnAliases, VersionNumber cassandraVersion) {
        if (cassandraVersion.getMajor() >= 2) {
            int maxId = -1;
            for (ColumnMetadata.Raw col : cols) {
                if (col.kind != ColumnMetadata.Raw.Kind.CLUSTERING_COLUMN) continue;
                maxId = Math.max(maxId, col.componentIndex);
            }
            return maxId + 1;
        }
        int size = comparator.types.size();
        if (comparator.isComposite) {
            return !comparator.collections.isEmpty() || columnAliases.size() == size - 1 && comparator.types.get(size - 1).equals(DataType.text()) ? size - 1 : size;
        }
        return !columnAliases.isEmpty() || cols.isEmpty() ? size : 0;
    }

    private static <T> List<T> nullInitializedList(int size) {
        ArrayList<Object> l = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            l.add(null);
        }
        return l;
    }

    public String getName() {
        return this.name;
    }

    public UUID getId() {
        return this.id;
    }

    public KeyspaceMetadata getKeyspace() {
        return this.keyspace;
    }

    public ColumnMetadata getColumn(String name) {
        return this.columns.get(Metadata.handleId(name));
    }

    public List<ColumnMetadata> getColumns() {
        return new ArrayList<ColumnMetadata>(this.columns.values());
    }

    public List<ColumnMetadata> getPrimaryKey() {
        ArrayList<ColumnMetadata> pk = new ArrayList<ColumnMetadata>(this.partitionKey.size() + this.clusteringColumns.size());
        pk.addAll(this.partitionKey);
        pk.addAll(this.clusteringColumns);
        return pk;
    }

    public List<ColumnMetadata> getPartitionKey() {
        return Collections.unmodifiableList(this.partitionKey);
    }

    public List<ColumnMetadata> getClusteringColumns() {
        return Collections.unmodifiableList(this.clusteringColumns);
    }

    public IndexMetadata getIndex(String name) {
        return this.indexes.get(Metadata.handleId(name));
    }

    public List<IndexMetadata> getIndexes() {
        return new ArrayList<IndexMetadata>(this.indexes.values());
    }

    public List<Order> getClusteringOrder() {
        return this.clusteringOrder;
    }

    public Options getOptions() {
        return this.options;
    }

    void add(ColumnMetadata column) {
        this.columns.put(column.getName(), column);
    }

    public String exportAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.asCQLQuery(true));
        for (IndexMetadata index : this.indexes.values()) {
            sb.append('\n').append(index.asCQLQuery());
        }
        return sb.toString();
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    private String asCQLQuery(boolean formatted) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(Metadata.escapeId(this.keyspace.getName())).append('.').append(Metadata.escapeId(this.name)).append(" (");
        TableMetadata.newLine(sb, formatted);
        for (ColumnMetadata columnMetadata : this.columns.values()) {
            TableMetadata.newLine(sb.append(TableMetadata.spaces(4, formatted)).append(columnMetadata).append(','), formatted);
        }
        sb.append(TableMetadata.spaces(4, formatted)).append("PRIMARY KEY (");
        if (this.partitionKey.size() == 1) {
            sb.append(this.partitionKey.get(0).getName());
        } else {
            sb.append('(');
            boolean first = true;
            for (ColumnMetadata cm : this.partitionKey) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(Metadata.escapeId(cm.getName()));
            }
            sb.append(')');
        }
        for (ColumnMetadata columnMetadata : this.clusteringColumns) {
            sb.append(", ").append(Metadata.escapeId(columnMetadata.getName()));
        }
        sb.append(')');
        TableMetadata.newLine(sb, formatted);
        sb.append(") WITH ");
        if (this.options.isCompactStorage) {
            this.and(sb.append("COMPACT STORAGE"), formatted);
        }
        if (!Iterables.all(this.clusteringOrder, Order.isAscending)) {
            this.and(this.appendClusteringOrder(sb), formatted);
        }
        sb.append("read_repair_chance = ").append(this.options.readRepair);
        this.and(sb, formatted).append("dclocal_read_repair_chance = ").append(this.options.localReadRepair);
        if (this.cassandraVersion.getMajor() < 2 || this.cassandraVersion.getMajor() == 2 && this.cassandraVersion.getMinor() == 0) {
            this.and(sb, formatted).append("replicate_on_write = ").append(this.options.replicateOnWrite);
        }
        this.and(sb, formatted).append("gc_grace_seconds = ").append(this.options.gcGrace);
        this.and(sb, formatted).append("bloom_filter_fp_chance = ").append(this.options.bfFpChance);
        if (this.cassandraVersion.getMajor() < 2 || this.cassandraVersion.getMajor() == 2 && this.cassandraVersion.getMinor() < 1) {
            this.and(sb, formatted).append("caching = '").append((String)this.options.caching.get("keys")).append('\'');
        } else {
            this.and(sb, formatted).append("caching = ").append(TableMetadata.formatOptionMap(this.options.caching));
        }
        if (this.options.comment != null) {
            this.and(sb, formatted).append("comment = '").append(this.options.comment.replace("'", "''")).append('\'');
        }
        this.and(sb, formatted).append("compaction = ").append(TableMetadata.formatOptionMap(this.options.compaction));
        this.and(sb, formatted).append("compression = ").append(TableMetadata.formatOptionMap(this.options.compression));
        if (this.cassandraVersion.getMajor() >= 2) {
            this.and(sb, formatted).append("default_time_to_live = ").append(this.options.defaultTTL);
            this.and(sb, formatted).append("speculative_retry = '").append(this.options.speculativeRetry).append('\'');
            if (this.options.indexInterval != null) {
                this.and(sb, formatted).append("index_interval = ").append(this.options.indexInterval);
            }
        }
        if (this.cassandraVersion.getMajor() > 2 || this.cassandraVersion.getMajor() == 2 && this.cassandraVersion.getMinor() >= 1) {
            this.and(sb, formatted).append("min_index_interval = ").append(this.options.minIndexInterval);
            this.and(sb, formatted).append("max_index_interval = ").append(this.options.maxIndexInterval);
        }
        sb.append(';');
        return sb.toString();
    }

    public String toString() {
        return this.asCQLQuery();
    }

    private StringBuilder appendClusteringOrder(StringBuilder sb) {
        sb.append("CLUSTERING ORDER BY (");
        for (int i = 0; i < this.clusteringColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.clusteringColumns.get(i).getName()).append(' ').append((Object)this.clusteringOrder.get(i));
        }
        return sb.append(')');
    }

    private static String formatOptionMap(Map<String, String> m) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append('\'').append(entry.getKey()).append('\'');
            sb.append(" : ");
            try {
                sb.append(Integer.parseInt(entry.getValue()));
            }
            catch (NumberFormatException e) {
                sb.append('\'').append(entry.getValue()).append('\'');
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    private StringBuilder and(StringBuilder sb, boolean formatted) {
        return TableMetadata.newLine(sb, formatted).append(TableMetadata.spaces(2, formatted)).append(" AND ");
    }

    static String spaces(int n, boolean formatted) {
        if (!formatted) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    static StringBuilder newLine(StringBuilder sb, boolean formatted) {
        if (formatted) {
            sb.append('\n');
        }
        return sb;
    }

    static StringBuilder spaceOrNewLine(StringBuilder sb, boolean formatted) {
        sb.append(formatted ? (char)'\n' : ' ');
        return sb;
    }

    public static class Options {
        private static final String COMMENT = "comment";
        private static final String READ_REPAIR = "read_repair_chance";
        private static final String DCLOCAL_READ_REPAIR = "dclocal_read_repair_chance";
        private static final String LOCAL_READ_REPAIR = "local_read_repair_chance";
        private static final String REPLICATE_ON_WRITE = "replicate_on_write";
        private static final String GC_GRACE = "gc_grace_seconds";
        private static final String BF_FP_CHANCE = "bloom_filter_fp_chance";
        private static final String CACHING = "caching";
        private static final String COMPACTION = "compaction";
        private static final String COMPACTION_CLASS = "compaction_strategy_class";
        private static final String COMPACTION_OPTIONS = "compaction_strategy_options";
        private static final String POPULATE_CACHE_ON_FLUSH = "populate_io_cache_on_flush";
        private static final String COMPRESSION = "compression";
        private static final String COMPRESSION_PARAMS = "compression_parameters";
        private static final String MEMTABLE_FLUSH_PERIOD_MS = "memtable_flush_period_in_ms";
        private static final String DEFAULT_TTL = "default_time_to_live";
        private static final String SPECULATIVE_RETRY = "speculative_retry";
        private static final String INDEX_INTERVAL = "index_interval";
        private static final String MIN_INDEX_INTERVAL = "min_index_interval";
        private static final String MAX_INDEX_INTERVAL = "max_index_interval";
        private static final boolean DEFAULT_REPLICATE_ON_WRITE = true;
        private static final double DEFAULT_BF_FP_CHANCE = 0.01;
        private static final boolean DEFAULT_POPULATE_CACHE_ON_FLUSH = false;
        private static final int DEFAULT_MEMTABLE_FLUSH_PERIOD = 0;
        private static final int DEFAULT_DEFAULT_TTL = 0;
        private static final String DEFAULT_SPECULATIVE_RETRY = "NONE";
        private static final int DEFAULT_INDEX_INTERVAL = 128;
        private static final int DEFAULT_MIN_INDEX_INTERVAL = 128;
        private static final int DEFAULT_MAX_INDEX_INTERVAL = 2048;
        private final boolean isCompactStorage;
        private final String comment;
        private final double readRepair;
        private final double localReadRepair;
        private final boolean replicateOnWrite;
        private final int gcGrace;
        private final double bfFpChance;
        private final Map<String, String> caching;
        private final boolean populateCacheOnFlush;
        private final int memtableFlushPeriodMs;
        private final int defaultTTL;
        private final String speculativeRetry;
        private final Integer indexInterval;
        private final Integer minIndexInterval;
        private final Integer maxIndexInterval;
        private final Map<String, String> compaction;
        private final Map<String, String> compression;

        Options(Row row, boolean isCompactStorage, VersionNumber version) {
            boolean is120 = version.getMajor() < 2;
            boolean is200 = version.getMajor() == 2 && version.getMinor() == 0;
            boolean is210 = version.getMajor() == 2 && version.getMinor() >= 1;
            boolean is300OrHigher = version.getMajor() > 2;
            boolean is210OrHigher = is210 || is300OrHigher;
            this.isCompactStorage = isCompactStorage;
            this.comment = Options.isNullOrAbsent(row, COMMENT) ? "" : row.getString(COMMENT);
            this.readRepair = row.getDouble(READ_REPAIR);
            this.localReadRepair = is300OrHigher ? row.getDouble(DCLOCAL_READ_REPAIR) : row.getDouble(LOCAL_READ_REPAIR);
            this.replicateOnWrite = is210OrHigher || Options.isNullOrAbsent(row, REPLICATE_ON_WRITE) ? true : row.getBool(REPLICATE_ON_WRITE);
            this.gcGrace = row.getInt(GC_GRACE);
            this.bfFpChance = Options.isNullOrAbsent(row, BF_FP_CHANCE) ? 0.01 : row.getDouble(BF_FP_CHANCE);
            this.populateCacheOnFlush = Options.isNullOrAbsent(row, POPULATE_CACHE_ON_FLUSH) ? false : row.getBool(POPULATE_CACHE_ON_FLUSH);
            this.memtableFlushPeriodMs = is120 || Options.isNullOrAbsent(row, MEMTABLE_FLUSH_PERIOD_MS) ? 0 : row.getInt(MEMTABLE_FLUSH_PERIOD_MS);
            this.defaultTTL = is120 || Options.isNullOrAbsent(row, DEFAULT_TTL) ? 0 : row.getInt(DEFAULT_TTL);
            String string = this.speculativeRetry = is120 || Options.isNullOrAbsent(row, SPECULATIVE_RETRY) ? DEFAULT_SPECULATIVE_RETRY : row.getString(SPECULATIVE_RETRY);
            this.indexInterval = is200 ? Integer.valueOf(Options.isNullOrAbsent(row, INDEX_INTERVAL) ? 128 : row.getInt(INDEX_INTERVAL)) : null;
            if (is210OrHigher) {
                this.minIndexInterval = Options.isNullOrAbsent(row, MIN_INDEX_INTERVAL) ? 128 : row.getInt(MIN_INDEX_INTERVAL);
                this.maxIndexInterval = Options.isNullOrAbsent(row, MAX_INDEX_INTERVAL) ? 2048 : row.getInt(MAX_INDEX_INTERVAL);
            } else {
                this.minIndexInterval = null;
                this.maxIndexInterval = null;
            }
            this.caching = is300OrHigher ? ImmutableMap.copyOf(row.getMap(CACHING, String.class, String.class)) : (is210 ? ImmutableMap.copyOf(SimpleJSONParser.parseStringMap(row.getString(CACHING))) : ImmutableMap.of((Object)"keys", (Object)row.getString(CACHING)));
            this.compaction = is300OrHigher ? ImmutableMap.copyOf(row.getMap(COMPACTION, String.class, String.class)) : ImmutableMap.builder().put((Object)"class", (Object)row.getString(COMPACTION_CLASS)).putAll(SimpleJSONParser.parseStringMap(row.getString(COMPACTION_OPTIONS))).build();
            this.compression = is300OrHigher ? ImmutableMap.copyOf(row.getMap(COMPRESSION, String.class, String.class)) : ImmutableMap.copyOf(SimpleJSONParser.parseStringMap(row.getString(COMPRESSION_PARAMS)));
        }

        private static boolean isNullOrAbsent(Row row, String name) {
            return row.getColumnDefinitions().getIndexOf(name) < 0 || row.isNull(name);
        }

        public boolean isCompactStorage() {
            return this.isCompactStorage;
        }

        public String getComment() {
            return this.comment;
        }

        public double getReadRepairChance() {
            return this.readRepair;
        }

        public double getLocalReadRepairChance() {
            return this.localReadRepair;
        }

        public boolean getReplicateOnWrite() {
            return this.replicateOnWrite;
        }

        public int getGcGraceInSeconds() {
            return this.gcGrace;
        }

        public double getBloomFilterFalsePositiveChance() {
            return this.bfFpChance;
        }

        public Map<String, String> getCaching() {
            return this.caching;
        }

        public boolean getPopulateIOCacheOnFlush() {
            return this.populateCacheOnFlush;
        }

        public int getMemtableFlushPeriodInMs() {
            return this.memtableFlushPeriodMs;
        }

        public int getDefaultTimeToLive() {
            return this.defaultTTL;
        }

        public String getSpeculativeRetry() {
            return this.speculativeRetry;
        }

        public Integer getIndexInterval() {
            return this.indexInterval;
        }

        public Integer getMinIndexInterval() {
            return this.minIndexInterval;
        }

        public Integer getMaxIndexInterval() {
            return this.maxIndexInterval;
        }

        public Map<String, String> getCompaction() {
            return this.compaction;
        }

        public Map<String, String> getCompression() {
            return this.compression;
        }
    }

    public static enum Order {
        ASC,
        DESC;

        static final Predicate<Order> isAscending;

        static {
            isAscending = new Predicate<Order>(){

                public boolean apply(Order o) {
                    return o == ASC;
                }
            };
        }
    }
}

