/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleJSONParser;
import com.datastax.driver.core.TableMetadata;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexMetadata {
    public static final Function<IndexMetadata, String> INDEX_NAME = new Function<IndexMetadata, String>(){

        public String apply(IndexMetadata input) {
            return input.getName();
        }
    };
    public static final String CUSTOM_INDEX_OPTION_NAME = "class_name";
    public static final String INDEX_KEYS_OPTION_NAME = "index_keys";
    public static final String INDEX_VALUES_OPTION_NAME = "index_values";
    public static final String INDEX_ENTRIES_OPTION_NAME = "index_keys_and_values";
    private final TableMetadata table;
    private final String name;
    private final Map<String, ColumnMetadata> columns;
    private final IndexType indexType;
    private final TargetType targetType;
    private final Map<String, String> options;

    private IndexMetadata(TableMetadata table, String name, Map<String, ColumnMetadata> columns, IndexType indexType, TargetType targetType, Map<String, String> options) {
        this.table = table;
        this.name = name;
        this.columns = columns;
        this.indexType = indexType;
        this.targetType = targetType;
        this.options = options;
    }

    static IndexMetadata fromRow(TableMetadata table, Row indexRow) {
        String name = indexRow.getString("index_name");
        Set<String> targetColumnNames = indexRow.getSet("target_columns", String.class);
        LinkedHashMap<String, ColumnMetadata> targetColumns = new LinkedHashMap<String, ColumnMetadata>(targetColumnNames.size());
        for (String targetColumnName : targetColumnNames) {
            targetColumns.put(targetColumnName, table.getColumn(targetColumnName));
        }
        IndexType indexType = IndexType.valueOf(indexRow.getString("index_type"));
        TargetType targetType = TargetType.valueOf(indexRow.getString("target_type"));
        Map<String, String> options = indexRow.getMap("options", String.class, String.class);
        return new IndexMetadata(table, name, targetColumns, indexType, targetType, options);
    }

    static IndexMetadata fromLegacy(ColumnMetadata column, ColumnMetadata.Raw raw) {
        if (raw.indexColumns.isEmpty()) {
            return null;
        }
        String type = raw.indexColumns.get("index_type");
        if (type == null) {
            return null;
        }
        String indexName = raw.indexColumns.get("index_name");
        String indexTypeStr = raw.indexColumns.get("index_type");
        IndexType indexType = indexTypeStr == null ? null : IndexType.valueOf(indexTypeStr);
        String indexOptionsCol = raw.indexColumns.get("index_options");
        ImmutableMap columns = ImmutableMap.of((Object)column.getName(), (Object)column);
        Object options = indexOptionsCol == null || indexOptionsCol.isEmpty() || indexOptionsCol.equals("null") ? ImmutableMap.of() : SimpleJSONParser.parseStringMap(indexOptionsCol);
        return new IndexMetadata(column.getTable(), indexName, (Map<String, ColumnMetadata>)columns, indexType, TargetType.COLUMN, (Map<String, String>)options);
    }

    public TableMetadata getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public ColumnMetadata getColumn(String name) {
        return this.columns.get(Metadata.handleId(name));
    }

    public List<ColumnMetadata> getColumns() {
        return new ArrayList<ColumnMetadata>(this.columns.values());
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public boolean isCustomIndex() {
        return this.getIndexClassName() != null;
    }

    public String getIndexClassName() {
        return this.getOption(CUSTOM_INDEX_OPTION_NAME);
    }

    public boolean isKeys() {
        return this.getOption(INDEX_KEYS_OPTION_NAME) != null;
    }

    public boolean isValues() {
        return this.getOption(INDEX_VALUES_OPTION_NAME) != null;
    }

    public boolean isEntries() {
        return this.getOption(INDEX_ENTRIES_OPTION_NAME) != null;
    }

    public boolean isFull() {
        ColumnMetadata column = this.columns.values().iterator().next();
        return !this.isKeys() && !this.isValues() && !this.isEntries() && column.getType() instanceof DataType.CollectionType && column.getType().isFrozen();
    }

    public String getOption(String name) {
        return this.options != null ? this.options.get(name) : null;
    }

    public String asCQLQuery() {
        TableMetadata table = this.getTable();
        String ksName = Metadata.escapeId(table.getKeyspace().getName());
        String cfName = Metadata.escapeId(table.getName());
        String colName = Metadata.escapeId(this.columns.keySet().iterator().next());
        return this.isCustomIndex() ? String.format("CREATE CUSTOM INDEX %s ON %s.%s (%s) USING '%s' WITH OPTIONS = %s;", this.name, ksName, cfName, colName, this.getIndexClassName(), this.getOptionsAsCql()) : String.format("CREATE INDEX %s ON %s.%s (%s);", this.name, ksName, cfName, this.getIndexFunction(colName));
    }

    private String getOptionsAsCql() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        Iterator<Map.Entry<String, String>> it = this.options.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> option = it.next();
            builder.append(String.format("'%s' : '%s'", option.getKey(), option.getValue()));
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    private String getIndexFunction(String colName) {
        if (this.isKeys()) {
            return String.format("KEYS(%s)", colName);
        }
        if (this.isFull()) {
            return String.format("FULL(%s)", colName);
        }
        if (this.isEntries()) {
            return String.format("ENTRIES(%s)", colName);
        }
        return colName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.columns, this.indexType, this.targetType, this.options});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IndexMetadata)) {
            return false;
        }
        IndexMetadata other = (IndexMetadata)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.columns, other.columns) && Objects.equal((Object)((Object)this.indexType), (Object)((Object)other.indexType)) && Objects.equal((Object)((Object)this.targetType), (Object)((Object)other.targetType)) && Objects.equal(this.options, other.options);
    }

    public static enum TargetType {
        COLUMN,
        ROW;

    }

    public static enum IndexType {
        KEYS,
        CUSTOM,
        COMPOSITES;

    }
}

