/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CassandraTypeParser;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TypeCodec;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AggregateMetadata {
    private final KeyspaceMetadata keyspace;
    private final String fullName;
    private final String simpleName;
    private final List<DataType> argumentTypes;
    private final String finalFuncSimpleName;
    private final String finalFuncFullName;
    private final Object initCond;
    private final DataType returnType;
    private final String stateFuncSimpleName;
    private final String stateFuncFullName;
    private final DataType stateType;
    private final TypeCodec<Object> stateTypeCodec;

    private AggregateMetadata(KeyspaceMetadata keyspace, String fullName, String simpleName, List<DataType> argumentTypes, String finalFuncSimpleName, String finalFuncFullName, Object initCond, DataType returnType, String stateFuncSimpleName, String stateFuncFullName, DataType stateType, TypeCodec<Object> stateTypeCodec) {
        this.keyspace = keyspace;
        this.fullName = fullName;
        this.simpleName = simpleName;
        this.argumentTypes = argumentTypes;
        this.finalFuncSimpleName = finalFuncSimpleName;
        this.finalFuncFullName = finalFuncFullName;
        this.initCond = initCond;
        this.returnType = returnType;
        this.stateFuncSimpleName = stateFuncSimpleName;
        this.stateFuncFullName = stateFuncFullName;
        this.stateType = stateType;
        this.stateTypeCodec = stateTypeCodec;
    }

    static AggregateMetadata build(KeyspaceMetadata ksm, Row row, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        String simpleName = row.getString("aggregate_name");
        List<String> signature = row.getList("signature", String.class);
        String fullName = Metadata.fullFunctionName(simpleName, signature);
        List<DataType> argumentTypes = AggregateMetadata.parseTypes(row.getList("argument_types", String.class), protocolVersion, codecRegistry);
        String finalFuncSimpleName = row.getString("final_func");
        DataType returnType = CassandraTypeParser.parseOne(row.getString("return_type"), protocolVersion, codecRegistry);
        String stateFuncSimpleName = row.getString("state_func");
        String stateTypeName = row.getString("state_type");
        DataType stateType = CassandraTypeParser.parseOne(stateTypeName, protocolVersion, codecRegistry);
        ByteBuffer rawInitCond = row.getBytes("initcond");
        Object initCond = rawInitCond == null ? null : codecRegistry.codecFor(stateType).deserialize(rawInitCond, protocolVersion);
        String finalFuncFullName = finalFuncSimpleName == null ? null : String.format("%s(%s)", finalFuncSimpleName, stateType);
        String stateFuncFullName = AggregateMetadata.makeStateFuncFullName(stateFuncSimpleName, stateType.toString(), signature);
        AggregateMetadata aggregate = new AggregateMetadata(ksm, fullName, simpleName, argumentTypes, finalFuncSimpleName, finalFuncFullName, initCond, returnType, stateFuncSimpleName, stateFuncFullName, stateType, codecRegistry.codecFor(stateType));
        ksm.add(aggregate);
        return aggregate;
    }

    private static String makeStateFuncFullName(String stateFuncSimpleName, String stateTypeName, List<String> typeNames) {
        ArrayList args = Lists.newArrayList((Object[])new String[]{stateTypeName});
        args.addAll(typeNames);
        return Metadata.fullFunctionName(stateFuncSimpleName, args);
    }

    private static List<DataType> parseTypes(List<String> names, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        if (names.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String name : names) {
            DataType type = CassandraTypeParser.parseOne(name, protocolVersion, codecRegistry);
            builder.add((Object)type);
        }
        return builder.build();
    }

    public String exportAsString() {
        return this.asCQLQuery(true);
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    public String toString() {
        return this.asCQLQuery(false);
    }

    private String asCQLQuery(boolean formatted) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE AGGREGATE ").append(Metadata.escapeId(this.keyspace.getName())).append('.').append(Metadata.escapeId(this.simpleName)).append('(');
        boolean first = true;
        for (DataType type : this.argumentTypes) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(type);
        }
        sb.append(')');
        TableMetadata.spaceOrNewLine(sb, formatted).append("SFUNC ").append(this.stateFuncSimpleName).append(" STYPE ").append(this.stateType);
        if (this.finalFuncSimpleName != null) {
            TableMetadata.spaceOrNewLine(sb, formatted).append("FINALFUNC ").append(this.finalFuncSimpleName);
        }
        if (this.initCond != null) {
            TableMetadata.spaceOrNewLine(sb, formatted).append("INITCOND ").append(this.stateTypeCodec.format(this.initCond));
        }
        sb.append(';');
        return sb.toString();
    }

    public KeyspaceMetadata getKeyspace() {
        return this.keyspace;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public List<DataType> getArgumentTypes() {
        return this.argumentTypes;
    }

    public FunctionMetadata getFinalFunc() {
        return this.finalFuncFullName == null ? null : this.keyspace.functions.get(this.finalFuncFullName);
    }

    public Object getInitCond() {
        return this.initCond;
    }

    public DataType getReturnType() {
        return this.returnType;
    }

    public FunctionMetadata getStateFunc() {
        return this.keyspace.functions.get(this.stateFuncFullName);
    }

    public DataType getStateType() {
        return this.stateType;
    }
}

