/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Frame;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Message {
    protected static final Logger logger = LoggerFactory.getLogger(Message.class);
    private volatile int streamId;
    private volatile Map<String, ByteBuffer> customPayload;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    protected Message() {
    }

    public Message setStreamId(int streamId) {
        this.streamId = streamId;
        return this;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public Map<String, ByteBuffer> getCustomPayload() {
        return this.customPayload;
    }

    public Message setCustomPayload(Map<String, ByteBuffer> customPayload) {
        this.customPayload = customPayload;
        return this;
    }

    static String printPayload(Map<String, ByteBuffer> customPayload) {
        if (customPayload == null) {
            return "null";
        }
        if (customPayload.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<String, ByteBuffer>> iterator = customPayload.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ByteBuffer> entry = iterator.next();
            sb.append(entry.getKey());
            sb.append(":");
            if (entry.getValue() == null) {
                sb.append("null");
            } else {
                Message.bytesToHex(entry.getValue(), sb);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    static void bytesToHex(ByteBuffer bytes, StringBuilder sb) {
        int length = Math.min(bytes.remaining(), 50);
        char[] hexChars = new char[length * 2];
        sb.append("0x");
        for (int i = 0; i < length; ++i) {
            int v = bytes.get(i) & 0xFF;
            sb.append(hexArray[v >>> 4]);
            sb.append(hexArray[v & 0xF]);
        }
        if (bytes.remaining() > 50) {
            sb.append("... [TRUNCATED]");
        }
    }

    @ChannelHandler.Sharable
    public static class ProtocolEncoder
    extends MessageToMessageEncoder<Request> {
        private final ProtocolVersion protocolVersion;

        public ProtocolEncoder(ProtocolVersion version) {
            this.protocolVersion = version;
        }

        protected void encode(ChannelHandlerContext ctx, Request request, List<Object> out) throws Exception {
            Map customPayload;
            EnumSet<Frame.Header.Flag> flags = EnumSet.noneOf(Frame.Header.Flag.class);
            if (request.isTracingRequested()) {
                flags.add(Frame.Header.Flag.TRACING);
            }
            if ((customPayload = request.getCustomPayload()) != null) {
                if (this.protocolVersion.compareTo(ProtocolVersion.V4) < 0) {
                    throw new UnsupportedFeatureException(this.protocolVersion, "Custom payloads are only supported since native protocol V4");
                }
                flags.add(Frame.Header.Flag.CUSTOM_PAYLOAD);
            }
            Coder<?> coder = request.type.coder;
            int messageSize = coder.encodedSize(request, this.protocolVersion);
            int payloadLength = -1;
            if (customPayload != null) {
                payloadLength = CBUtil.sizeOfBytesMap(customPayload);
                messageSize += payloadLength;
            }
            ByteBuf body = ctx.alloc().buffer(messageSize);
            if (customPayload != null) {
                CBUtil.writeBytesMap(customPayload, body);
                if (logger.isTraceEnabled()) {
                    logger.trace("Sending payload: {} ({} bytes total)", (Object)Message.printPayload(customPayload), (Object)payloadLength);
                }
            }
            coder.encode(request, body, this.protocolVersion);
            out.add(Frame.create(this.protocolVersion, request.type.opcode, request.getStreamId(), flags, body));
        }
    }

    @ChannelHandler.Sharable
    public static class ProtocolDecoder
    extends MessageToMessageDecoder<Frame> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void decode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            boolean hasWarnings;
            Map<String, ByteBuffer> customPayload;
            boolean isTracing = frame.header.flags.contains((Object)Frame.Header.Flag.TRACING);
            boolean isCustomPayload = frame.header.flags.contains((Object)Frame.Header.Flag.CUSTOM_PAYLOAD);
            UUID tracingId = isTracing ? CBUtil.readUUID(frame.body) : null;
            Map<String, ByteBuffer> map = customPayload = isCustomPayload ? CBUtil.readBytesMap(frame.body) : null;
            if (customPayload != null && logger.isTraceEnabled()) {
                logger.trace("Received payload: {} ({} bytes total)", (Object)Message.printPayload(customPayload), (Object)CBUtil.sizeOfBytesMap(customPayload));
            }
            List<String> warnings = (hasWarnings = frame.header.flags.contains((Object)Frame.Header.Flag.WARNING)) ? CBUtil.readStringList(frame.body) : Collections.emptyList();
            try {
                Object response = Response.Type.fromOpcode((int)frame.header.opcode).decoder.decode(frame.body, frame.header.version);
                ((Response)response).setTracingId(tracingId).setWarnings(warnings).setCustomPayload((Map)customPayload).setStreamId(frame.header.streamId);
                out.add(response);
            }
            finally {
                frame.body.release();
            }
        }
    }

    public static abstract class Response
    extends Message {
        public final Type type;
        protected volatile UUID tracingId;
        protected volatile List<String> warnings;

        protected Response(Type type) {
            this.type = type;
        }

        public Response setTracingId(UUID tracingId) {
            this.tracingId = tracingId;
            return this;
        }

        public UUID getTracingId() {
            return this.tracingId;
        }

        public Response setWarnings(List<String> warnings) {
            this.warnings = warnings;
            return this;
        }

        public static enum Type {
            ERROR(0, Responses.Error.decoder),
            READY(2, Responses.Ready.decoder),
            AUTHENTICATE(3, Responses.Authenticate.decoder),
            SUPPORTED(6, Responses.Supported.decoder),
            RESULT(8, Responses.Result.decoder),
            EVENT(12, Responses.Event.decoder),
            AUTH_CHALLENGE(14, Responses.AuthChallenge.decoder),
            AUTH_SUCCESS(16, Responses.AuthSuccess.decoder);

            public final int opcode;
            public final Decoder<?> decoder;
            private static final Type[] opcodeIdx;

            private Type(int opcode, Decoder<?> decoder) {
                this.opcode = opcode;
                this.decoder = decoder;
            }

            public static Type fromOpcode(int opcode) {
                if (opcode < 0 || opcode >= opcodeIdx.length) {
                    throw new DriverInternalError(String.format("Unknown response opcode %d", opcode));
                }
                Type t = opcodeIdx[opcode];
                if (t == null) {
                    throw new DriverInternalError(String.format("Unknown response opcode %d", opcode));
                }
                return t;
            }

            static {
                int maxOpcode = -1;
                for (Type type : Type.values()) {
                    maxOpcode = Math.max(maxOpcode, type.opcode);
                }
                opcodeIdx = new Type[maxOpcode + 1];
                for (Type type : Type.values()) {
                    if (opcodeIdx[type.opcode] != null) {
                        throw new IllegalStateException("Duplicate opcode");
                    }
                    Type.opcodeIdx[type.opcode] = type;
                }
            }
        }
    }

    public static abstract class Request
    extends Message {
        public final Type type;
        protected boolean tracingRequested;

        protected Request(Type type) {
            this.type = type;
        }

        public void setTracingRequested() {
            this.tracingRequested = true;
        }

        public boolean isTracingRequested() {
            return this.tracingRequested;
        }

        ConsistencyLevel consistency() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.consistency;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.consistency;
                }
                case BATCH: {
                    return ((Requests.Batch)this).options.consistency;
                }
            }
            return null;
        }

        ConsistencyLevel serialConsistency() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.serialConsistency;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.serialConsistency;
                }
                case BATCH: {
                    return ((Requests.Batch)this).options.serialConsistency;
                }
            }
            return null;
        }

        long defaultTimestamp() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.defaultTimestamp;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.defaultTimestamp;
                }
                case BATCH: {
                    return ((Requests.Batch)this).options.defaultTimestamp;
                }
            }
            return 0L;
        }

        ByteBuffer pagingState() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.pagingState;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.pagingState;
                }
            }
            return null;
        }

        public static enum Type {
            STARTUP(1, Requests.Startup.coder),
            CREDENTIALS(4, Requests.Credentials.coder),
            OPTIONS(5, Requests.Options.coder),
            QUERY(7, Requests.Query.coder),
            PREPARE(9, Requests.Prepare.coder),
            EXECUTE(10, Requests.Execute.coder),
            REGISTER(11, Requests.Register.coder),
            BATCH(13, Requests.Batch.coder),
            AUTH_RESPONSE(15, Requests.AuthResponse.coder);

            public final int opcode;
            public final Coder<?> coder;

            private Type(int opcode, Coder<?> coder) {
                this.opcode = opcode;
                this.coder = coder;
            }
        }
    }

    public static interface Decoder<R extends Response> {
        public R decode(ByteBuf var1, ProtocolVersion var2);
    }

    public static interface Coder<R extends Request> {
        public void encode(R var1, ByteBuf var2, ProtocolVersion var3);

        public int encodedSize(R var1, ProtocolVersion var2);
    }
}

