/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DateWithoutTime;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

abstract class AbstractGettableByIndexData
implements GettableByIndexData {
    protected final ProtocolVersion protocolVersion;

    protected AbstractGettableByIndexData(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    protected abstract DataType getType(int var1);

    protected abstract String getName(int var1);

    protected abstract ByteBuffer getValue(int var1);

    protected void checkType(int i, DataType.Name name) {
        DataType defined = this.getType(i);
        if (name != defined.getName()) {
            throw new InvalidTypeException(String.format("Value %s is of type %s", this.getName(i), defined));
        }
    }

    protected DataType.Name checkType(int i, DataType.Name name1, DataType.Name name2) {
        DataType defined = this.getType(i);
        if (name1 != defined.getName() && name2 != defined.getName()) {
            throw new InvalidTypeException(String.format("Value %s is of type %s", this.getName(i), defined));
        }
        return defined.getName();
    }

    protected DataType.Name checkType(int i, DataType.Name name1, DataType.Name name2, DataType.Name name3) {
        DataType defined = this.getType(i);
        if (name1 != defined.getName() && name2 != defined.getName() && name3 != defined.getName()) {
            throw new InvalidTypeException(String.format("Value %s is of type %s", this.getName(i), defined));
        }
        return defined.getName();
    }

    @Override
    public boolean isNull(int i) {
        return this.getValue(i) == null;
    }

    @Override
    public boolean getBool(int i) {
        this.checkType(i, DataType.Name.BOOLEAN);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return false;
        }
        return TypeCodec.BooleanCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public byte getByte(int i) {
        this.checkType(i, DataType.Name.TINYINT);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return 0;
        }
        return TypeCodec.TinyIntCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public short getShort(int i) {
        this.checkType(i, DataType.Name.SMALLINT);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return 0;
        }
        return TypeCodec.SmallIntCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public int getInt(int i) {
        this.checkType(i, DataType.Name.INT);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return 0;
        }
        return TypeCodec.IntCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public long getLong(int i) {
        this.checkType(i, DataType.Name.BIGINT, DataType.Name.COUNTER);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return 0L;
        }
        return TypeCodec.LongCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public Date getTimestamp(int i) {
        this.checkType(i, DataType.Name.TIMESTAMP);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return TypeCodec.TimestampCodec.instance.deserialize(value);
    }

    @Override
    public DateWithoutTime getDate(int i) {
        this.checkType(i, DataType.Name.DATE);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return TypeCodec.DateCodec.instance.deserialize(value);
    }

    @Override
    public long getTime(int i) {
        this.checkType(i, DataType.Name.TIME);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return 0L;
        }
        return TypeCodec.TimeCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public float getFloat(int i) {
        this.checkType(i, DataType.Name.FLOAT);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return 0.0f;
        }
        return TypeCodec.FloatCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public double getDouble(int i) {
        this.checkType(i, DataType.Name.DOUBLE);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return 0.0;
        }
        return TypeCodec.DoubleCodec.instance.deserializeNoBoxing(value);
    }

    @Override
    public ByteBuffer getBytesUnsafe(int i) {
        ByteBuffer value = this.getValue(i);
        if (value == null) {
            return null;
        }
        return value.duplicate();
    }

    @Override
    public ByteBuffer getBytes(int i) {
        this.checkType(i, DataType.Name.BLOB);
        return this.getBytesUnsafe(i);
    }

    @Override
    public String getString(int i) {
        DataType.Name type = this.checkType(i, DataType.Name.VARCHAR, DataType.Name.TEXT, DataType.Name.ASCII);
        ByteBuffer value = this.getValue(i);
        if (value == null) {
            return null;
        }
        return type == DataType.Name.ASCII ? TypeCodec.StringCodec.asciiInstance.deserialize(value) : TypeCodec.StringCodec.utf8Instance.deserialize(value);
    }

    @Override
    public BigInteger getVarint(int i) {
        this.checkType(i, DataType.Name.VARINT);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return TypeCodec.BigIntegerCodec.instance.deserialize(value);
    }

    @Override
    public BigDecimal getDecimal(int i) {
        this.checkType(i, DataType.Name.DECIMAL);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return TypeCodec.DecimalCodec.instance.deserialize(value);
    }

    @Override
    public UUID getUUID(int i) {
        DataType.Name type = this.checkType(i, DataType.Name.UUID, DataType.Name.TIMEUUID);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return type == DataType.Name.UUID ? TypeCodec.UUIDCodec.instance.deserialize(value) : TypeCodec.TimeUUIDCodec.instance.deserialize(value);
    }

    @Override
    public InetAddress getInet(int i) {
        this.checkType(i, DataType.Name.INET);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return TypeCodec.InetCodec.instance.deserialize(value);
    }

    @Override
    public <T> List<T> getList(int i, Class<T> elementsClass) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.LIST) {
            throw new InvalidTypeException(String.format("Column %s is not of list type", this.getName(i)));
        }
        Class<?> expectedClass = type.getTypeArguments().get((int)0).getName().javaType;
        if (!elementsClass.isAssignableFrom(expectedClass)) {
            throw new InvalidTypeException(String.format("Column %s is a list of %s (CQL type %s), cannot be retrieved as a list of %s", this.getName(i), expectedClass, type, elementsClass));
        }
        ByteBuffer value = this.getValue(i);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList((List)type.codec(this.protocolVersion).deserialize(value));
    }

    @Override
    public <T> List<T> getList(int i, TypeToken<T> elementsType) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.LIST) {
            throw new InvalidTypeException(String.format("Column %s is not of list type", this.getName(i)));
        }
        DataType expectedType = type.getTypeArguments().get(0);
        if (!expectedType.canBeDeserializedAs(elementsType)) {
            throw new InvalidTypeException(String.format("Column %s has CQL type %s, cannot be retrieved as a list of %s", this.getName(i), type, elementsType));
        }
        ByteBuffer value = this.getValue(i);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList((List)type.codec(this.protocolVersion).deserialize(value));
    }

    @Override
    public <T> Set<T> getSet(int i, Class<T> elementsClass) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.SET) {
            throw new InvalidTypeException(String.format("Column %s is not of set type", this.getName(i)));
        }
        Class<?> expectedClass = type.getTypeArguments().get((int)0).getName().javaType;
        if (!elementsClass.isAssignableFrom(expectedClass)) {
            throw new InvalidTypeException(String.format("Column %s is a set of %s (CQL type %s), cannot be retrieved as a set of %s", this.getName(i), expectedClass, type, elementsClass));
        }
        ByteBuffer value = this.getValue(i);
        if (value == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)type.codec(this.protocolVersion).deserialize(value));
    }

    @Override
    public <T> Set<T> getSet(int i, TypeToken<T> elementsType) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.SET) {
            throw new InvalidTypeException(String.format("Column %s is not of set type", this.getName(i)));
        }
        DataType expectedType = type.getTypeArguments().get(0);
        if (!expectedType.canBeDeserializedAs(elementsType)) {
            throw new InvalidTypeException(String.format("Column %s has CQL type %s, cannot be retrieved as a set of %s", this.getName(i), type, elementsType));
        }
        ByteBuffer value = this.getValue(i);
        if (value == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)type.codec(this.protocolVersion).deserialize(value));
    }

    @Override
    public <K, V> Map<K, V> getMap(int i, Class<K> keysClass, Class<V> valuesClass) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.MAP) {
            throw new InvalidTypeException(String.format("Column %s is not of map type", this.getName(i)));
        }
        Class<?> expectedKeysClass = type.getTypeArguments().get((int)0).getName().javaType;
        Class<?> expectedValuesClass = type.getTypeArguments().get((int)1).getName().javaType;
        if (!keysClass.isAssignableFrom(expectedKeysClass) || !valuesClass.isAssignableFrom(expectedValuesClass)) {
            throw new InvalidTypeException(String.format("Column %s is a map of %s->%s (CQL type %s), cannot be retrieved as a map of %s->%s", this.getName(i), expectedKeysClass, expectedValuesClass, type, keysClass, valuesClass));
        }
        ByteBuffer value = this.getValue(i);
        if (value == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap((Map)type.codec(this.protocolVersion).deserialize(value));
    }

    @Override
    public <K, V> Map<K, V> getMap(int i, TypeToken<K> keysType, TypeToken<V> valuesType) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.MAP) {
            throw new InvalidTypeException(String.format("Column %s is not of map type", this.getName(i)));
        }
        DataType expectedKeysType = type.getTypeArguments().get(0);
        DataType expectedValuesType = type.getTypeArguments().get(1);
        if (!expectedKeysType.canBeDeserializedAs(keysType) || !expectedValuesType.canBeDeserializedAs(valuesType)) {
            throw new InvalidTypeException(String.format("Column %s has CQL type %s, cannot be retrieved as a map of %s->%s", this.getName(i), type, keysType, valuesType));
        }
        ByteBuffer value = this.getValue(i);
        if (value == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap((Map)type.codec(this.protocolVersion).deserialize(value));
    }

    @Override
    public UDTValue getUDTValue(int i) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.UDT) {
            throw new InvalidTypeException(String.format("Column %s is not a UDT", this.getName(i)));
        }
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return (UDTValue)type.codec(this.protocolVersion).deserialize(value);
    }

    @Override
    public TupleValue getTupleValue(int i) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.TUPLE) {
            throw new InvalidTypeException(String.format("Column %s is not a tuple", this.getName(i)));
        }
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return (TupleValue)type.codec(this.protocolVersion).deserialize(value);
    }

    @Override
    public Object getObject(int i) {
        ByteBuffer raw = this.getValue(i);
        DataType type = this.getType(i);
        if (raw == null) {
            switch (type.getName()) {
                case LIST: {
                    return Collections.emptyList();
                }
                case SET: {
                    return Collections.emptySet();
                }
                case MAP: {
                    return Collections.emptyMap();
                }
            }
            return null;
        }
        return type.deserialize(raw, this.protocolVersion);
    }
}

