/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractGettableData;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DateWithoutTime;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

abstract class AbstractData<T extends SettableData<T>>
extends AbstractGettableData
implements SettableData<T> {
    final T wrapped;
    final ByteBuffer[] values;

    protected AbstractData(ProtocolVersion protocolVersion, int size) {
        super(protocolVersion);
        this.wrapped = this;
        this.values = new ByteBuffer[size];
    }

    protected AbstractData(ProtocolVersion protocolVersion, T wrapped, int size) {
        this(protocolVersion, wrapped, new ByteBuffer[size]);
    }

    protected AbstractData(ProtocolVersion protocolVersion, T wrapped, ByteBuffer[] values) {
        super(protocolVersion);
        this.wrapped = wrapped;
        this.values = values;
    }

    protected abstract int[] getAllIndexesOf(String var1);

    private T setValue(int i, ByteBuffer value) {
        this.values[i] = value;
        return this.wrapped;
    }

    @Override
    protected ByteBuffer getValue(int i) {
        return this.values[i];
    }

    @Override
    protected int getIndexOf(String name) {
        return this.getAllIndexesOf(name)[0];
    }

    @Override
    public T setBool(int i, boolean v) {
        this.checkType(i, DataType.Name.BOOLEAN);
        return this.setValue(i, TypeCodec.BooleanCodec.instance.serializeNoBoxing(v));
    }

    @Override
    public T setBool(String name, boolean v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = TypeCodec.BooleanCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.BOOLEAN);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setByte(int i, byte v) {
        this.checkType(i, DataType.Name.TINYINT);
        return this.setValue(i, TypeCodec.TinyIntCodec.instance.serializeNoBoxing(v));
    }

    @Override
    public T setByte(String name, byte v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = TypeCodec.TinyIntCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.TINYINT);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setShort(int i, short v) {
        this.checkType(i, DataType.Name.SMALLINT);
        return this.setValue(i, TypeCodec.SmallIntCodec.instance.serializeNoBoxing(v));
    }

    @Override
    public T setShort(String name, short v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = TypeCodec.SmallIntCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.SMALLINT);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setInt(int i, int v) {
        this.checkType(i, DataType.Name.INT);
        return this.setValue(i, TypeCodec.IntCodec.instance.serializeNoBoxing(v));
    }

    @Override
    public T setInt(String name, int v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = TypeCodec.IntCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.INT);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setLong(int i, long v) {
        this.checkType(i, DataType.Name.BIGINT, DataType.Name.COUNTER);
        return this.setValue(i, TypeCodec.LongCodec.instance.serializeNoBoxing(v));
    }

    @Override
    public T setLong(String name, long v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = TypeCodec.LongCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.BIGINT, DataType.Name.COUNTER);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setTimestamp(int i, Date v) {
        this.checkType(i, DataType.Name.TIMESTAMP);
        return this.setValue(i, v == null ? null : TypeCodec.TimestampCodec.instance.serialize(v));
    }

    @Override
    public T setTimestamp(String name, Date v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = v == null ? null : TypeCodec.TimestampCodec.instance.serialize(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.TIMESTAMP);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setDate(int i, DateWithoutTime v) {
        this.checkType(i, DataType.Name.DATE);
        return this.setValue(i, TypeCodec.DateCodec.instance.serialize(v));
    }

    @Override
    public T setDate(String name, DateWithoutTime v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = TypeCodec.DateCodec.instance.serialize(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.DATE);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setTime(int i, long v) {
        this.checkType(i, DataType.Name.TIME);
        return this.setValue(i, TypeCodec.TimeCodec.instance.serializeNoBoxing(v));
    }

    @Override
    public T setTime(String name, long v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = TypeCodec.TimeCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.TIME);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setFloat(int i, float v) {
        this.checkType(i, DataType.Name.FLOAT);
        return this.setValue(i, TypeCodec.FloatCodec.instance.serializeNoBoxing(v));
    }

    @Override
    public T setFloat(String name, float v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = TypeCodec.FloatCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.FLOAT);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setDouble(int i, double v) {
        this.checkType(i, DataType.Name.DOUBLE);
        return this.setValue(i, TypeCodec.DoubleCodec.instance.serializeNoBoxing(v));
    }

    @Override
    public T setDouble(String name, double v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = TypeCodec.DoubleCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.DOUBLE);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setString(int i, String v) {
        DataType.Name type = this.checkType(i, DataType.Name.VARCHAR, DataType.Name.TEXT, DataType.Name.ASCII);
        switch (type) {
            case ASCII: {
                return this.setValue(i, v == null ? null : TypeCodec.StringCodec.asciiInstance.serialize(v));
            }
            case TEXT: 
            case VARCHAR: {
                return this.setValue(i, v == null ? null : TypeCodec.StringCodec.utf8Instance.serialize(v));
            }
        }
        throw new AssertionError();
    }

    @Override
    public T setString(String name, String v) {
        int[] indexes = this.getAllIndexesOf(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setString(indexes[i], v);
        }
        return this.wrapped;
    }

    @Override
    public T setBytes(int i, ByteBuffer v) {
        this.checkType(i, DataType.Name.BLOB);
        return (T)this.setBytesUnsafe(i, v);
    }

    @Override
    public T setBytes(String name, ByteBuffer v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = v == null ? null : v.duplicate();
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.BLOB);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setBytesUnsafe(int i, ByteBuffer v) {
        return this.setValue(i, v == null ? null : v.duplicate());
    }

    @Override
    public T setBytesUnsafe(String name, ByteBuffer v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = v == null ? null : v.duplicate();
        for (int i = 0; i < indexes.length; ++i) {
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setVarint(int i, BigInteger v) {
        this.checkType(i, DataType.Name.VARINT);
        return this.setValue(i, v == null ? null : TypeCodec.BigIntegerCodec.instance.serialize(v));
    }

    @Override
    public T setVarint(String name, BigInteger v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = v == null ? null : TypeCodec.BigIntegerCodec.instance.serialize(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.VARINT);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setDecimal(int i, BigDecimal v) {
        this.checkType(i, DataType.Name.DECIMAL);
        return this.setValue(i, v == null ? null : TypeCodec.DecimalCodec.instance.serialize(v));
    }

    @Override
    public T setDecimal(String name, BigDecimal v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = v == null ? null : TypeCodec.DecimalCodec.instance.serialize(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.DECIMAL);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setUUID(int i, UUID v) {
        DataType.Name type = this.checkType(i, DataType.Name.UUID, DataType.Name.TIMEUUID);
        if (v == null) {
            return this.setValue(i, null);
        }
        if (type == DataType.Name.TIMEUUID && v.version() != 1) {
            throw new InvalidTypeException(String.format("%s is not a Type 1 (time-based) UUID", v));
        }
        return type == DataType.Name.UUID ? this.setValue(i, TypeCodec.UUIDCodec.instance.serialize(v)) : this.setValue(i, TypeCodec.TimeUUIDCodec.instance.serialize(v));
    }

    @Override
    public T setUUID(String name, UUID v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = v == null ? null : TypeCodec.UUIDCodec.instance.serialize(v);
        for (int i = 0; i < indexes.length; ++i) {
            DataType.Name type = this.checkType(indexes[i], DataType.Name.UUID, DataType.Name.TIMEUUID);
            if (v != null && type == DataType.Name.TIMEUUID && v.version() != 1) {
                throw new InvalidTypeException(String.format("%s is not a Type 1 (time-based) UUID", v));
            }
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    @Override
    public T setInet(int i, InetAddress v) {
        this.checkType(i, DataType.Name.INET);
        return this.setValue(i, v == null ? null : TypeCodec.InetCodec.instance.serialize(v));
    }

    @Override
    public T setInet(String name, InetAddress v) {
        int[] indexes = this.getAllIndexesOf(name);
        ByteBuffer value = v == null ? null : TypeCodec.InetCodec.instance.serialize(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.checkType(indexes[i], DataType.Name.INET);
            this.setValue(indexes[i], value);
        }
        return this.wrapped;
    }

    T setToken(int i, Token v) {
        if (v == null) {
            throw new NullPointerException(String.format("Cannot set a null token for column %s", this.getName(i)));
        }
        this.checkType(i, v.getType().getName());
        return this.setValue(i, v.getType().codec(this.protocolVersion).serialize(v.getValue()));
    }

    T setToken(String name, Token v) {
        int[] indexes = this.getAllIndexesOf(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setToken(indexes[i], v);
        }
        return this.wrapped;
    }

    @Override
    public <E> T setList(int i, List<E> v) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.LIST) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a list", this.getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        if (!v.isEmpty()) {
            Class<?> providedClass = v.get(0).getClass();
            Class<?> expectedClass = type.getTypeArguments().get(0).asJavaClass();
            if (!expectedClass.isAssignableFrom(providedClass)) {
                throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting list of %s but provided list of %s", this.getName(i), type, expectedClass, providedClass));
            }
        }
        return this.setValue(i, type.codec(this.protocolVersion).serialize(v));
    }

    @Override
    public <E> T setList(String name, List<E> v) {
        int[] indexes = this.getAllIndexesOf(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setList(indexes[i], (List)v);
        }
        return this.wrapped;
    }

    @Override
    public <K, V> T setMap(int i, Map<K, V> v) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.MAP) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a map", this.getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        if (!v.isEmpty()) {
            Map.Entry<K, V> entry = v.entrySet().iterator().next();
            Class<?> providedKeysClass = entry.getKey().getClass();
            Class<?> providedValuesClass = entry.getValue().getClass();
            Class<?> expectedKeysClass = type.getTypeArguments().get((int)0).getName().javaType;
            Class<?> expectedValuesClass = type.getTypeArguments().get((int)1).getName().javaType;
            if (!expectedKeysClass.isAssignableFrom(providedKeysClass) || !expectedValuesClass.isAssignableFrom(providedValuesClass)) {
                throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting map of %s->%s but provided map of %s->%s", this.getName(i), type, expectedKeysClass, expectedValuesClass, providedKeysClass, providedValuesClass));
            }
        }
        return this.setValue(i, type.codec(this.protocolVersion).serialize(v));
    }

    @Override
    public <K, V> T setMap(String name, Map<K, V> v) {
        int[] indexes = this.getAllIndexesOf(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setMap(indexes[i], (Map)v);
        }
        return this.wrapped;
    }

    @Override
    public <E> T setSet(int i, Set<E> v) {
        Class<?> providedClass;
        Class<?> expectedClass;
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.SET) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a set", this.getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        if (!v.isEmpty() && !(expectedClass = type.getTypeArguments().get((int)0).getName().javaType).isAssignableFrom(providedClass = v.iterator().next().getClass())) {
            throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting set of %s but provided set of %s", this.getName(i), type, expectedClass, providedClass));
        }
        return this.setValue(i, type.codec(this.protocolVersion).serialize(v));
    }

    @Override
    public <E> T setSet(String name, Set<E> v) {
        int[] indexes = this.getAllIndexesOf(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setSet(indexes[i], (Set)v);
        }
        return this.wrapped;
    }

    @Override
    public T setUDTValue(int i, UDTValue v) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.UDT) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a UDT", this.getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        this.setValue(i, type.codec(ProtocolVersion.V3).serialize(v));
        return this.wrapped;
    }

    @Override
    public T setUDTValue(String name, UDTValue v) {
        int[] indexes = this.getAllIndexesOf(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setUDTValue(indexes[i], v);
        }
        return this.wrapped;
    }

    @Override
    public T setTupleValue(int i, TupleValue v) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.TUPLE) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a tuple", this.getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        this.setValue(i, type.codec(ProtocolVersion.V3).serialize(v));
        return this.wrapped;
    }

    @Override
    public T setTupleValue(String name, TupleValue v) {
        int[] indexes = this.getAllIndexesOf(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setTupleValue(indexes[i], v);
        }
        return this.wrapped;
    }

    @Override
    public T setToNull(int i) {
        return this.setValue(i, null);
    }

    @Override
    public T setToNull(String name) {
        int[] indexes = this.getAllIndexesOf(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setToNull(indexes[i]);
        }
        return this.wrapped;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractData)) {
            return false;
        }
        AbstractData that = (AbstractData)o;
        if (this.values.length != that.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            DataType thatType;
            DataType thisType = this.getType(i);
            if (!thisType.equals(thatType = that.getType(i))) {
                return false;
            }
            if (this.values[i] == null != (that.values[i] == null)) {
                return false;
            }
            if (this.values[i] == null || thisType.deserialize(this.values[i], this.protocolVersion).equals(thatType.deserialize(that.values[i], this.protocolVersion))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 31;
        for (int i = 0; i < this.values.length; ++i) {
            hash += this.values[i] == null ? 1 : this.getType(i).deserialize(this.values[i], this.protocolVersion).hashCode();
        }
        return hash;
    }
}

