/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.codec.protobuf;

import com.datastax.shaded.netty.buffer.ChannelBuffer;
import com.datastax.shaded.netty.buffer.ChannelBufferOutputStream;
import com.datastax.shaded.netty.buffer.ChannelBuffers;
import com.datastax.shaded.netty.channel.Channel;
import com.datastax.shaded.netty.channel.ChannelHandler;
import com.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.shaded.netty.handler.codec.oneone.OneToOneEncoder;
import com.google.protobuf.CodedOutputStream;
import java.io.OutputStream;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends OneToOneEncoder {
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer body = (ChannelBuffer)msg;
        int length = body.readableBytes();
        ChannelBuffer header = channel.getConfig().getBufferFactory().getBuffer(body.order(), CodedOutputStream.computeRawVarint32Size((int)length));
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance((OutputStream)new ChannelBufferOutputStream(header));
        codedOutputStream.writeRawVarint32(length);
        codedOutputStream.flush();
        return ChannelBuffers.wrappedBuffer(header, body);
    }
}

