/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;

public class TupleType
extends DataType {
    private final List<DataType> types;

    TupleType(List<DataType> types) {
        super(DataType.Name.TUPLE);
        this.types = ImmutableList.copyOf(types);
    }

    @Override
    TypeCodec<Object> codec(ProtocolVersion protocolVersion) {
        return TypeCodec.tupleOf(this);
    }

    public static TupleType of(DataType ... types) {
        return new TupleType(Arrays.asList(types));
    }

    public List<DataType> getComponentTypes() {
        return this.types;
    }

    public TupleValue newValue() {
        return new TupleValue(this);
    }

    public TupleValue newValue(Object ... values) {
        if (values.length != this.types.size()) {
            throw new IllegalArgumentException(String.format("Invalid number of values. Expecting %d but got %d", this.types.size(), values.length));
        }
        TupleValue t = this.newValue();
        for (int i = 0; i < values.length; ++i) {
            t.setValue(i, values[i] == null ? null : this.types.get(i).serialize(values[i], ProtocolVersion.V3));
        }
        return t;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.name, this.types});
    }

    public boolean equals(Object o) {
        if (!(o instanceof TupleType)) {
            return false;
        }
        TupleType d = (TupleType)o;
        return this.name == d.name && this.types.equals(d.types);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (DataType type : this.types) {
            sb.append(sb.length() == 0 ? "tuple<" : ", ");
            sb.append(type);
        }
        return sb.append(">").toString();
    }
}

