/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.policies.ExtendedRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;

public class IdempotenceAwareRetryPolicy
implements ExtendedRetryPolicy {
    private final ExtendedRetryPolicy childPolicy;
    private final QueryOptions queryOptions;

    public IdempotenceAwareRetryPolicy(ExtendedRetryPolicy childPolicy, QueryOptions queryOptions) {
        this.childPolicy = childPolicy;
        this.queryOptions = queryOptions;
    }

    @Override
    public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        return this.childPolicy.onReadTimeout(statement, cl, requiredResponses, receivedResponses, dataRetrieved, nbRetry);
    }

    @Override
    public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        if (this.isIdempotent(statement)) {
            return this.childPolicy.onWriteTimeout(statement, cl, writeType, requiredAcks, receivedAcks, nbRetry);
        }
        return RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        return this.childPolicy.onUnavailable(statement, cl, requiredReplica, aliveReplica, nbRetry);
    }

    @Override
    public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, Exception e, int nbRetry) {
        if (this.isIdempotent(statement)) {
            return this.childPolicy.onRequestError(statement, cl, e, nbRetry);
        }
        return RetryPolicy.RetryDecision.rethrow();
    }

    protected boolean isIdempotent(Statement statement) {
        Boolean myValue = statement.isIdempotent();
        if (myValue != null) {
            return myValue;
        }
        return this.queryOptions.getDefaultIdempotence();
    }
}

