/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

abstract class ParseUtils {
    private ParseUtils() {
    }

    public static int skipSpaces(String toParse, int idx) {
        while (ParseUtils.isBlank(toParse.charAt(idx)) && idx < toParse.length()) {
            ++idx;
        }
        return idx;
    }

    public static int skipCQLValue(String toParse, int idx) {
        if (idx >= toParse.length()) {
            throw new IllegalArgumentException();
        }
        if (ParseUtils.isBlank(toParse.charAt(idx))) {
            throw new IllegalArgumentException();
        }
        int cbrackets = 0;
        int sbrackets = 0;
        int parens = 0;
        boolean inString = false;
        do {
            char c = toParse.charAt(idx);
            if (inString) {
                if (c != '\'') continue;
                if (idx + 1 < toParse.length() && toParse.charAt(idx + 1) == '\'') {
                    ++idx;
                    continue;
                }
                inString = false;
                if (cbrackets != 0 || sbrackets != 0 || parens != 0) continue;
                return idx + 1;
            }
            if (c == '\'') {
                inString = true;
                continue;
            }
            if (c == '{') {
                ++cbrackets;
                continue;
            }
            if (c == '[') {
                ++sbrackets;
                continue;
            }
            if (c == '(') {
                ++parens;
                continue;
            }
            if (c == '}') {
                if (cbrackets == 0) {
                    return idx;
                }
                if (--cbrackets != 0 || sbrackets != 0 || parens != 0) continue;
                return idx + 1;
            }
            if (c == ']') {
                if (sbrackets == 0) {
                    return idx;
                }
                if (cbrackets != 0 || --sbrackets != 0 || parens != 0) continue;
                return idx + 1;
            }
            if (c == ')') {
                if (parens == 0) {
                    return idx;
                }
                if (cbrackets != 0 || sbrackets != 0 || --parens != 0) continue;
                return idx + 1;
            }
            if (!ParseUtils.isBlank(c) && ParseUtils.isIdentifierChar(c) || cbrackets != 0 || sbrackets != 0 || parens != 0) continue;
            return idx;
        } while (++idx < toParse.length());
        if (inString || cbrackets != 0 || sbrackets != 0 || parens != 0) {
            throw new IllegalArgumentException();
        }
        return idx;
    }

    public static int skipCQLId(String toParse, int idx) {
        if (idx >= toParse.length()) {
            throw new IllegalArgumentException();
        }
        char c = toParse.charAt(idx);
        if (ParseUtils.isIdentifierChar(c)) {
            while (idx < toParse.length() && ParseUtils.isIdentifierChar(toParse.charAt(idx))) {
                ++idx;
            }
            return idx;
        }
        if (c != '\"') {
            throw new IllegalArgumentException();
        }
        while (++idx < toParse.length()) {
            c = toParse.charAt(idx);
            if (c != '\"') continue;
            if (idx + 1 < toParse.length() && toParse.charAt(idx + 1) == '\"') {
                ++idx;
                continue;
            }
            return idx + 1;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isIdentifierChar(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 45 || c == 43 || c == 46 || c == 95 || c == 38;
    }

    public static boolean isBlank(int c) {
        return c == 32 || c == 9 || c == 10;
    }

    public static boolean isQuoted(String value) {
        return value != null && value.length() > 1 && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'';
    }

    public static String quote(String value) {
        return '\'' + ParseUtils.replaceChar(value, '\'', "''") + '\'';
    }

    public static String unquote(String value) {
        if (!ParseUtils.isQuoted(value)) {
            return value;
        }
        return value.substring(1, value.length() - 1).replace("''", "'");
    }

    static String replaceChar(String text, char search, String replacement) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        int nbMatch = 0;
        int start = -1;
        do {
            if ((start = text.indexOf(search, start + 1)) == -1) continue;
            ++nbMatch;
        } while (start != -1);
        if (nbMatch == 0) {
            return text;
        }
        int newLength = text.length() + nbMatch * (replacement.length() - 1);
        char[] result = new char[newLength];
        int newIdx = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == search) {
                for (int r = 0; r < replacement.length(); ++r) {
                    result[newIdx++] = replacement.charAt(r);
                }
                continue;
            }
            result[newIdx++] = c;
        }
        return new String(result);
    }
}

