/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.Bytes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

abstract class Utils {
    private static final Pattern cnamePattern = Pattern.compile("\\w+(?:\\[.+\\])?");

    Utils() {
    }

    static StringBuilder joinAndAppend(StringBuilder sb, String separator, List<? extends Appendeable> values, List<Object> variables) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            values.get(i).appendTo(sb, variables);
        }
        return sb;
    }

    static StringBuilder joinAndAppendNames(StringBuilder sb, String separator, List<Object> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            Utils.appendName(values.get(i), sb);
        }
        return sb;
    }

    static StringBuilder joinAndAppendValues(StringBuilder sb, String separator, List<Object> values, List<Object> variables) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            Utils.appendValue(values.get(i), sb, variables);
        }
        return sb;
    }

    static boolean isSerializable(Object value) {
        if (value == QueryBuilder.bindMarker() || value instanceof FCall || value instanceof CName) {
            return false;
        }
        return !(value instanceof Number) || value instanceof BigInteger || value instanceof BigDecimal;
    }

    static ByteBuffer[] convert(List<Object> values, int protocolVersion) {
        ByteBuffer[] serializedValues = new ByteBuffer[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            try {
                serializedValues[i] = DataType.serializeValue(values.get(i), protocolVersion);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Value %d of type %s does not correspond to any CQL3 type", i, values.get(i).getClass()));
            }
        }
        return serializedValues;
    }

    static StringBuilder appendValue(Object value, StringBuilder sb, List<Object> variables) {
        if (variables == null || !Utils.isSerializable(value)) {
            return Utils.appendValue(value, sb);
        }
        sb.append('?');
        variables.add(value);
        return sb;
    }

    private static StringBuilder appendValue(Object value, StringBuilder sb) {
        if (Utils.appendValueIfLiteral(value, sb)) {
            return sb;
        }
        if (Utils.appendValueIfCollection(value, sb)) {
            return sb;
        }
        Utils.appendStringIfValid(value, sb);
        return sb;
    }

    static StringBuilder appendFlatValue(Object value, StringBuilder sb) {
        if (Utils.appendValueIfLiteral(value, sb)) {
            return sb;
        }
        Utils.appendStringIfValid(value, sb);
        return sb;
    }

    private static void appendStringIfValid(Object value, StringBuilder sb) {
        if (value instanceof RawString) {
            sb.append(value.toString());
        } else {
            if (!(value instanceof String)) {
                String msg = String.format("Invalid value %s of type unknown to the query builder", value);
                if (value instanceof byte[]) {
                    msg = msg + " (for blob values, make sure to use a ByteBuffer)";
                }
                throw new IllegalArgumentException(msg);
            }
            Utils.appendValueString((String)value, sb);
        }
    }

    private static boolean appendValueIfLiteral(Object value, StringBuilder sb) {
        if (value instanceof Number || value instanceof UUID || value instanceof Boolean) {
            sb.append(value);
            return true;
        }
        if (value instanceof InetAddress) {
            sb.append('\'').append(((InetAddress)value).getHostAddress()).append('\'');
            return true;
        }
        if (value instanceof Date) {
            sb.append(((Date)value).getTime());
            return true;
        }
        if (value instanceof ByteBuffer) {
            sb.append(Bytes.toHexString((ByteBuffer)value));
            return true;
        }
        if (value instanceof BindMarker) {
            sb.append(value);
            return true;
        }
        if (value instanceof FCall) {
            FCall fcall = (FCall)value;
            sb.append(fcall.name).append('(');
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                Utils.appendValue(fcall.parameters[i], sb, null);
            }
            sb.append(')');
            return true;
        }
        if (value instanceof CName) {
            Utils.appendName(((CName)value).name, sb);
            return true;
        }
        if (value == null) {
            sb.append("null");
            return true;
        }
        return false;
    }

    private static boolean appendValueIfCollection(Object value, StringBuilder sb) {
        if (value instanceof List) {
            Utils.appendList((List)value, sb);
            return true;
        }
        if (value instanceof Set) {
            Utils.appendSet((Set)value, sb);
            return true;
        }
        if (value instanceof Map) {
            Utils.appendMap((Map)value, sb);
            return true;
        }
        return false;
    }

    static StringBuilder appendCollection(Object value, StringBuilder sb, List<Object> variables) {
        if (variables == null || !Utils.isSerializable(value)) {
            boolean wasCollection = Utils.appendValueIfCollection(value, sb);
            assert (wasCollection);
        } else {
            sb.append('?');
            variables.add(value);
        }
        return sb;
    }

    static StringBuilder appendList(List<?> l, StringBuilder sb) {
        sb.append('[');
        for (int i = 0; i < l.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            Utils.appendFlatValue(l.get(i), sb);
        }
        sb.append(']');
        return sb;
    }

    static StringBuilder appendSet(Set<?> s, StringBuilder sb) {
        sb.append('{');
        boolean first = true;
        for (Object elt : s) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendFlatValue(elt, sb);
        }
        sb.append('}');
        return sb;
    }

    static StringBuilder appendMap(Map<?, ?> m, StringBuilder sb) {
        sb.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendFlatValue(entry.getKey(), sb);
            sb.append(':');
            Utils.appendFlatValue(entry.getValue(), sb);
        }
        sb.append('}');
        return sb;
    }

    static boolean containsBindMarker(Object value) {
        if (value == QueryBuilder.bindMarker()) {
            return true;
        }
        if (!(value instanceof FCall)) {
            return false;
        }
        FCall fcall = (FCall)value;
        for (Object param : fcall.parameters) {
            if (!Utils.containsBindMarker(param)) continue;
            return true;
        }
        return false;
    }

    private static StringBuilder appendValueString(String value, StringBuilder sb) {
        return sb.append(DataType.text().format(value));
    }

    static boolean isRawValue(Object value) {
        return value != null && !(value instanceof FCall) && !(value instanceof CName) && !(value instanceof BindMarker);
    }

    static String toRawString(Object value) {
        return Utils.appendValue(value, new StringBuilder()).toString();
    }

    static StringBuilder appendName(String name, StringBuilder sb) {
        if (cnamePattern.matcher(name = name.trim()).matches() || name.startsWith("\"") || name.startsWith("token(")) {
            sb.append(name);
        } else {
            sb.append('\"').append(name).append('\"');
        }
        return sb;
    }

    static StringBuilder appendName(Object name, StringBuilder sb) {
        if (name instanceof String) {
            Utils.appendName((String)name, sb);
        } else if (name instanceof CName) {
            Utils.appendName(((CName)name).name, sb);
        } else if (name instanceof FCall) {
            FCall fcall = (FCall)name;
            sb.append(fcall.name).append('(');
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                Utils.appendValue(fcall.parameters[i], sb, null);
            }
            sb.append(')');
        } else if (name instanceof Alias) {
            Alias alias = (Alias)name;
            Utils.appendName(alias.column, sb);
            sb.append(" AS ").append(alias.alias);
        } else {
            throw new IllegalArgumentException(String.format("Invalid column %s of type unknown of the query builder", name));
        }
        return sb;
    }

    static class Alias {
        private final Object column;
        private final String alias;

        Alias(Object column, String alias) {
            this.column = column;
            this.alias = alias;
        }

        public String toString() {
            return String.format("%s AS %s", this.column, this.alias);
        }
    }

    static class CName {
        private final String name;

        CName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static class FCall {
        private final String name;
        private final Object[] parameters;

        FCall(String name, Object ... parameters) {
            this.name = name;
            this.parameters = parameters;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append('(');
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.parameters[i]);
            }
            sb.append(')');
            return sb.toString();
        }
    }

    static class RawString {
        private final String str;

        RawString(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    static abstract class Appendeable {
        Appendeable() {
        }

        abstract void appendTo(StringBuilder var1, List<Object> var2);

        abstract boolean containsBindMarker();
    }
}

