/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractData;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.UserType;

public class UDTValue
extends AbstractData<UDTValue> {
    private final UserType definition;

    UDTValue(UserType definition) {
        super(3, definition.size());
        this.definition = definition;
    }

    @Override
    protected DataType getType(int i) {
        return this.definition.byIdx[i].getType();
    }

    @Override
    protected String getName(int i) {
        return this.definition.byIdx[i].getName();
    }

    @Override
    protected int[] getAllIndexesOf(String name) {
        int[] indexes = this.definition.byName.get(Metadata.handleId(name));
        if (indexes == null) {
            throw new IllegalArgumentException(name + " is not a field defined in this UDT");
        }
        return indexes;
    }

    public UserType getType() {
        return this.definition;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UDTValue)) {
            return false;
        }
        UDTValue that = (UDTValue)o;
        if (!this.definition.equals(that.definition)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getName(i));
            sb.append(":");
            DataType dt = this.getType(i);
            sb.append(this.values[i] == null ? "null" : dt.format(dt.deserialize(this.values[i], 3)));
        }
        sb.append("}");
        return sb.toString();
    }
}

