/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.channel.local;

import com.datastax.shaded.netty.channel.AbstractServerChannel;
import com.datastax.shaded.netty.channel.ChannelConfig;
import com.datastax.shaded.netty.channel.ChannelFactory;
import com.datastax.shaded.netty.channel.ChannelPipeline;
import com.datastax.shaded.netty.channel.ChannelSink;
import com.datastax.shaded.netty.channel.Channels;
import com.datastax.shaded.netty.channel.DefaultServerChannelConfig;
import com.datastax.shaded.netty.channel.local.LocalAddress;
import com.datastax.shaded.netty.channel.local.LocalServerChannel;
import java.util.concurrent.atomic.AtomicBoolean;

final class DefaultLocalServerChannel
extends AbstractServerChannel
implements LocalServerChannel {
    final ChannelConfig channelConfig;
    final AtomicBoolean bound = new AtomicBoolean();
    volatile LocalAddress localAddress;

    DefaultLocalServerChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        super(factory, pipeline, sink);
        this.channelConfig = new DefaultServerChannelConfig();
        Channels.fireChannelOpen(this);
    }

    public ChannelConfig getConfig() {
        return this.channelConfig;
    }

    public boolean isBound() {
        return this.isOpen() && this.bound.get();
    }

    public LocalAddress getLocalAddress() {
        return this.isBound() ? this.localAddress : null;
    }

    public LocalAddress getRemoteAddress() {
        return null;
    }

    protected boolean setClosed() {
        return super.setClosed();
    }
}

