/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.channel;

import com.datastax.shaded.netty.channel.Channel;
import com.datastax.shaded.netty.channel.ChannelFuture;
import com.datastax.shaded.netty.channel.Channels;
import com.datastax.shaded.netty.channel.ExceptionEvent;
import com.datastax.shaded.netty.util.internal.StackTraceSimplifier;

public class DefaultExceptionEvent
implements ExceptionEvent {
    private final Channel channel;
    private final Throwable cause;

    public DefaultExceptionEvent(Channel channel, Throwable cause) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        this.channel = channel;
        this.cause = cause;
        StackTraceSimplifier.simplify(cause);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        return this.getChannel().toString() + " EXCEPTION: " + this.cause;
    }
}

