/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.QueryTrace;
import java.util.List;

public class ExecutionInfo {
    private final List<Host> triedHosts;
    private final ConsistencyLevel achievedConsistency;
    private final QueryTrace trace;

    private ExecutionInfo(List<Host> triedHosts, ConsistencyLevel achievedConsistency, QueryTrace trace) {
        this.triedHosts = triedHosts;
        this.achievedConsistency = achievedConsistency;
        this.trace = trace;
    }

    ExecutionInfo(List<Host> triedHosts) {
        this(triedHosts, null, null);
    }

    ExecutionInfo withTrace(QueryTrace newTrace) {
        return new ExecutionInfo(this.triedHosts, this.achievedConsistency, newTrace);
    }

    ExecutionInfo withAchievedConsistency(ConsistencyLevel newConsistency) {
        return new ExecutionInfo(this.triedHosts, newConsistency, this.trace);
    }

    public List<Host> getTriedHosts() {
        return this.triedHosts;
    }

    public Host getQueriedHost() {
        return this.triedHosts.get(this.triedHosts.size() - 1);
    }

    public ConsistencyLevel getAchievedConsistencyLevel() {
        return this.achievedConsistency;
    }

    public QueryTrace getQueryTrace() {
        return this.trace;
    }
}

