/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConvictionPolicy;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.VersionNumber;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Host {
    private static final Logger logger = LoggerFactory.getLogger(Host.class);
    private final InetSocketAddress address;
    private volatile boolean isUp;
    private final ConvictionPolicy policy;
    final AtomicReference<ScheduledFuture<?>> reconnectionAttempt = new AtomicReference();
    final ExecutionInfo defaultExecutionInfo;
    private volatile String datacenter;
    private volatile String rack;
    private volatile VersionNumber cassandraVersion;
    volatile InetAddress listenAddress;

    Host(InetSocketAddress address, ConvictionPolicy.Factory policy) {
        if (address == null || policy == null) {
            throw new NullPointerException();
        }
        this.address = address;
        this.policy = policy.create(this);
        this.defaultExecutionInfo = new ExecutionInfo((List<Host>)ImmutableList.of((Object)this));
    }

    void setLocationInfo(String datacenter, String rack) {
        this.datacenter = datacenter;
        this.rack = rack;
    }

    void setVersionAndListenAdress(String cassandraVersion, InetAddress listenAddress) {
        if (listenAddress != null) {
            this.listenAddress = listenAddress;
        }
        if (cassandraVersion == null) {
            return;
        }
        try {
            this.cassandraVersion = VersionNumber.parse(cassandraVersion);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error parsing Cassandra version {}. This shouldn't have happened", (Object)cassandraVersion);
        }
    }

    public InetAddress getAddress() {
        return this.address.getAddress();
    }

    public InetSocketAddress getSocketAddress() {
        return this.address;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getRack() {
        return this.rack;
    }

    public VersionNumber getCassandraVersion() {
        return this.cassandraVersion;
    }

    public boolean isUp() {
        return this.isUp;
    }

    public final int hashCode() {
        return this.address.hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof Host)) {
            return false;
        }
        return this.address.equals(((Host)o).address);
    }

    public String toString() {
        return this.address.toString();
    }

    void setDown() {
        this.isUp = false;
    }

    void setUp() {
        this.policy.reset();
        this.isUp = true;
    }

    boolean signalConnectionFailure(ConnectionException exception) {
        return this.policy.addFailure(exception);
    }

    public static interface StateListener {
        public void onAdd(Host var1);

        public void onUp(Host var1);

        public void onDown(Host var1);

        public void onRemove(Host var1);
    }
}

