/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.FrameCompressor;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.exceptions.DriverInternalError;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.TooLongFrameException;
import java.util.EnumSet;
import java.util.List;

class Frame {
    public final Header header;
    public final ByteBuf body;

    private Frame(Header header, ByteBuf body) {
        this.header = header;
        this.body = body;
    }

    private static Frame create(ByteBuf fullFrame) {
        assert (fullFrame.readableBytes() >= 8) : String.format("Frame too short (%d bytes)", fullFrame.readableBytes());
        int version = fullFrame.readByte();
        byte flags = fullFrame.readByte();
        byte streamId = fullFrame.readByte();
        byte opcode = fullFrame.readByte();
        int length = fullFrame.readInt();
        assert (length == fullFrame.readableBytes());
        Header header = new Header(version &= 0x7F, flags, (int)streamId, (int)opcode);
        return new Frame(header, fullFrame);
    }

    public static Frame create(int version, int opcode, int streamId, EnumSet<Header.Flag> flags, ByteBuf body) {
        Header header = new Header(version, flags, streamId, opcode);
        return new Frame(header, body);
    }

    public Frame with(ByteBuf newBody) {
        return new Frame(this.header, newBody);
    }

    public static class Compressor
    extends MessageToMessageEncoder<Frame> {
        private final FrameCompressor compressor;

        public Compressor(FrameCompressor compressor) {
            assert (compressor != null);
            this.compressor = compressor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void encode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            if (frame.header.opcode == Message.Request.Type.STARTUP.opcode) {
                out.add(frame);
            } else {
                frame.header.flags.add(Header.Flag.COMPRESSED);
                ByteBuf uncompressedBody = frame.body;
                try {
                    out.add(this.compressor.compress(frame));
                }
                finally {
                    uncompressedBody.release();
                }
            }
        }
    }

    public static class Decompressor
    extends MessageToMessageDecoder<Frame> {
        private final FrameCompressor compressor;

        public Decompressor(FrameCompressor compressor) {
            assert (compressor != null);
            this.compressor = compressor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void decode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            if (frame.header.flags.contains((Object)Header.Flag.COMPRESSED)) {
                ByteBuf compressedBody = frame.body;
                try {
                    out.add(this.compressor.decompress(frame));
                }
                finally {
                    compressedBody.release();
                }
            } else {
                out.add(frame);
            }
        }
    }

    @ChannelHandler.Sharable
    public static class Encoder
    extends MessageToMessageEncoder<Frame> {
        protected void encode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            ByteBuf header = ctx.alloc().ioBuffer(8);
            header.writeByte(frame.header.version);
            header.writeByte(Header.Flag.serialize(frame.header.flags));
            header.writeByte(frame.header.streamId);
            header.writeByte(frame.header.opcode);
            header.writeInt(frame.body.readableBytes());
            out.add(header);
            out.add(frame.body);
        }
    }

    public static class Decoder
    extends LengthFieldBasedFrameDecoder {
        private static final int MAX_FRAME_LENTH = 0x10000000;

        public Decoder() {
            super(0x10000000, 4, 4, 0, 0, true);
        }

        protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
            try {
                ByteBuf frame;
                if (buffer.readableBytes() == 0) {
                    return null;
                }
                if (buffer.readableBytes() >= 4) {
                    Message.Response.Type.fromOpcode(buffer.getByte(3));
                }
                if ((frame = (ByteBuf)super.decode(ctx, buffer)) == null) {
                    return null;
                }
                return Frame.create(frame);
            }
            catch (CorruptedFrameException e) {
                throw new DriverInternalError(e.getMessage());
            }
            catch (TooLongFrameException e) {
                throw new DriverInternalError(e.getMessage());
            }
        }
    }

    public static class Header {
        public static final int LENGTH = 8;
        public final int version;
        public final EnumSet<Flag> flags;
        public final int streamId;
        public final int opcode;

        private Header(int version, int flags, int streamId, int opcode) {
            this(version, Flag.deserialize(flags), streamId, opcode);
        }

        private Header(int version, EnumSet<Flag> flags, int streamId, int opcode) {
            this.version = version;
            this.flags = flags;
            this.streamId = streamId;
            this.opcode = opcode;
        }

        public static enum Flag {
            COMPRESSED,
            TRACING;


            public static EnumSet<Flag> deserialize(int flags) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                Flag[] values = Flag.values();
                for (int n = 0; n < 8; ++n) {
                    if ((flags & 1 << n) == 0) continue;
                    set.add(values[n]);
                }
                return set;
            }

            public static int serialize(EnumSet<Flag> flags) {
                int i = 0;
                for (Flag flag : flags) {
                    i |= 1 << flag.ordinal();
                }
                return i;
            }
        }
    }
}

