/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.PagingStateException;
import com.datastax.driver.core.utils.Bytes;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class PagingState {
    private byte[] pagingState;
    private byte[] hash;

    PagingState(ByteBuffer pagingState, Statement statement) {
        this.pagingState = Bytes.getArray(pagingState);
        this.hash = this.hash(statement);
    }

    private PagingState(byte[] complete) {
        ByteBuffer pagingStateBB = ByteBuffer.wrap(complete);
        short pagingSize = pagingStateBB.getShort();
        short hashSize = pagingStateBB.getShort();
        if (pagingSize + hashSize != pagingStateBB.remaining()) {
            throw new PagingStateException("Cannot deserialize paging state, invalid format. The serialized form was corrupted, or not initially generated from a PagingState object.");
        }
        this.pagingState = PagingState.extractPagingState(complete);
        this.hash = PagingState.extractHashDigest(complete);
    }

    private byte[] hash(Statement statement) {
        byte[] digest;
        assert (!(statement instanceof BatchStatement));
        try {
            ByteBuffer[] values;
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (statement instanceof BoundStatement) {
                BoundStatement bs = (BoundStatement)statement;
                md.update(bs.preparedStatement().getQueryString().getBytes());
                values = bs.values;
            } else {
                ByteBuffer[] rs = (ByteBuffer[])statement;
                md.update(rs.getQueryString().getBytes());
                values = rs.getValues();
            }
            if (values != null) {
                for (ByteBuffer value : values) {
                    md.update(value.duplicate());
                }
            }
            md.update(this.pagingState);
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 doesn't seem to be available on this JVM", e);
        }
        return digest;
    }

    boolean matches(Statement statement) {
        byte[] toTest = this.hash(statement);
        return Arrays.equals(toTest, this.hash);
    }

    private static byte[] extractPagingState(byte[] complete) {
        ByteBuffer completeBB = ByteBuffer.wrap(complete);
        short size = completeBB.getShort();
        byte[] array = new byte[size];
        completeBB.getShort();
        completeBB.get(array);
        return array;
    }

    private static byte[] extractHashDigest(byte[] complete) {
        ByteBuffer completeBB = ByteBuffer.wrap(complete);
        short pagingSize = completeBB.getShort();
        short hashSize = completeBB.getShort();
        completeBB.position(pagingSize + 4);
        byte[] array = new byte[hashSize];
        completeBB.get(array);
        return array;
    }

    private ByteBuffer generateCompleteOutput() {
        ByteBuffer res = ByteBuffer.allocate(this.pagingState.length + this.hash.length + 4);
        res.putShort((short)this.pagingState.length);
        res.putShort((short)this.hash.length);
        res.put(this.pagingState);
        res.put(this.hash);
        res.rewind();
        return res;
    }

    ByteBuffer getRawState() {
        return ByteBuffer.wrap(this.pagingState);
    }

    public String toString() {
        return Bytes.toRawHexString(this.generateCompleteOutput());
    }

    public static PagingState fromString(String string) {
        try {
            byte[] complete = Bytes.fromRawHexString(string, 0);
            return new PagingState(complete);
        }
        catch (Exception e) {
            throw new PagingStateException("Cannot deserialize paging state, invalid format. The serialized form was corrupted, or not initially generated from a PagingState object.", e);
        }
    }

    public byte[] toBytes() {
        return this.generateCompleteOutput().array();
    }

    public static PagingState fromBytes(byte[] pagingState) {
        return new PagingState(pagingState);
    }
}

