/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CassandraTypeParser;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleJSONParser;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.VersionNumber;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ColumnMetadata {
    private static final String COLUMN_NAME = "column_name";
    private static final String VALIDATOR = "validator";
    private static final String COMPONENT_INDEX = "component_index";
    private static final String KIND = "type";
    private static final String INDEX_TYPE = "index_type";
    private static final String INDEX_OPTIONS = "index_options";
    private static final String INDEX_NAME = "index_name";
    private static final String CUSTOM_INDEX_CLASS = "class_name";
    private final TableMetadata table;
    private final String name;
    private final DataType type;
    private final IndexMetadata index;
    private final boolean isStatic;

    private ColumnMetadata(TableMetadata table, String name, DataType type, boolean isStatic, Map<String, String> indexColumns) {
        this.table = table;
        this.name = name;
        this.type = type;
        this.isStatic = isStatic;
        this.index = IndexMetadata.build(this, indexColumns);
    }

    static ColumnMetadata fromRaw(TableMetadata tm, Raw raw) {
        return new ColumnMetadata(tm, raw.name, raw.dataType, raw.kind == Raw.Kind.STATIC, raw.indexColumns);
    }

    static ColumnMetadata forAlias(TableMetadata tm, String name, DataType type) {
        return new ColumnMetadata(tm, name, type, false, Collections.<String, String>emptyMap());
    }

    public String getName() {
        return this.name;
    }

    public TableMetadata getTable() {
        return this.table;
    }

    public DataType getType() {
        return this.type;
    }

    public IndexMetadata getIndex() {
        return this.index;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMetadata that = (ColumnMetadata)o;
        if (this.isStatic != that.isStatic) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return !(this.index == null ? that.index != null : !this.index.equals(that.index));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
        result = 31 * result + (this.isStatic ? 1 : 0);
        return result;
    }

    public String toString() {
        String str = Metadata.escapeId(this.name) + ' ' + this.type;
        return this.isStatic ? str + " static" : str;
    }

    static class Raw {
        public final String name;
        public final Kind kind;
        public final int componentIndex;
        public final DataType dataType;
        public final boolean isReversed;
        public final Map<String, String> indexColumns = new HashMap<String, String>();

        Raw(String name, Kind kind, int componentIndex, DataType dataType, boolean isReversed) {
            this.name = name;
            this.kind = kind;
            this.componentIndex = componentIndex;
            this.dataType = dataType;
            this.isReversed = isReversed;
        }

        static Raw fromRow(Row row, VersionNumber version) {
            String name = row.getString(ColumnMetadata.COLUMN_NAME);
            Kind kind = version.getMajor() < 2 || row.isNull(ColumnMetadata.KIND) ? Kind.REGULAR : Enum.valueOf(Kind.class, row.getString(ColumnMetadata.KIND).toUpperCase());
            int componentIndex = row.isNull(ColumnMetadata.COMPONENT_INDEX) ? 0 : row.getInt(ColumnMetadata.COMPONENT_INDEX);
            String validatorStr = row.getString(ColumnMetadata.VALIDATOR);
            boolean reversed = CassandraTypeParser.isReversed(validatorStr);
            DataType dataType = CassandraTypeParser.parseOne(validatorStr);
            Raw c = new Raw(name, kind, componentIndex, dataType, reversed);
            for (String str : Arrays.asList(ColumnMetadata.INDEX_TYPE, ColumnMetadata.INDEX_NAME, ColumnMetadata.INDEX_OPTIONS)) {
                if (row.isNull(str)) continue;
                c.indexColumns.put(str, row.getString(str));
            }
            return c;
        }

        public static enum Kind {
            PARTITION_KEY,
            CLUSTERING_KEY,
            REGULAR,
            COMPACT_VALUE,
            STATIC;

        }
    }

    public static class IndexMetadata {
        private final ColumnMetadata column;
        private final String name;
        private final String customClassName;

        private IndexMetadata(ColumnMetadata column, String name, String customClassName) {
            this.column = column;
            this.name = name;
            this.customClassName = customClassName;
        }

        public ColumnMetadata getIndexedColumn() {
            return this.column;
        }

        public String getName() {
            return this.name;
        }

        public boolean isCustomIndex() {
            return this.customClassName != null;
        }

        public String getIndexClassName() {
            return this.customClassName;
        }

        public String asCQLQuery() {
            TableMetadata table = this.column.getTable();
            String ksName = Metadata.escapeId(table.getKeyspace().getName());
            String cfName = Metadata.escapeId(table.getName());
            String colName = Metadata.escapeId(this.column.getName());
            return this.isCustomIndex() ? String.format("CREATE CUSTOM INDEX %s ON %s.%s (%s) USING '%s';", this.name, ksName, cfName, colName, this.customClassName) : String.format("CREATE INDEX %s ON %s.%s (%s);", this.name, ksName, cfName, colName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexMetadata that = (IndexMetadata)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return !(this.customClassName == null ? that.customClassName != null : !this.customClassName.equals(that.customClassName));
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.customClassName != null ? this.customClassName.hashCode() : 0);
            return result;
        }

        private static IndexMetadata build(ColumnMetadata column, Map<String, String> indexColumns) {
            if (indexColumns.isEmpty()) {
                return null;
            }
            String type = indexColumns.get(ColumnMetadata.INDEX_TYPE);
            if (type == null) {
                return null;
            }
            if (!type.equalsIgnoreCase("CUSTOM") || !indexColumns.containsKey(ColumnMetadata.INDEX_OPTIONS)) {
                return new IndexMetadata(column, indexColumns.get(ColumnMetadata.INDEX_NAME), null);
            }
            Map<String, String> indexOptions = SimpleJSONParser.parseStringMap(indexColumns.get(ColumnMetadata.INDEX_OPTIONS));
            return new IndexMetadata(column, indexColumns.get(ColumnMetadata.INDEX_NAME), indexOptions.get(ColumnMetadata.CUSTOM_INDEX_CLASS));
        }
    }
}

