/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;

public class PoolingOptions {
    private static final int DEFAULT_MAX_REQUESTS = 100;
    private static final int DEFAULT_CORE_POOL_LOCAL = 2;
    private static final int DEFAULT_CORE_POOL_REMOTE = 1;
    private static final int DEFAULT_MAX_POOL_LOCAL = 8;
    private static final int DEFAULT_MAX_POOL_REMOTE = 2;
    private static final int DEFAULT_IDLE_TIMEOUT_SECONDS = 120;
    private static final int DEFAULT_POOL_TIMEOUT_MILLIS = 5000;
    private static final int DEFAULT_HEARTBEAT_INTERVAL_SECONDS = 30;
    private static final Executor DEFAULT_INITIALIZATION_EXECUTOR = MoreExecutors.sameThreadExecutor();
    private volatile Cluster.Manager manager;
    private final int[] maxSimultaneousRequests = new int[]{100, 100, 0};
    private final int[] coreConnections = new int[]{2, 1, 0};
    private final int[] maxConnections = new int[]{8, 2, 0};
    private volatile int idleTimeoutSeconds = 120;
    private volatile int poolTimeoutMillis = 5000;
    private volatile int heartbeatIntervalSeconds = 30;
    private volatile Executor initializationExecutor = DEFAULT_INITIALIZATION_EXECUTOR;

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    @Deprecated
    public int getMinSimultaneousRequestsPerConnectionThreshold(HostDistance distance) {
        return 0;
    }

    @Deprecated
    public synchronized PoolingOptions setMinSimultaneousRequestsPerConnectionThreshold(HostDistance distance, int newMinSimultaneousRequests) {
        return this;
    }

    public int getMaxSimultaneousRequestsPerConnectionThreshold(HostDistance distance) {
        return this.maxSimultaneousRequests[distance.ordinal()];
    }

    public synchronized PoolingOptions setMaxSimultaneousRequestsPerConnectionThreshold(HostDistance distance, int newMaxSimultaneousRequests) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set max simultaneous requests per connection threshold for " + (Object)((Object)distance) + " hosts");
        }
        PoolingOptions.checkRequestsPerConnectionRange(newMaxSimultaneousRequests, "Max simultaneous requests per connection", distance);
        this.maxSimultaneousRequests[distance.ordinal()] = newMaxSimultaneousRequests;
        return this;
    }

    public int getCoreConnectionsPerHost(HostDistance distance) {
        return this.coreConnections[distance.ordinal()];
    }

    public synchronized PoolingOptions setCoreConnectionsPerHost(HostDistance distance, int newCoreConnections) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set core connections per host for " + (Object)((Object)distance) + " hosts");
        }
        PoolingOptions.checkConnectionsPerHostOrder(newCoreConnections, this.maxConnections[distance.ordinal()], distance);
        int oldCore = this.coreConnections[distance.ordinal()];
        this.coreConnections[distance.ordinal()] = newCoreConnections;
        if (oldCore < newCoreConnections && this.manager != null) {
            this.manager.ensurePoolsSizing();
        }
        return this;
    }

    public int getMaxConnectionsPerHost(HostDistance distance) {
        return this.maxConnections[distance.ordinal()];
    }

    public synchronized PoolingOptions setMaxConnectionsPerHost(HostDistance distance, int newMaxConnections) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set max connections per host for " + (Object)((Object)distance) + " hosts");
        }
        PoolingOptions.checkConnectionsPerHostOrder(this.coreConnections[distance.ordinal()], newMaxConnections, distance);
        this.maxConnections[distance.ordinal()] = newMaxConnections;
        return this;
    }

    public synchronized PoolingOptions setConnectionsPerHost(HostDistance distance, int core, int max) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set connections per host for " + (Object)((Object)distance) + " hosts");
        }
        PoolingOptions.checkConnectionsPerHostOrder(core, max, distance);
        this.coreConnections[distance.ordinal()] = core;
        this.maxConnections[distance.ordinal()] = max;
        return this;
    }

    public int getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public PoolingOptions setIdleTimeoutSeconds(int idleTimeoutSeconds) {
        if (idleTimeoutSeconds < 0) {
            throw new IllegalArgumentException("Idle timeout must be positive");
        }
        this.idleTimeoutSeconds = idleTimeoutSeconds;
        return this;
    }

    public int getPoolTimeoutMillis() {
        return this.poolTimeoutMillis;
    }

    public PoolingOptions setPoolTimeoutMillis(int poolTimeoutMillis) {
        if (poolTimeoutMillis < 0) {
            throw new IllegalArgumentException("Pool timeout must be positive");
        }
        this.poolTimeoutMillis = poolTimeoutMillis;
        return this;
    }

    public int getHeartbeatIntervalSeconds() {
        return this.heartbeatIntervalSeconds;
    }

    public PoolingOptions setHeartbeatIntervalSeconds(int heartbeatIntervalSeconds) {
        if (heartbeatIntervalSeconds < 0) {
            throw new IllegalArgumentException("Heartbeat interval must be positive");
        }
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
        return this;
    }

    public Executor getInitializationExecutor() {
        return this.initializationExecutor;
    }

    public PoolingOptions setInitializationExecutor(Executor initializationExecutor) {
        Preconditions.checkNotNull((Object)initializationExecutor);
        this.initializationExecutor = initializationExecutor;
        return this;
    }

    public void refreshConnectedHosts() {
        this.manager.refreshConnectedHosts();
    }

    public void refreshConnectedHost(Host host) {
        this.manager.refreshConnectedHost(host);
    }

    private static void checkRequestsPerConnectionRange(int value, String description, HostDistance distance) {
        if (value < 0 || value > 128) {
            throw new IllegalArgumentException(String.format("%s for %s hosts must be in the range (0, %d)", new Object[]{description, distance, 128}));
        }
    }

    private static void checkConnectionsPerHostOrder(int core, int max, HostDistance distance) {
        if (core > max) {
            throw new IllegalArgumentException(String.format("Core connections for %s hosts must be less than max (%d > %d)", new Object[]{distance, core, max}));
        }
    }
}

