/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractGettableData;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.exceptions.DriverInternalError;
import java.nio.ByteBuffer;
import java.util.List;

class ArrayBackedRow
extends AbstractGettableData
implements Row {
    private final Token.Factory tokenFactory;
    private final List<ByteBuffer> data;

    private ArrayBackedRow(ColumnDefinitions metadata, Token.Factory tokenFactory, List<ByteBuffer> data) {
        super(metadata);
        this.tokenFactory = tokenFactory;
        this.data = data;
    }

    static Row fromData(ColumnDefinitions metadata, Token.Factory tokenFactory, List<ByteBuffer> data) {
        if (data == null) {
            return null;
        }
        return new ArrayBackedRow(metadata, tokenFactory, data);
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    @Override
    protected ByteBuffer getValue(int i) {
        return this.data.get(i);
    }

    @Override
    public Token getToken(int i) {
        if (this.tokenFactory == null) {
            throw new DriverInternalError("Token factory not set. This should only happen at initialization time");
        }
        this.metadata.checkType(i, this.tokenFactory.getTokenType().getName());
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return this.tokenFactory.deserialize(value);
    }

    @Override
    public Token getToken(String name) {
        return this.getToken(this.metadata.getFirstIdx(name));
    }

    @Override
    public Token getPartitionKeyToken() {
        int i = 0;
        for (ColumnDefinitions.Definition column : this.metadata) {
            if (column.getName().matches("token(.*)")) {
                return this.getToken(i);
            }
            ++i;
        }
        throw new IllegalStateException("Found no column named 'token(...)'. If the column is aliased, use getToken(String).");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Row[");
        for (int i = 0; i < this.metadata.size(); ++i) {
            ByteBuffer bb;
            if (i != 0) {
                sb.append(", ");
            }
            if ((bb = this.getValue(i)) == null) {
                sb.append("NULL");
                continue;
            }
            sb.append(this.metadata.getType(i).codec().deserialize(bb).toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

