/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ExceptionCode;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.ProtocolEvent;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidConfigurationInQueryException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.TruncateException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.utils.Bytes;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;

class Responses {
    private Responses() {
    }

    public static class AuthSuccess
    extends Message.Response {
        public static final Message.Decoder<AuthSuccess> decoderV1 = new Message.Decoder<AuthSuccess>(){

            @Override
            public AuthSuccess decode(ChannelBuffer body) {
                throw new DriverInternalError("Got AUTH_SUCCESS in protocol V1, this shouldn't happen since AUTH_SUCCESS is a protocol V2 only message");
            }
        };
        public static final Message.Decoder<AuthSuccess> decoderV2 = new Message.Decoder<AuthSuccess>(){

            @Override
            public AuthSuccess decode(ChannelBuffer body) {
                ByteBuffer b = CBUtil.readValue(body);
                if (b == null) {
                    return new AuthSuccess(null);
                }
                byte[] token = new byte[b.remaining()];
                b.get(token);
                return new AuthSuccess(token);
            }
        };
        public final byte[] token;

        private AuthSuccess(byte[] token) {
            super(Message.Response.Type.AUTH_SUCCESS);
            this.token = token;
        }
    }

    public static class AuthChallenge
    extends Message.Response {
        public static final Message.Decoder<AuthChallenge> decoderV1 = new Message.Decoder<AuthChallenge>(){

            @Override
            public AuthChallenge decode(ChannelBuffer body) {
                throw new DriverInternalError("Got AUTH_CHALLENGE in protocol V1, this shouldn't happen since AUTH_CHALLENGE is a protocol V2 only message");
            }
        };
        public static final Message.Decoder<AuthChallenge> decoderV2 = new Message.Decoder<AuthChallenge>(){

            @Override
            public AuthChallenge decode(ChannelBuffer body) {
                ByteBuffer b = CBUtil.readValue(body);
                if (b == null) {
                    return new AuthChallenge(null);
                }
                byte[] token = new byte[b.remaining()];
                b.get(token);
                return new AuthChallenge(token);
            }
        };
        public final byte[] token;

        private AuthChallenge(byte[] token) {
            super(Message.Response.Type.AUTH_CHALLENGE);
            this.token = token;
        }
    }

    public static class Event
    extends Message.Response {
        public static final Message.Decoder<Event> decoder = new Message.Decoder<Event>(){

            @Override
            public Event decode(ChannelBuffer body) {
                return new Event(ProtocolEvent.deserialize(body));
            }
        };
        public final ProtocolEvent event;

        public Event(ProtocolEvent event) {
            super(Message.Response.Type.EVENT);
            this.event = event;
        }

        public String toString() {
            return "EVENT " + this.event;
        }
    }

    public static abstract class Result
    extends Message.Response {
        public static final Message.Decoder<Result> decoderV1 = new Message.Decoder<Result>(){

            @Override
            public Result decode(ChannelBuffer body) {
                Kind kind = Kind.fromId(body.readInt());
                return (Result)kind.subDecoderV1.decode(body);
            }
        };
        public static final Message.Decoder<Result> decoderV2 = new Message.Decoder<Result>(){

            @Override
            public Result decode(ChannelBuffer body) {
                Kind kind = Kind.fromId(body.readInt());
                return (Result)kind.subDecoderV2.decode(body);
            }
        };
        public final Kind kind;

        protected Result(Kind kind) {
            super(Message.Response.Type.RESULT);
            this.kind = kind;
        }

        public static class SchemaChange
        extends Result {
            public final Change change;
            public final String keyspace;
            public final String columnFamily;
            public static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ChannelBuffer body) {
                    Change change = CBUtil.readEnumValue(Change.class, body);
                    String keyspace = CBUtil.readString(body);
                    String columnFamily = CBUtil.readString(body);
                    return new SchemaChange(change, keyspace, columnFamily);
                }
            };

            private SchemaChange(Change change, String keyspace, String columnFamily) {
                super(Kind.SCHEMA_CHANGE);
                this.change = change;
                this.keyspace = keyspace;
                this.columnFamily = columnFamily;
            }

            public String toString() {
                return "RESULT schema change " + (Object)((Object)this.change) + " on " + this.keyspace + (this.columnFamily.isEmpty() ? "" : '.' + this.columnFamily);
            }

            public static enum Change {
                CREATED,
                UPDATED,
                DROPPED;

            }
        }

        public static class Prepared
        extends Result {
            public static final Message.Decoder<Result> subcodecV1 = new Message.Decoder<Result>(){

                @Override
                public Result decode(ChannelBuffer body) {
                    MD5Digest id = MD5Digest.wrap(CBUtil.readBytes(body));
                    Rows.Metadata metadata = Rows.Metadata.decode(body);
                    return new Prepared(id, metadata, Rows.Metadata.EMPTY);
                }
            };
            public static final Message.Decoder<Result> subcodecV2 = new Message.Decoder<Result>(){

                @Override
                public Result decode(ChannelBuffer body) {
                    MD5Digest id = MD5Digest.wrap(CBUtil.readBytes(body));
                    Rows.Metadata metadata = Rows.Metadata.decode(body);
                    Rows.Metadata resultMetadata = Rows.Metadata.decode(body);
                    return new Prepared(id, metadata, resultMetadata);
                }
            };
            public final MD5Digest statementId;
            public final Rows.Metadata metadata;
            public final Rows.Metadata resultMetadata;

            private Prepared(MD5Digest statementId, Rows.Metadata metadata, Rows.Metadata resultMetadata) {
                super(Kind.PREPARED);
                this.statementId = statementId;
                this.metadata = metadata;
                this.resultMetadata = resultMetadata;
            }

            public String toString() {
                return "RESULT PREPARED " + this.statementId + ' ' + this.metadata + " (resultMetadata=" + this.resultMetadata + ')';
            }
        }

        public static class Rows
        extends Result {
            public static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ChannelBuffer body) {
                    Metadata metadata = Metadata.decode(body);
                    int rowCount = body.readInt();
                    int columnCount = metadata.columnCount;
                    ArrayDeque data = new ArrayDeque(rowCount);
                    for (int i = 0; i < rowCount; ++i) {
                        ArrayList<ByteBuffer> row = new ArrayList<ByteBuffer>(columnCount);
                        for (int j = 0; j < columnCount; ++j) {
                            row.add(CBUtil.readValue(body));
                        }
                        data.add(row);
                    }
                    return new Rows(metadata, data);
                }
            };
            public final Metadata metadata;
            public final Queue<List<ByteBuffer>> data;

            private Rows(Metadata metadata, Queue<List<ByteBuffer>> data) {
                super(Kind.ROWS);
                this.metadata = metadata;
                this.data = data;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("ROWS ").append(this.metadata).append('\n');
                for (List list : this.data) {
                    for (int i = 0; i < list.size(); ++i) {
                        ByteBuffer v = (ByteBuffer)list.get(i);
                        if (v == null) {
                            sb.append(" | null");
                            continue;
                        }
                        sb.append(" | ");
                        if (this.metadata.columns == null) {
                            sb.append(Bytes.toHexString(v));
                            continue;
                        }
                        sb.append(this.metadata.columns.getType(i).deserialize(v));
                    }
                    sb.append('\n');
                }
                sb.append("---");
                return sb.toString();
            }

            public static class Metadata {
                static final Metadata EMPTY = new Metadata(0, null, null);
                public final int columnCount;
                public final ColumnDefinitions columns;
                public final ByteBuffer pagingState;

                private Metadata(int columnCount, ColumnDefinitions columns, ByteBuffer pagingState) {
                    this.columnCount = columnCount;
                    this.columns = columns;
                    this.pagingState = pagingState;
                }

                public static Metadata decode(ChannelBuffer body) {
                    EnumSet<Flag> flags = Flag.deserialize(body.readInt());
                    int columnCount = body.readInt();
                    ByteBuffer state = null;
                    if (flags.contains((Object)Flag.HAS_MORE_PAGES)) {
                        state = CBUtil.readValue(body);
                    }
                    if (flags.contains((Object)Flag.NO_METADATA)) {
                        return new Metadata(columnCount, null, state);
                    }
                    boolean globalTablesSpec = flags.contains((Object)Flag.GLOBAL_TABLES_SPEC);
                    String globalKsName = null;
                    String globalCfName = null;
                    if (globalTablesSpec) {
                        globalKsName = CBUtil.readString(body);
                        globalCfName = CBUtil.readString(body);
                    }
                    ColumnDefinitions.Definition[] defs = new ColumnDefinitions.Definition[columnCount];
                    for (int i = 0; i < columnCount; ++i) {
                        String ksName = globalTablesSpec ? globalKsName : CBUtil.readString(body);
                        String cfName = globalTablesSpec ? globalCfName : CBUtil.readString(body);
                        String name = CBUtil.readString(body);
                        DataType type = DataType.decode(body);
                        defs[i] = new ColumnDefinitions.Definition(ksName, cfName, name, type);
                    }
                    return new Metadata(columnCount, new ColumnDefinitions(defs), state);
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder();
                    if (this.columns == null) {
                        sb.append('[').append(this.columnCount).append(" columns]");
                    } else {
                        for (ColumnDefinitions.Definition column : this.columns) {
                            sb.append('[').append(column.getName());
                            sb.append(" (").append(column.getType()).append(")]");
                        }
                    }
                    if (this.pagingState != null) {
                        sb.append(" (to be continued)");
                    }
                    return sb.toString();
                }

                private static enum Flag {
                    GLOBAL_TABLES_SPEC,
                    HAS_MORE_PAGES,
                    NO_METADATA;


                    public static EnumSet<Flag> deserialize(int flags) {
                        EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                        Flag[] values = Flag.values();
                        for (int n = 0; n < values.length; ++n) {
                            if ((flags & 1 << n) == 0) continue;
                            set.add(values[n]);
                        }
                        return set;
                    }

                    public static int serialize(EnumSet<Flag> flags) {
                        int i = 0;
                        for (Flag flag : flags) {
                            i |= 1 << flag.ordinal();
                        }
                        return i;
                    }
                }
            }
        }

        public static class SetKeyspace
        extends Result {
            public final String keyspace;
            public static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ChannelBuffer body) {
                    return new SetKeyspace(CBUtil.readString(body));
                }
            };

            private SetKeyspace(String keyspace) {
                super(Kind.SET_KEYSPACE);
                this.keyspace = keyspace;
            }

            public String toString() {
                return "RESULT set keyspace " + this.keyspace;
            }
        }

        public static class Void
        extends Result {
            public static final Message.Decoder<Result> subcodec = new Message.Decoder<Result>(){

                @Override
                public Result decode(ChannelBuffer body) {
                    return new Void();
                }
            };

            public Void() {
                super(Kind.VOID);
            }

            public String toString() {
                return "EMPTY RESULT";
            }
        }

        public static enum Kind {
            VOID(1, Void.subcodec, Void.subcodec),
            ROWS(2, Rows.subcodec, Rows.subcodec),
            SET_KEYSPACE(3, SetKeyspace.subcodec, SetKeyspace.subcodec),
            PREPARED(4, Prepared.subcodecV1, Prepared.subcodecV2),
            SCHEMA_CHANGE(5, SchemaChange.subcodec, SchemaChange.subcodec);

            private final int id;
            private final Message.Decoder<Result> subDecoderV1;
            private final Message.Decoder<Result> subDecoderV2;
            private static final Kind[] ids;

            private Kind(int id, Message.Decoder<Result> subDecoderV1, Message.Decoder<Result> subDecoderV2) {
                this.id = id;
                this.subDecoderV1 = subDecoderV1;
                this.subDecoderV2 = subDecoderV2;
            }

            public static Kind fromId(int id) {
                Kind k = ids[id];
                if (k == null) {
                    throw new DriverInternalError(String.format("Unknown kind id %d in RESULT message", id));
                }
                return k;
            }

            static {
                int maxId = -1;
                for (Kind k : Kind.values()) {
                    maxId = Math.max(maxId, k.id);
                }
                ids = new Kind[maxId + 1];
                for (Kind k : Kind.values()) {
                    if (ids[k.id] != null) {
                        throw new IllegalStateException("Duplicate kind id");
                    }
                    Kind.ids[k.id] = k;
                }
            }
        }
    }

    public static class Supported
    extends Message.Response {
        public static final Message.Decoder<Supported> decoder = new Message.Decoder<Supported>(){

            @Override
            public Supported decode(ChannelBuffer body) {
                return new Supported(CBUtil.readStringToStringListMap(body));
            }
        };
        public final Map<String, List<String>> supported;
        public final Set<ProtocolOptions.Compression> supportedCompressions = EnumSet.noneOf(ProtocolOptions.Compression.class);

        public Supported(Map<String, List<String>> supported) {
            super(Message.Response.Type.SUPPORTED);
            this.supported = supported;
            this.parseCompressions();
        }

        private void parseCompressions() {
            List<String> compList = this.supported.get("COMPRESSION");
            if (compList == null) {
                return;
            }
            for (String compStr : compList) {
                ProtocolOptions.Compression compr = ProtocolOptions.Compression.fromString(compStr);
                if (compr == null) continue;
                this.supportedCompressions.add(compr);
            }
        }

        public String toString() {
            return "SUPPORTED " + this.supported;
        }
    }

    public static class Authenticate
    extends Message.Response {
        public static final Message.Decoder<Authenticate> decoder = new Message.Decoder<Authenticate>(){

            @Override
            public Authenticate decode(ChannelBuffer body) {
                String authenticator = CBUtil.readString(body);
                return new Authenticate(authenticator);
            }
        };
        public final String authenticator;

        public Authenticate(String authenticator) {
            super(Message.Response.Type.AUTHENTICATE);
            this.authenticator = authenticator;
        }

        public String toString() {
            return "AUTHENTICATE " + this.authenticator;
        }
    }

    public static class Ready
    extends Message.Response {
        public static final Message.Decoder<Ready> decoder = new Message.Decoder<Ready>(){

            @Override
            public Ready decode(ChannelBuffer body) {
                return new Ready();
            }
        };

        public Ready() {
            super(Message.Response.Type.READY);
        }

        public String toString() {
            return "READY";
        }
    }

    public static class Error
    extends Message.Response {
        public static final Message.Decoder<Error> decoder = new Message.Decoder<Error>(){

            @Override
            public Error decode(ChannelBuffer body) {
                ExceptionCode code = ExceptionCode.fromValue(body.readInt());
                String msg = CBUtil.readString(body);
                Object infos = null;
                switch (code) {
                    case UNAVAILABLE: {
                        ConsistencyLevel clu = CBUtil.readConsistencyLevel(body);
                        int required = body.readInt();
                        int alive = body.readInt();
                        infos = new UnavailableException(clu, required, alive);
                        break;
                    }
                    case WRITE_TIMEOUT: 
                    case READ_TIMEOUT: {
                        ConsistencyLevel clt = CBUtil.readConsistencyLevel(body);
                        int received = body.readInt();
                        int blockFor = body.readInt();
                        if (code == ExceptionCode.WRITE_TIMEOUT) {
                            WriteType writeType = Enum.valueOf(WriteType.class, CBUtil.readString(body));
                            infos = new WriteTimeoutException(clt, writeType, received, blockFor);
                            break;
                        }
                        byte dataPresent = body.readByte();
                        infos = new ReadTimeoutException(clt, received, blockFor, dataPresent != 0);
                        break;
                    }
                    case UNPREPARED: {
                        infos = MD5Digest.wrap(CBUtil.readBytes(body));
                        break;
                    }
                    case ALREADY_EXISTS: {
                        String ksName = CBUtil.readString(body);
                        String cfName = CBUtil.readString(body);
                        infos = new AlreadyExistsException(ksName, cfName);
                    }
                }
                return new Error(code, msg, infos);
            }
        };
        public final ExceptionCode code;
        public final String message;
        public final Object infos;

        private Error(ExceptionCode code, String message, Object infos) {
            super(Message.Response.Type.ERROR);
            this.code = code;
            this.message = message;
            this.infos = infos;
        }

        public DriverException asException(InetAddress host) {
            switch (this.code) {
                case SERVER_ERROR: {
                    return new DriverInternalError(String.format("An unexpected error occurred server side on %s: %s", host, this.message));
                }
                case PROTOCOL_ERROR: {
                    return new DriverInternalError("An unexpected protocol error occurred. This is a bug in this library, please report: " + this.message);
                }
                case BAD_CREDENTIALS: {
                    return new AuthenticationException(host, this.message);
                }
                case UNAVAILABLE: {
                    return ((UnavailableException)this.infos).copy();
                }
                case OVERLOADED: {
                    return new DriverInternalError(String.format("Queried host (%s) was overloaded; this shouldn't happen, another node should have been tried", host));
                }
                case IS_BOOTSTRAPPING: {
                    return new DriverInternalError(String.format("Queried host (%s) was bootstrapping; this shouldn't happen, another node should have been tried", host));
                }
                case TRUNCATE_ERROR: {
                    return new TruncateException(this.message);
                }
                case WRITE_TIMEOUT: {
                    return ((WriteTimeoutException)this.infos).copy();
                }
                case READ_TIMEOUT: {
                    return ((ReadTimeoutException)this.infos).copy();
                }
                case SYNTAX_ERROR: {
                    return new SyntaxError(this.message);
                }
                case UNAUTHORIZED: {
                    return new UnauthorizedException(this.message);
                }
                case INVALID: {
                    return new InvalidQueryException(this.message);
                }
                case CONFIG_ERROR: {
                    return new InvalidConfigurationInQueryException(this.message);
                }
                case ALREADY_EXISTS: {
                    return ((AlreadyExistsException)this.infos).copy();
                }
                case UNPREPARED: {
                    return new DriverInternalError(String.format("A prepared query was submitted on %s but was not known of that node; this shouldn't happen, the query should have been re-prepared", host));
                }
            }
            return new DriverInternalError(String.format("Unknown protocol error code %s returned by %s. The error message was: %s", new Object[]{this.code, host, this.message}));
        }

        public String toString() {
            return "ERROR " + (Object)((Object)this.code) + ": " + this.message;
        }
    }
}

