/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ArrayBackedResultSet;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultResultSetFuture
extends AbstractFuture<ResultSet>
implements ResultSetFuture,
RequestHandler.Callback {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetFuture.class);
    private final SessionManager session;
    private final Message.Request request;
    private volatile RequestHandler handler;

    DefaultResultSetFuture(SessionManager session, Message.Request request) {
        this.session = session;
        this.request = request;
    }

    @Override
    public void register(RequestHandler handler) {
        this.handler = handler;
    }

    @Override
    public Message.Request request() {
        return this.request;
    }

    @Override
    public void onSet(Connection connection, Message.Response response, ExecutionInfo info, Statement statement, long latency) {
        try {
            block1 : switch (response.type) {
                case RESULT: {
                    Responses.Result rm = (Responses.Result)response;
                    switch (rm.kind) {
                        case SET_KEYSPACE: {
                            this.session.poolsState.setKeyspace(((Responses.Result.SetKeyspace)rm).keyspace);
                            this.set(ArrayBackedResultSet.fromMessage(rm, this.session, info, statement));
                            break block1;
                        }
                        case SCHEMA_CHANGE: {
                            Responses.Result.SchemaChange scc = (Responses.Result.SchemaChange)rm;
                            ArrayBackedResultSet rs = ArrayBackedResultSet.fromMessage(rm, this.session, info, statement);
                            switch (scc.change) {
                                case CREATED: {
                                    if (scc.columnFamily.isEmpty()) {
                                        this.session.cluster.manager.refreshSchema(connection, this, rs, null, null);
                                        break block1;
                                    }
                                    this.session.cluster.manager.refreshSchema(connection, this, rs, scc.keyspace, null);
                                    break block1;
                                }
                                case DROPPED: {
                                    if (scc.columnFamily.isEmpty()) {
                                        this.session.cluster.manager.refreshSchema(connection, this, rs, null, null);
                                        break block1;
                                    }
                                    this.session.cluster.manager.refreshSchema(connection, this, rs, scc.keyspace, null);
                                    break block1;
                                }
                                case UPDATED: {
                                    if (scc.columnFamily.isEmpty()) {
                                        this.session.cluster.manager.refreshSchema(connection, this, rs, scc.keyspace, null);
                                        break block1;
                                    }
                                    this.session.cluster.manager.refreshSchema(connection, this, rs, scc.keyspace, scc.columnFamily);
                                    break block1;
                                }
                            }
                            logger.info("Ignoring unknown schema change result");
                            break block1;
                        }
                    }
                    this.set(ArrayBackedResultSet.fromMessage(rm, this.session, info, statement));
                    break;
                }
                case ERROR: {
                    this.setException(((Responses.Error)response).asException(connection.address));
                    break;
                }
                default: {
                    connection.defunct(new ConnectionException(connection.address, String.format("Got unexpected %s response", new Object[]{response.type})));
                    this.setException(new DriverInternalError(String.format("Got unexpected %s response from %s", new Object[]{response.type, connection.address})));
                }
            }
        }
        catch (RuntimeException e) {
            this.setException(new DriverInternalError("Unexpected error while processing response from " + connection.address, e));
        }
    }

    @Override
    public void onSet(Connection connection, Message.Response response, long latency) {
        this.onSet(connection, response, null, null, latency);
    }

    @Override
    public void onException(Connection connection, Exception exception, long latency) {
        this.setException(exception);
    }

    @Override
    public void onTimeout(Connection connection, long latency) {
        this.setException(new ConnectionException(connection.address, "Operation Timeouted"));
    }

    void setResult(ResultSet rs) {
        this.set(rs);
    }

    @Override
    public ResultSet getUninterruptibly() {
        try {
            return (ResultSet)Uninterruptibles.getUninterruptibly((Future)((Object)this));
        }
        catch (ExecutionException e) {
            throw DefaultResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    @Override
    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return (ResultSet)Uninterruptibles.getUninterruptibly((Future)((Object)this), (long)timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            throw DefaultResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!super.cancel(mayInterruptIfRunning)) {
            return false;
        }
        this.handler.cancel();
        return true;
    }

    static RuntimeException extractCauseFromExecutionException(ExecutionException e) {
        if (e.getCause() instanceof DriverException) {
            throw ((DriverException)e.getCause()).copy();
        }
        throw new DriverInternalError("Unexpected exception thrown", e.getCause());
    }
}

