/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostDistance;

public class PoolingOptions {
    private static final int DEFAULT_MIN_REQUESTS = 25;
    private static final int DEFAULT_MAX_REQUESTS = 100;
    private static final int DEFAULT_CORE_POOL_LOCAL = 2;
    private static final int DEFAULT_CORE_POOL_REMOTE = 1;
    private static final int DEFAULT_MAX_POOL_LOCAL = 8;
    private static final int DEFAULT_MAX_POOL_REMOTE = 2;
    private volatile Cluster.Manager manager;
    private volatile int minSimultaneousRequestsForLocal = 25;
    private volatile int minSimultaneousRequestsForRemote = 25;
    private volatile int maxSimultaneousRequestsForLocal = 100;
    private volatile int maxSimultaneousRequestsForRemote = 100;
    private volatile int coreConnectionsForLocal = 2;
    private volatile int coreConnectionsForRemote = 1;
    private volatile int maxConnectionsForLocal = 8;
    private volatile int maxConnectionsForRemote = 2;

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    public int getMinSimultaneousRequestsPerConnectionThreshold(HostDistance distance) {
        switch (distance) {
            case LOCAL: {
                return this.minSimultaneousRequestsForLocal;
            }
            case REMOTE: {
                return this.minSimultaneousRequestsForRemote;
            }
        }
        return 0;
    }

    public PoolingOptions setMinSimultaneousRequestsPerConnectionThreshold(HostDistance distance, int minSimultaneousRequests) {
        switch (distance) {
            case LOCAL: {
                this.minSimultaneousRequestsForLocal = minSimultaneousRequests;
                break;
            }
            case REMOTE: {
                this.minSimultaneousRequestsForRemote = minSimultaneousRequests;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot set min streams per connection threshold for " + (Object)((Object)distance) + " hosts");
            }
        }
        return this;
    }

    public int getMaxSimultaneousRequestsPerConnectionThreshold(HostDistance distance) {
        switch (distance) {
            case LOCAL: {
                return this.maxSimultaneousRequestsForLocal;
            }
            case REMOTE: {
                return this.maxSimultaneousRequestsForRemote;
            }
        }
        return 0;
    }

    public PoolingOptions setMaxSimultaneousRequestsPerConnectionThreshold(HostDistance distance, int maxSimultaneousRequests) {
        switch (distance) {
            case LOCAL: {
                this.maxSimultaneousRequestsForLocal = maxSimultaneousRequests;
                break;
            }
            case REMOTE: {
                this.maxSimultaneousRequestsForRemote = maxSimultaneousRequests;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot set max streams per connection threshold for " + (Object)((Object)distance) + " hosts");
            }
        }
        return this;
    }

    public int getCoreConnectionsPerHost(HostDistance distance) {
        switch (distance) {
            case LOCAL: {
                return this.coreConnectionsForLocal;
            }
            case REMOTE: {
                return this.coreConnectionsForRemote;
            }
        }
        return 0;
    }

    public PoolingOptions setCoreConnectionsPerHost(HostDistance distance, int coreConnections) {
        switch (distance) {
            case LOCAL: {
                int oldLocalCore = this.coreConnectionsForLocal;
                this.coreConnectionsForLocal = coreConnections;
                if (oldLocalCore >= this.coreConnectionsForLocal || this.manager == null) break;
                this.manager.ensurePoolsSizing();
                break;
            }
            case REMOTE: {
                int oldRemoteCore = this.coreConnectionsForRemote;
                this.coreConnectionsForRemote = coreConnections;
                if (oldRemoteCore >= this.coreConnectionsForRemote || this.manager == null) break;
                this.manager.ensurePoolsSizing();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot set core connections per host for " + (Object)((Object)distance) + " hosts");
            }
        }
        return this;
    }

    public int getMaxConnectionsPerHost(HostDistance distance) {
        switch (distance) {
            case LOCAL: {
                return this.maxConnectionsForLocal;
            }
            case REMOTE: {
                return this.maxConnectionsForRemote;
            }
        }
        return 0;
    }

    public PoolingOptions setMaxConnectionsPerHost(HostDistance distance, int maxConnections) {
        switch (distance) {
            case LOCAL: {
                this.maxConnectionsForLocal = maxConnections;
                break;
            }
            case REMOTE: {
                this.maxConnectionsForRemote = maxConnections;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot set max connections per host for " + (Object)((Object)distance) + " hosts");
            }
        }
        return this;
    }
}

