/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.exceptions.DriverInternalError;

public enum ConsistencyLevel {
    ANY(0),
    ONE(1),
    TWO(2),
    THREE(3),
    QUORUM(4),
    ALL(5),
    LOCAL_QUORUM(6),
    EACH_QUORUM(7),
    SERIAL(8),
    LOCAL_SERIAL(9);

    final int code;
    private static final ConsistencyLevel[] codeIdx;

    private ConsistencyLevel(int code) {
        this.code = code;
    }

    static ConsistencyLevel fromCode(int code) {
        if (code < 0 || code >= codeIdx.length) {
            throw new DriverInternalError(String.format("Unknown code %d for a consistency level", code));
        }
        return codeIdx[code];
    }

    static {
        int maxCode = -1;
        for (ConsistencyLevel cl : ConsistencyLevel.values()) {
            maxCode = Math.max(maxCode, cl.code);
        }
        codeIdx = new ConsistencyLevel[maxCode + 1];
        for (ConsistencyLevel cl : ConsistencyLevel.values()) {
            if (codeIdx[cl.code] != null) {
                throw new IllegalStateException("Duplicate code");
            }
            ConsistencyLevel.codeIdx[cl.code] = cl;
        }
    }
}

