/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Utils;
import java.nio.ByteBuffer;
import java.util.List;

abstract class BuiltStatement
extends RegularStatement {
    private final List<ColumnMetadata> partitionKey;
    private final ByteBuffer[] routingKey;
    protected final String keyspace;
    private boolean dirty;
    private String cache;
    protected Boolean isCounterOp;

    protected BuiltStatement(String keyspace) {
        this.partitionKey = null;
        this.routingKey = null;
        this.keyspace = keyspace;
    }

    protected BuiltStatement(TableMetadata tableMetadata) {
        this.partitionKey = tableMetadata.getPartitionKey();
        this.routingKey = new ByteBuffer[tableMetadata.getPartitionKey().size()];
        this.keyspace = tableMetadata.getKeyspace().getName();
    }

    @Override
    public String getQueryString() {
        if (this.dirty || this.cache == null) {
            int l;
            StringBuilder sb = this.buildQueryString();
            for (l = sb.length(); l > 0 && sb.charAt(l - 1) <= ' '; --l) {
            }
            if (l != sb.length()) {
                sb.setLength(l);
            }
            if (l == 0 || sb.charAt(l - 1) != ';') {
                sb.append(';');
            }
            this.cache = sb.toString();
            this.dirty = false;
        }
        return this.cache;
    }

    protected abstract StringBuilder buildQueryString();

    protected void setDirty() {
        this.dirty = true;
    }

    protected boolean isCounterOp() {
        return this.isCounterOp == null ? false : this.isCounterOp;
    }

    protected void setCounterOp(boolean isCounterOp) {
        this.isCounterOp = isCounterOp;
    }

    void maybeAddRoutingKey(String name, Object value) {
        if (this.routingKey == null || name == null || value == QueryBuilder.BIND_MARKER) {
            return;
        }
        for (int i = 0; i < this.partitionKey.size(); ++i) {
            if (!name.equals(this.partitionKey.get(i).getName()) || !Utils.isRawValue(value)) continue;
            this.routingKey[i] = this.partitionKey.get(i).getType().parse(Utils.toRawString(value));
            return;
        }
    }

    @Override
    public ByteBuffer getRoutingKey() {
        if (this.routingKey == null) {
            return null;
        }
        for (ByteBuffer bb : this.routingKey) {
            if (bb != null) continue;
            return null;
        }
        return this.routingKey.length == 1 ? this.routingKey[0] : BuiltStatement.compose(this.routingKey);
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    @Override
    public ByteBuffer[] getValues() {
        return null;
    }

    static ByteBuffer compose(ByteBuffer ... buffers) {
        int totalLength = 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer buffer : buffers) {
            ByteBuffer bb = buffer.duplicate();
            BuiltStatement.putShortLength(out, bb.remaining());
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    private static void putShortLength(ByteBuffer bb, int length) {
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }

    static abstract class ForwardingStatement<T extends BuiltStatement>
    extends BuiltStatement {
        protected T statement;

        protected ForwardingStatement(T statement) {
            super((String)null);
            this.statement = statement;
        }

        @Override
        public String getQueryString() {
            return ((BuiltStatement)this.statement).getQueryString();
        }

        @Override
        protected StringBuilder buildQueryString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer getRoutingKey() {
            return ((BuiltStatement)this.statement).getRoutingKey();
        }

        @Override
        public String getKeyspace() {
            return ((BuiltStatement)this.statement).getKeyspace();
        }

        @Override
        protected void setDirty() {
            ((BuiltStatement)this.statement).setDirty();
        }

        @Override
        protected boolean isCounterOp() {
            return ((BuiltStatement)this.statement).isCounterOp();
        }

        @Override
        public Statement setConsistencyLevel(ConsistencyLevel consistency) {
            ((Statement)this.statement).setConsistencyLevel(consistency);
            return this;
        }

        @Override
        public ConsistencyLevel getConsistencyLevel() {
            return ((Statement)this.statement).getConsistencyLevel();
        }

        @Override
        public Statement enableTracing() {
            ((Statement)this.statement).enableTracing();
            return this;
        }

        @Override
        public Statement disableTracing() {
            ((Statement)this.statement).disableTracing();
            return this;
        }

        @Override
        public boolean isTracing() {
            return ((Statement)this.statement).isTracing();
        }

        @Override
        public Statement setRetryPolicy(RetryPolicy policy) {
            ((Statement)this.statement).setRetryPolicy(policy);
            return this;
        }

        @Override
        public RetryPolicy getRetryPolicy() {
            return ((Statement)this.statement).getRetryPolicy();
        }
    }
}

