/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.codahale.metrics.Timer;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.RetryPolicy;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestHandler
implements Connection.ResponseCallback {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private final Session.Manager manager;
    private final Callback callback;
    private final Iterator<Host> queryPlan;
    private final Statement statement;
    private volatile Host current;
    private volatile List<Host> triedHosts;
    private volatile HostConnectionPool currentPool;
    private volatile int queryRetries;
    private volatile ConsistencyLevel retryConsistencyLevel;
    private volatile Map<InetAddress, Throwable> errors;
    private volatile boolean isCanceled;
    private volatile Connection.ResponseHandler connectionHandler;
    private final Timer.Context timerContext;

    public RequestHandler(Session.Manager manager, Callback callback, Statement statement) {
        this.manager = manager;
        this.callback = callback;
        callback.register(this);
        this.queryPlan = manager.loadBalancingPolicy().newQueryPlan(manager.poolsState.keyspace, statement);
        this.statement = statement;
        this.timerContext = this.metricsEnabled() ? this.metrics().getRequestsTimer().time() : null;
    }

    private boolean metricsEnabled() {
        return this.manager.configuration().getMetricsOptions() != null;
    }

    private Metrics metrics() {
        return this.manager.cluster.manager.metrics;
    }

    public void sendRequest() {
        while (this.queryPlan.hasNext() && !this.isCanceled) {
            Host host = this.queryPlan.next();
            if (!this.query(host)) continue;
            return;
        }
        this.setFinalException(null, new NoHostAvailableException(this.errors == null ? Collections.emptyMap() : this.errors));
    }

    private boolean query(Host host) {
        this.currentPool = (HostConnectionPool)this.manager.pools.get(host);
        if (this.currentPool == null || this.currentPool.isShutdown()) {
            return false;
        }
        Connection connection = null;
        try {
            connection = this.currentPool.borrowConnection(this.manager.configuration().getSocketOptions().getConnectTimeoutMillis(), TimeUnit.MILLISECONDS);
            if (this.current != null) {
                if (this.triedHosts == null) {
                    this.triedHosts = new ArrayList<Host>();
                }
                this.triedHosts.add(this.current);
            }
            this.current = host;
            this.connectionHandler = connection.write(this);
            return true;
        }
        catch (ConnectionException e) {
            if (this.metricsEnabled()) {
                this.metrics().getErrorMetrics().getConnectionErrors().inc();
            }
            if (connection != null) {
                this.currentPool.returnConnection(connection);
            }
            this.logError(host.getAddress(), e);
            return false;
        }
        catch (BusyConnectionException e) {
            if (connection != null) {
                this.currentPool.returnConnection(connection);
            }
            this.logError(host.getAddress(), e);
            return false;
        }
        catch (TimeoutException e) {
            this.logError(host.getAddress(), new DriverException("Timeout while trying to acquire available connection (you may want to increase the driver number of per-host connections)"));
            return false;
        }
        catch (RuntimeException e) {
            if (connection != null) {
                this.currentPool.returnConnection(connection);
            }
            logger.error("Unexpected error while querying " + host.getAddress(), (Throwable)e);
            this.logError(host.getAddress(), e);
            return false;
        }
    }

    private void logError(InetAddress address, Throwable exception) {
        logger.debug("Error querying {}, trying next host (error is: {})", (Object)address, (Object)exception.toString());
        if (this.errors == null) {
            this.errors = new HashMap<InetAddress, Throwable>();
        }
        this.errors.put(address, exception);
    }

    private void retry(final boolean retryCurrent, ConsistencyLevel newConsistencyLevel) {
        final Host h = this.current;
        this.retryConsistencyLevel = newConsistencyLevel;
        this.manager.executor().execute(new Runnable(){

            @Override
            public void run() {
                if (retryCurrent && RequestHandler.this.query(h)) {
                    return;
                }
                RequestHandler.this.sendRequest();
            }
        });
    }

    public void cancel() {
        this.isCanceled = true;
        if (this.connectionHandler != null) {
            this.connectionHandler.cancelHandler();
        }
    }

    @Override
    public Message.Request request() {
        Message.Request request = this.callback.request();
        if (this.retryConsistencyLevel != null && this.retryConsistencyLevel != this.consistencyOf(request)) {
            request = this.manager.makeRequestMessage(this.statement, this.retryConsistencyLevel, this.serialConsistencyOf(request), this.pagingStateOf(request));
        }
        return request;
    }

    private ConsistencyLevel consistencyOf(Message.Request request) {
        switch (request.type) {
            case QUERY: {
                return ((Requests.Query)request).options.consistency;
            }
            case EXECUTE: {
                return ((Requests.Execute)request).options.consistency;
            }
            case BATCH: {
                return ((Requests.Batch)request).consistency;
            }
        }
        return null;
    }

    private ConsistencyLevel serialConsistencyOf(Message.Request request) {
        switch (request.type) {
            case QUERY: {
                return ((Requests.Query)request).options.serialConsistency;
            }
            case EXECUTE: {
                return ((Requests.Execute)request).options.serialConsistency;
            }
        }
        return null;
    }

    private ByteBuffer pagingStateOf(Message.Request request) {
        switch (request.type) {
            case QUERY: {
                return ((Requests.Query)request).options.pagingState;
            }
            case EXECUTE: {
                return ((Requests.Execute)request).options.pagingState;
            }
        }
        return null;
    }

    private void setFinalResult(Connection connection, Message.Response response) {
        if (this.timerContext != null) {
            this.timerContext.stop();
        }
        ExecutionInfo info = this.current.defaultExecutionInfo;
        if (this.triedHosts != null) {
            this.triedHosts.add(this.current);
            info = new ExecutionInfo(this.triedHosts);
        }
        if (this.retryConsistencyLevel != null) {
            info = info.withAchievedConsistency(this.retryConsistencyLevel);
        }
        this.callback.onSet(connection, response, info, this.statement);
    }

    private void setFinalException(Connection connection, Exception exception) {
        if (this.timerContext != null) {
            this.timerContext.stop();
        }
        this.callback.onException(connection, exception);
    }

    private void returnConnection(Connection connection) {
        if (this.currentPool == null) {
            logger.error("No current pool set; this should not happen");
        } else {
            this.currentPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSet(Connection connection, Message.Response response) {
        this.returnConnection(connection);
        try {
            block2 : switch (response.type) {
                case RESULT: {
                    this.setFinalResult(connection, response);
                    break;
                }
                case ERROR: {
                    Responses.Error err = (Responses.Error)response;
                    RetryPolicy.RetryDecision retry = null;
                    RetryPolicy retryPolicy = this.statement.getRetryPolicy() == null ? this.manager.configuration().getPolicies().getRetryPolicy() : this.statement.getRetryPolicy();
                    switch (err.code) {
                        case READ_TIMEOUT: {
                            assert (err.infos instanceof ReadTimeoutException);
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getReadTimeouts().inc();
                            }
                            ReadTimeoutException rte = (ReadTimeoutException)err.infos;
                            retry = retryPolicy.onReadTimeout(this.statement, rte.getConsistencyLevel(), rte.getRequiredAcknowledgements(), rte.getReceivedAcknowledgements(), rte.wasDataRetrieved(), this.queryRetries);
                            break;
                        }
                        case WRITE_TIMEOUT: {
                            assert (err.infos instanceof WriteTimeoutException);
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getWriteTimeouts().inc();
                            }
                            WriteTimeoutException wte = (WriteTimeoutException)err.infos;
                            retry = retryPolicy.onWriteTimeout(this.statement, wte.getConsistencyLevel(), wte.getWriteType(), wte.getRequiredAcknowledgements(), wte.getReceivedAcknowledgements(), this.queryRetries);
                            break;
                        }
                        case UNAVAILABLE: {
                            assert (err.infos instanceof UnavailableException);
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getUnavailables().inc();
                            }
                            UnavailableException ue = (UnavailableException)err.infos;
                            retry = retryPolicy.onUnavailable(this.statement, ue.getConsistencyLevel(), ue.getRequiredReplicas(), ue.getAliveReplicas(), this.queryRetries);
                            break;
                        }
                        case OVERLOADED: {
                            logger.warn("Host {} is overloaded, trying next host.", (Object)connection.address);
                            this.logError(connection.address, new DriverException("Host overloaded"));
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getOthers().inc();
                            }
                            this.retry(false, null);
                            return;
                        }
                        case IS_BOOTSTRAPPING: {
                            logger.error("Query sent to {} but it is bootstrapping. This shouldn't happen but trying next host.", (Object)connection.address);
                            this.logError(connection.address, new DriverException("Host is boostrapping"));
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getOthers().inc();
                            }
                            this.retry(false, null);
                            return;
                        }
                        case UNPREPARED: {
                            assert (err.infos instanceof MD5Digest);
                            MD5Digest id = (MD5Digest)err.infos;
                            PreparedStatement toPrepare = this.manager.cluster.manager.preparedQueries.get(id);
                            if (toPrepare == null) {
                                String msg = String.format("Tried to execute unknown prepared query %s", id);
                                logger.error(msg);
                                this.setFinalException(connection, new DriverInternalError(msg));
                                return;
                            }
                            logger.trace("Preparing required prepared query {} in keyspace {}", (Object)toPrepare.getQueryString(), (Object)toPrepare.getQueryKeyspace());
                            String currentKeyspace = connection.keyspace();
                            String prepareKeyspace = toPrepare.getQueryKeyspace();
                            if (!(prepareKeyspace == null || currentKeyspace != null && currentKeyspace.equals(prepareKeyspace))) {
                                logger.trace("Setting keyspace for prepared query to {}", (Object)prepareKeyspace);
                                connection.setKeyspace(prepareKeyspace);
                            }
                            try {
                                connection.write(this.prepareAndRetry(toPrepare.getQueryString()));
                            }
                            finally {
                                if (connection.keyspace() == null || !connection.keyspace().equals(currentKeyspace)) {
                                    logger.trace("Setting back keyspace post query preparation to {}", (Object)currentKeyspace);
                                    connection.setKeyspace(currentKeyspace);
                                }
                            }
                            return;
                        }
                        default: {
                            if (!this.metricsEnabled()) break;
                            this.metrics().getErrorMetrics().getOthers().inc();
                        }
                    }
                    if (retry == null) {
                        this.setFinalResult(connection, response);
                        break;
                    }
                    switch (retry.getType()) {
                        case RETRY: {
                            ++this.queryRetries;
                            if (logger.isTraceEnabled()) {
                                logger.trace("Doing retry {} for query {} at consistency {}", new Object[]{this.queryRetries, this.statement, retry.getRetryConsistencyLevel()});
                            }
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getRetries().inc();
                            }
                            this.retry(true, retry.getRetryConsistencyLevel());
                            break block2;
                        }
                        case RETHROW: {
                            this.setFinalResult(connection, response);
                            break block2;
                        }
                        case IGNORE: {
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getIgnores().inc();
                            }
                            this.setFinalResult(connection, new Responses.Result.Void());
                        }
                    }
                    break;
                }
                default: {
                    this.setFinalResult(connection, response);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.setFinalException(connection, e);
        }
    }

    private Connection.ResponseCallback prepareAndRetry(final String toPrepare) {
        return new Connection.ResponseCallback(){

            @Override
            public Message.Request request() {
                return new Requests.Prepare(toPrepare);
            }

            @Override
            public void onSet(Connection connection, Message.Response response) {
                switch (response.type) {
                    case RESULT: {
                        if (((Responses.Result)response).kind == Responses.Result.Kind.PREPARED) {
                            logger.trace("Scheduling retry now that query is prepared");
                            RequestHandler.this.retry(true, null);
                            break;
                        }
                        RequestHandler.this.logError(connection.address, new DriverException("Got unexpected response to prepare message: " + response));
                        RequestHandler.this.retry(false, null);
                        break;
                    }
                    case ERROR: {
                        RequestHandler.this.logError(connection.address, new DriverException("Error preparing query, got " + response));
                        if (RequestHandler.this.metricsEnabled()) {
                            RequestHandler.this.metrics().getErrorMetrics().getOthers().inc();
                        }
                        RequestHandler.this.retry(false, null);
                        break;
                    }
                    default: {
                        RequestHandler.this.setFinalResult(connection, response);
                    }
                }
            }

            @Override
            public void onException(Connection connection, Exception exception) {
                RequestHandler.this.onException(connection, exception);
            }

            @Override
            public void onTimeout(Connection connection) {
                RequestHandler.this.logError(connection.address, new DriverException("Timeout waiting for response to prepare message"));
                RequestHandler.this.retry(false, null);
            }
        };
    }

    @Override
    public void onException(Connection connection, Exception exception) {
        this.returnConnection(connection);
        if (exception instanceof ConnectionException) {
            if (this.metricsEnabled()) {
                this.metrics().getErrorMetrics().getConnectionErrors().inc();
            }
            ConnectionException ce = (ConnectionException)exception;
            this.logError(ce.address, ce);
            this.retry(false, null);
            return;
        }
        this.setFinalException(connection, exception);
    }

    @Override
    public void onTimeout(Connection connection) {
        this.returnConnection(connection);
        this.logError(connection.address, new DriverException("Timeout during read"));
        this.retry(false, null);
    }

    static interface Callback
    extends Connection.ResponseCallback {
        public void onSet(Connection var1, Message.Response var2, ExecutionInfo var3, Statement var4);

        public void register(RequestHandler var1);
    }
}

