/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.FrameCompressor;
import com.datastax.driver.core.SSLOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolOptions {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolOptions.class);
    public static final int DEFAULT_PORT = 9042;
    private final int port;
    private final SSLOptions sslOptions;
    private final AuthProvider authProvider;
    private volatile Compression compression = Compression.NONE;

    public ProtocolOptions() {
        this(9042);
    }

    public ProtocolOptions(int port) {
        this(port, null, AuthProvider.NONE);
    }

    public ProtocolOptions(int port, SSLOptions sslOptions, AuthProvider authProvider) {
        this.port = port;
        this.sslOptions = sslOptions;
        this.authProvider = authProvider;
    }

    void register(Cluster.Manager manager) {
    }

    public int getPort() {
        return this.port;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public ProtocolOptions setCompression(Compression compression) {
        if (compression != Compression.NONE && compression.compressor == null) {
            throw new IllegalStateException("The requested compression is not available (some compression require a JAR to be found in the classpath)");
        }
        this.compression = compression;
        return this;
    }

    public SSLOptions getSSLOptions() {
        return this.sslOptions;
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public static enum Compression {
        NONE("", null),
        SNAPPY("snappy", FrameCompressor.SnappyCompressor.instance),
        LZ4("lz4", FrameCompressor.LZ4Compressor.instance);

        final String protocolName;
        final FrameCompressor compressor;

        private Compression(String protocolName, FrameCompressor compressor) {
            this.protocolName = protocolName;
            this.compressor = compressor;
        }

        FrameCompressor compressor() {
            return this.compressor;
        }

        public String toString() {
            return this.protocolName;
        }
    }
}

