/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ColumnDefinitions
implements Iterable<Definition> {
    static final ColumnDefinitions EMPTY = new ColumnDefinitions(new Definition[0]);
    private final Definition[] byIdx;
    private final Map<String, int[]> byName;

    ColumnDefinitions(Definition[] defs) {
        this.byIdx = defs;
        this.byName = new HashMap<String, int[]>(defs.length);
        for (int i = 0; i < defs.length; ++i) {
            int[] previous = this.byName.put(defs[i].name.toLowerCase(), new int[]{i});
            if (previous == null) continue;
            int[] indexes = new int[previous.length + 1];
            System.arraycopy(previous, 0, indexes, 0, previous.length);
            indexes[indexes.length - 1] = i;
            this.byName.put(defs[i].name.toLowerCase(), indexes);
        }
    }

    public int size() {
        return this.byIdx.length;
    }

    public boolean contains(String name) {
        return this.findIdx(name) >= 0;
    }

    public int getIndexOf(String name) {
        return this.findIdx(name);
    }

    @Override
    public Iterator<Definition> iterator() {
        return Arrays.asList(this.byIdx).iterator();
    }

    public List<Definition> asList() {
        return Arrays.asList(this.byIdx);
    }

    public String getName(int i) {
        return this.byIdx[i].name;
    }

    public DataType getType(int i) {
        return this.byIdx[i].type;
    }

    public DataType getType(String name) {
        return this.getType(this.getIdx(name));
    }

    public String getKeyspace(int i) {
        return this.byIdx[i].keyspace;
    }

    public String getKeyspace(String name) {
        return this.getKeyspace(this.getIdx(name));
    }

    public String getTable(int i) {
        return this.byIdx[i].table;
    }

    public String getTable(String name) {
        return this.getTable(this.getIdx(name));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Columns[");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            Definition def = this.byIdx[i];
            sb.append(def.name).append("(").append(def.type).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    int findIdx(String name) {
        int[] indexes;
        boolean caseSensitive = false;
        if (name.length() >= 2 && name.charAt(0) == '\"' && name.charAt(name.length() - 1) == '\"') {
            name = name.substring(1, name.length() - 1);
            caseSensitive = true;
        }
        if ((indexes = this.byName.get(name.toLowerCase())) == null) {
            return -1;
        }
        if (indexes.length == 1) {
            return indexes[0];
        }
        for (int i = 0; i < indexes.length; ++i) {
            int idx = indexes[i];
            if (!(caseSensitive ? name.equals(this.byIdx[idx].name) : name.toLowerCase().equals(this.byIdx[idx].name))) continue;
            return idx;
        }
        if (caseSensitive) {
            return -1;
        }
        return indexes[0];
    }

    int getIdx(String name) {
        int idx = this.findIdx(name);
        if (idx < 0) {
            throw new IllegalArgumentException(name + " is not a column defined in this metadata");
        }
        return idx;
    }

    void checkBounds(int i) {
        if (i < 0 || i >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
    }

    void checkType(int i, DataType.Name name) {
        DataType defined = this.getType(i);
        if (name != defined.getName()) {
            throw new InvalidTypeException(String.format("Column %s is of type %s", this.getName(i), defined));
        }
    }

    DataType.Name checkType(int i, DataType.Name name1, DataType.Name name2) {
        DataType defined = this.getType(i);
        if (name1 != defined.getName() && name2 != defined.getName()) {
            throw new InvalidTypeException(String.format("Column %s is of type %s", this.getName(i), defined));
        }
        return defined.getName();
    }

    DataType.Name checkType(int i, DataType.Name name1, DataType.Name name2, DataType.Name name3) {
        DataType defined = this.getType(i);
        if (name1 != defined.getName() && name2 != defined.getName() && name3 != defined.getName()) {
            throw new InvalidTypeException(String.format("Column %s is of type %s", this.getName(i), defined));
        }
        return defined.getName();
    }

    public static class Definition {
        private final String keyspace;
        private final String table;
        private final String name;
        private final DataType type;

        Definition(String keyspace, String table, String name, DataType type) {
            this.keyspace = keyspace;
            this.table = table;
            this.name = name;
            this.type = type;
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public String getTable() {
            return this.table;
        }

        public String getName() {
            return this.name;
        }

        public DataType getType() {
            return this.type;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.keyspace, this.table, this.name, this.type});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Definition)) {
                return false;
            }
            Definition other = (Definition)o;
            return this.keyspace.equals(other.keyspace) && this.table.equals(other.table) && this.name.equals(other.name) && this.type.equals(other.type);
        }
    }
}

