/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.querybuilder.Utils;
import java.util.List;

public abstract class Clause
extends Utils.Appendeable {
    protected final String name;

    private Clause(String name) {
        this.name = name;
    }

    String name() {
        return this.name;
    }

    abstract Object firstValue();

    static class InClause
    extends Clause {
        private final List<Object> values;

        InClause(String name, List<Object> values) {
            super(name);
            this.values = values;
            if (values == null) {
                throw new IllegalArgumentException("Missing values for IN clause");
            }
        }

        @Override
        void appendTo(StringBuilder sb) {
            Utils.appendName(this.name, sb).append(" IN (");
            Utils.joinAndAppendValues(sb, ",", this.values).append(")");
        }

        @Override
        Object firstValue() {
            return this.values.isEmpty() ? null : this.values.get(0);
        }
    }

    static class SimpleClause
    extends Clause {
        private final String op;
        private final Object value;

        SimpleClause(String name, String op, Object value) {
            super(name);
            this.op = op;
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb) {
            Utils.appendName(this.name, sb).append(this.op);
            Utils.appendValue(this.value, sb);
        }

        @Override
        Object firstValue() {
            return this.value;
        }
    }
}

