/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

class Codec {
    private static ImmutableMap<AbstractType<?>, DataType> rawNativeMap = new ImmutableMap.Builder().put((Object)AsciiType.instance, (Object)DataType.ascii()).put((Object)LongType.instance, (Object)DataType.bigint()).put((Object)BytesType.instance, (Object)DataType.blob()).put((Object)BooleanType.instance, (Object)DataType.cboolean()).put((Object)CounterColumnType.instance, (Object)DataType.counter()).put((Object)DecimalType.instance, (Object)DataType.decimal()).put((Object)DoubleType.instance, (Object)DataType.cdouble()).put((Object)FloatType.instance, (Object)DataType.cfloat()).put((Object)InetAddressType.instance, (Object)DataType.inet()).put((Object)Int32Type.instance, (Object)DataType.cint()).put((Object)UTF8Type.instance, (Object)DataType.text()).put((Object)DateType.instance, (Object)DataType.timestamp()).put((Object)UUIDType.instance, (Object)DataType.uuid()).put((Object)IntegerType.instance, (Object)DataType.varint()).put((Object)TimeUUIDType.instance, (Object)DataType.timeuuid()).build();
    private static Map<DataType.Name, SetType<?>> SETS = Codec.buildSets();
    private static Map<DataType.Name, ListType<?>> LISTS = Codec.buildLists();
    private static Map<DataType.Name, Map<DataType.Name, MapType<?, ?>>> MAPS = Codec.buildMaps();

    protected static Map<DataType.Name, Map<DataType.Name, MapType<?, ?>>> buildMaps() {
        ImmutableMap.Builder mapsBuilder = ImmutableMap.builder();
        for (DataType typeArg1 : DataType.allPrimitiveTypes()) {
            ImmutableMap.Builder innerMapsBuilder = ImmutableMap.builder();
            for (DataType typeArg2 : DataType.allPrimitiveTypes()) {
                innerMapsBuilder.put((Object)typeArg2.getName(), (Object)MapType.getInstance(Codec.getCodec(typeArg1), Codec.getCodec(typeArg2)));
            }
            mapsBuilder.put((Object)typeArg1.getName(), (Object)Maps.newEnumMap((Map)innerMapsBuilder.build()));
        }
        return Maps.newEnumMap((Map)mapsBuilder.build());
    }

    protected static ImmutableMap<DataType.Name, ListType<?>> buildLists() {
        ImmutableMap.Builder listsBuilder = ImmutableMap.builder();
        for (DataType typeArg : DataType.allPrimitiveTypes()) {
            listsBuilder.put((Object)typeArg.getName(), (Object)ListType.getInstance(Codec.getCodec(typeArg)));
        }
        return Maps.immutableEnumMap((Map)listsBuilder.build());
    }

    protected static ImmutableMap<DataType.Name, SetType<?>> buildSets() {
        ImmutableMap.Builder setsBuilder = ImmutableMap.builder();
        for (DataType typeArg : DataType.allPrimitiveTypes()) {
            AbstractType codec = Codec.getCodec(typeArg);
            setsBuilder.put((Object)typeArg.getName(), (Object)SetType.getInstance(codec));
        }
        return Maps.immutableEnumMap((Map)setsBuilder.build());
    }

    private Codec() {
    }

    public static <T> AbstractType<T> getCodec(DataType type) {
        return Codec.getCodecInternal(type);
    }

    private static AbstractType<?> getCodecInternal(DataType type) {
        switch (type.getName()) {
            case ASCII: {
                return AsciiType.instance;
            }
            case BIGINT: {
                return LongType.instance;
            }
            case BLOB: {
                return BytesType.instance;
            }
            case BOOLEAN: {
                return BooleanType.instance;
            }
            case COUNTER: {
                return CounterColumnType.instance;
            }
            case DECIMAL: {
                return DecimalType.instance;
            }
            case DOUBLE: {
                return DoubleType.instance;
            }
            case FLOAT: {
                return FloatType.instance;
            }
            case INET: {
                return InetAddressType.instance;
            }
            case INT: {
                return Int32Type.instance;
            }
            case TEXT: {
                return UTF8Type.instance;
            }
            case TIMESTAMP: {
                return DateType.instance;
            }
            case UUID: {
                return UUIDType.instance;
            }
            case VARCHAR: {
                return UTF8Type.instance;
            }
            case VARINT: {
                return IntegerType.instance;
            }
            case TIMEUUID: {
                return TimeUUIDType.instance;
            }
            case LIST: {
                return Codec.getListType(type);
            }
            case SET: {
                return Codec.getSetType(type);
            }
            case MAP: {
                return Codec.getMapType(type);
            }
            case CUSTOM: {
                return BytesType.instance;
            }
        }
        throw new RuntimeException("Unknown type");
    }

    private static MapType<?, ?> getMapType(DataType type) {
        DataType dataTypeArg0 = type.getTypeArguments().get(0);
        DataType dateTypeArg1 = type.getTypeArguments().get(1);
        Map<DataType.Name, MapType<?, ?>> tmp = MAPS.get((Object)dataTypeArg0.getName());
        MapType map = tmp == null ? null : tmp.get((Object)dateTypeArg1.getName());
        return map == null ? MapType.getInstance(Codec.getCodecInternal(dataTypeArg0), Codec.getCodecInternal(dateTypeArg1)) : map;
    }

    private static SetType<?> getSetType(DataType type) {
        DataType dataTypeArg0 = type.getTypeArguments().get(0);
        SetType set = SETS.get((Object)dataTypeArg0.getName());
        return set == null ? SetType.getInstance(Codec.getCodecInternal(dataTypeArg0)) : set;
    }

    private static ListType<?> getListType(DataType type) {
        DataType dataTypeArg0 = type.getTypeArguments().get(0);
        ListType list = LISTS.get((Object)dataTypeArg0.getName());
        return list == null ? ListType.getInstance(Codec.getCodecInternal(dataTypeArg0)) : list;
    }

    public static DataType rawTypeToDataType(AbstractType<?> rawType) {
        DataType type;
        if (rawType instanceof ReversedType) {
            rawType = ((ReversedType)rawType).baseType;
        }
        if ((type = (DataType)rawNativeMap.get(rawType)) != null) {
            return type;
        }
        if (rawType instanceof CollectionType) {
            switch (((CollectionType)rawType).kind) {
                case LIST: {
                    return DataType.list(Codec.rawTypeToDataType(((ListType)rawType).elements));
                }
                case SET: {
                    return DataType.set(Codec.rawTypeToDataType(((SetType)rawType).elements));
                }
                case MAP: {
                    MapType mt = (MapType)rawType;
                    return DataType.map(Codec.rawTypeToDataType(mt.keys), Codec.rawTypeToDataType(mt.values));
                }
            }
        }
        return DataType.custom(rawType.getClass().toString());
    }
}

