/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.cassandra.transport.messages;

import com.datastax.cassandra.transport.Message;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Event;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class RegisterMessage
extends Message.Request {
    public static final Message.Codec<RegisterMessage> codec = new Message.Codec<RegisterMessage>(){

        public RegisterMessage decode(ChannelBuffer body) {
            int length = body.readUnsignedShort();
            ArrayList<Event.Type> eventTypes = new ArrayList<Event.Type>(length);
            for (int i = 0; i < length; ++i) {
                eventTypes.add((Event.Type)CBUtil.readEnumValue(Event.Type.class, (ChannelBuffer)body));
            }
            return new RegisterMessage(eventTypes);
        }

        public ChannelBuffer encode(RegisterMessage msg) {
            ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
            cb.writeShort(msg.eventTypes.size());
            for (Event.Type type : msg.eventTypes) {
                cb.writeBytes(CBUtil.enumValueToCB((Enum)type));
            }
            return cb;
        }
    };
    public final List<Event.Type> eventTypes;

    public RegisterMessage(List<Event.Type> eventTypes) {
        super(Message.Type.REGISTER);
        this.eventTypes = eventTypes;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    public String toString() {
        return "REGISTER " + this.eventTypes;
    }
}

