/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.cassandra.transport.Message;
import com.datastax.cassandra.transport.messages.EventMessage;
import com.datastax.cassandra.transport.messages.PrepareMessage;
import com.datastax.driver.core.AbstractReconnectionHandler;
import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.ConvictionPolicy;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.MetricsOptions;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleFuture;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.utils.MD5Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster {
    private static final Logger logger = LoggerFactory.getLogger(Cluster.class);
    final Manager manager;

    private Cluster(List<InetAddress> contactPoints, Configuration configuration, boolean init) {
        this.manager = new Manager(contactPoints, configuration);
        if (init) {
            this.manager.init();
        }
    }

    public static Cluster buildFrom(Initializer initializer) {
        List<InetAddress> contactPoints = initializer.getContactPoints();
        if (contactPoints.isEmpty()) {
            throw new IllegalArgumentException("Cannot build a cluster without contact points");
        }
        return new Cluster(contactPoints, initializer.getConfiguration(), true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Session connect() {
        this.manager.init();
        return this.manager.newSession();
    }

    public Session connect(String keyspace) {
        Session session = this.connect();
        session.manager.setKeyspace(keyspace);
        return session;
    }

    public Metadata getMetadata() {
        this.manager.init();
        return this.manager.metadata;
    }

    public Configuration getConfiguration() {
        return this.manager.configuration;
    }

    public Metrics getMetrics() {
        return this.manager.metrics;
    }

    public Cluster register(Host.StateListener listener) {
        this.manager.listeners.add(listener);
        return this;
    }

    public Cluster unregister(Host.StateListener listener) {
        this.manager.listeners.remove(listener);
        return this;
    }

    public Cluster register(LatencyTracker tracker) {
        this.manager.trackers.add(tracker);
        return this;
    }

    public Cluster unregister(LatencyTracker tracker) {
        this.manager.trackers.remove(tracker);
        return this;
    }

    public void shutdown() {
        this.shutdown(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean shutdown(long timeout, TimeUnit unit) {
        try {
            return this.manager.shutdown(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private static ThreadFactory threadFactory(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).build();
    }

    static long timeSince(long startNanos, TimeUnit destUnit) {
        return destUnit.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
    }

    static /* synthetic */ ThreadFactory access$500(String x0) {
        return Cluster.threadFactory(x0);
    }

    class Manager
    implements Host.StateListener,
    Connection.DefaultResponseHandler {
        private final AtomicBoolean isInit = new AtomicBoolean(false);
        final List<InetAddress> contactPoints;
        final Set<Session> sessions = new CopyOnWriteArraySet<Session>();
        final Metadata metadata;
        final Configuration configuration;
        final Metrics metrics;
        final Connection.Factory connectionFactory;
        final ControlConnection controlConnection;
        final ConvictionPolicy.Factory convictionPolicyFactory = new ConvictionPolicy.Simple.Factory();
        final ScheduledExecutorService reconnectionExecutor = Executors.newScheduledThreadPool(2, Cluster.access$500("Reconnection-%d"));
        final ScheduledExecutorService scheduledTasksExecutor = Executors.newScheduledThreadPool(1, Cluster.access$500("Scheduled Tasks-%d"));
        final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Cluster.access$500("Cassandra Java Driver worker-%d")));
        final AtomicBoolean isShutdown = new AtomicBoolean(false);
        final Map<MD5Digest, PreparedStatement> preparedQueries = new ConcurrentHashMap<MD5Digest, PreparedStatement>();
        final Set<Host.StateListener> listeners = new CopyOnWriteArraySet<Host.StateListener>();
        final Set<LatencyTracker> trackers = new CopyOnWriteArraySet<LatencyTracker>();

        private Manager(List<InetAddress> contactPoints, Configuration configuration) {
            logger.debug("Starting new cluster with contact points " + contactPoints);
            this.configuration = configuration;
            this.metadata = new Metadata(this);
            this.contactPoints = contactPoints;
            this.connectionFactory = new Connection.Factory(this, configuration.getAuthProvider());
            this.controlConnection = new ControlConnection(this);
            this.metrics = configuration.getMetricsOptions() == null ? null : new Metrics(this);
            this.configuration.register(this);
        }

        private void init() {
            if (!this.isInit.compareAndSet(false, true)) {
                return;
            }
            for (InetAddress address : this.contactPoints) {
                Host host = this.addHost(address, false);
                if (host == null) continue;
                host.setUp();
            }
            this.loadBalancingPolicy().init(Cluster.this, this.metadata.allHosts());
            try {
                this.controlConnection.connect();
            }
            catch (NoHostAvailableException e) {
                try {
                    this.shutdown(0L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                throw e;
            }
        }

        Cluster getCluster() {
            return Cluster.this;
        }

        LoadBalancingPolicy loadBalancingPolicy() {
            return this.configuration.getPolicies().getLoadBalancingPolicy();
        }

        ReconnectionPolicy reconnectionPolicy() {
            return this.configuration.getPolicies().getReconnectionPolicy();
        }

        private Session newSession() {
            this.init();
            Session session = new Session(Cluster.this, this.metadata.allHosts());
            this.sessions.add(session);
            return session;
        }

        void reportLatency(Host host, long latencyNanos) {
            for (LatencyTracker tracker : this.trackers) {
                tracker.update(host, latencyNanos);
            }
        }

        private boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
            if (!this.isShutdown.compareAndSet(false, true)) {
                return true;
            }
            logger.debug("Shutting down");
            long start = System.nanoTime();
            boolean success = true;
            success &= this.controlConnection.shutdown(timeout, unit);
            for (Session session : this.sessions) {
                success &= session.shutdown(timeout - Cluster.timeSince(start, unit), unit);
            }
            this.reconnectionExecutor.shutdown();
            this.scheduledTasksExecutor.shutdown();
            this.executor.shutdown();
            success &= this.connectionFactory.shutdown(timeout - Cluster.timeSince(start, unit), unit);
            if (this.metrics != null) {
                this.metrics.shutdown();
            }
            return success && this.reconnectionExecutor.awaitTermination(timeout - Cluster.timeSince(start, unit), unit) && this.scheduledTasksExecutor.awaitTermination(timeout - Cluster.timeSince(start, unit), unit) && this.executor.awaitTermination(timeout - Cluster.timeSince(start, unit), unit);
        }

        @Override
        public void onUp(final Host host) {
            logger.trace("Host {} is UP", (Object)host);
            if (this.isShutdown.get()) {
                return;
            }
            if (host.isUp()) {
                return;
            }
            ScheduledFuture scheduledAttempt = host.reconnectionAttempt.getAndSet(null);
            if (scheduledAttempt != null) {
                logger.debug("Cancelling reconnection attempt since node is UP");
                scheduledAttempt.cancel(false);
            }
            try {
                this.prepareAllQueries(host);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            for (Session s : this.sessions) {
                s.manager.removePool(host);
            }
            this.loadBalancingPolicy().onUp(host);
            this.controlConnection.onUp(host);
            ArrayList<ListenableFuture<Boolean>> futures = new ArrayList<ListenableFuture<Boolean>>(this.sessions.size());
            for (Session s : this.sessions) {
                futures.add(s.manager.addOrRenewPool(host, false));
            }
            Futures.addCallback((ListenableFuture)Futures.allAsList(futures), (FutureCallback)new FutureCallback<List<Boolean>>(){

                public void onSuccess(List<Boolean> poolCreationResults) {
                    if (Iterables.any(poolCreationResults, (Predicate)Predicates.equalTo((Object)false))) {
                        logger.debug("Connection pool cannot be created, not marking {} UP", (Object)host);
                        return;
                    }
                    host.setUp();
                    for (Host.StateListener listener : Manager.this.listeners) {
                        listener.onUp(host);
                    }
                    for (Session s : Manager.this.sessions) {
                        s.manager.updateCreatedPools();
                    }
                }

                public void onFailure(Throwable t) {
                    if (!(t instanceof InterruptedException)) {
                        logger.error("Unexpected error while marking node UP: while this shouldn't happen, this shouldn't be critical", t);
                    }
                }
            });
        }

        @Override
        public void onDown(Host host) {
            this.onDown(host, false);
        }

        public void onDown(final Host host, final boolean isHostAddition) {
            logger.trace("Host {} is DOWN", (Object)host);
            if (this.isShutdown.get()) {
                return;
            }
            if (host.reconnectionAttempt.get() != null) {
                return;
            }
            boolean wasUp = host.isUp();
            host.setDown();
            this.loadBalancingPolicy().onDown(host);
            this.controlConnection.onDown(host);
            for (Session s : this.sessions) {
                s.manager.onDown(host);
            }
            if (wasUp) {
                for (Host.StateListener listener : this.listeners) {
                    listener.onDown(host);
                }
            }
            logger.debug("{} is down, scheduling connection retries", (Object)host);
            new AbstractReconnectionHandler(this.reconnectionExecutor, this.reconnectionPolicy().newSchedule(), host.reconnectionAttempt){

                @Override
                protected Connection tryReconnect() throws ConnectionException, InterruptedException {
                    return Manager.this.connectionFactory.open(host);
                }

                @Override
                protected void onReconnection(Connection connection) {
                    logger.debug("Successful reconnection to {}, setting host UP", (Object)host);
                    if (isHostAddition) {
                        Manager.this.onAdd(host);
                    } else {
                        Manager.this.onUp(host);
                    }
                }

                @Override
                protected boolean onConnectionException(ConnectionException e, long nextDelayMs) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed reconnection to {} ({}), scheduling retry in {} milliseconds", new Object[]{host, e.getMessage(), nextDelayMs});
                    }
                    return true;
                }

                @Override
                protected boolean onUnknownException(Exception e, long nextDelayMs) {
                    logger.error(String.format("Unknown error during control connection reconnection, scheduling retry in %d milliseconds", nextDelayMs), (Throwable)e);
                    return true;
                }
            }.start();
        }

        @Override
        public void onAdd(final Host host) {
            logger.trace("Adding new host {}", (Object)host);
            if (this.isShutdown.get()) {
                return;
            }
            try {
                this.prepareAllQueries(host);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.loadBalancingPolicy().onAdd(host);
            this.controlConnection.onAdd(host);
            ArrayList<ListenableFuture<Boolean>> futures = new ArrayList<ListenableFuture<Boolean>>(this.sessions.size());
            for (Session s : this.sessions) {
                futures.add(s.manager.addOrRenewPool(host, true));
            }
            Futures.addCallback((ListenableFuture)Futures.allAsList(futures), (FutureCallback)new FutureCallback<List<Boolean>>(){

                public void onSuccess(List<Boolean> poolCreationResults) {
                    if (Iterables.any(poolCreationResults, (Predicate)Predicates.equalTo((Object)false))) {
                        logger.debug("Connection pool cannot be created, not marking {} UP", (Object)host);
                        return;
                    }
                    host.setUp();
                    for (Host.StateListener listener : Manager.this.listeners) {
                        listener.onAdd(host);
                    }
                    for (Session s : Manager.this.sessions) {
                        s.manager.updateCreatedPools();
                    }
                }

                public void onFailure(Throwable t) {
                    if (!(t instanceof InterruptedException)) {
                        logger.error("Unexpected error while adding node: while this shouldn't happen, this shouldn't be critical", t);
                    }
                }
            });
        }

        @Override
        public void onRemove(Host host) {
            if (this.isShutdown.get()) {
                return;
            }
            host.setDown();
            logger.trace("Removing host {}", (Object)host);
            this.loadBalancingPolicy().onRemove(host);
            this.controlConnection.onRemove(host);
            for (Session s : this.sessions) {
                s.manager.onRemove(host);
            }
            for (Host.StateListener listener : this.listeners) {
                listener.onRemove(host);
            }
        }

        public boolean signalConnectionFailure(Host host, ConnectionException exception, boolean isHostAddition) {
            boolean isDown = host.signalConnectionFailure(exception);
            if (isDown) {
                this.onDown(host, isHostAddition);
            }
            return isDown;
        }

        public Host addHost(InetAddress address, boolean signal) {
            Host newHost = this.metadata.add(address);
            if (newHost != null && signal) {
                logger.info("New Cassandra host {} added", (Object)newHost);
                this.onAdd(newHost);
            }
            return newHost;
        }

        public void removeHost(Host host) {
            if (host == null) {
                return;
            }
            if (this.metadata.remove(host)) {
                logger.info("Cassandra host {} removed", (Object)host);
                this.onRemove(host);
            }
        }

        public void ensurePoolsSizing() {
            for (Session session : this.sessions) {
                for (HostConnectionPool pool : session.manager.pools.values()) {
                    pool.ensureCoreConnections();
                }
            }
        }

        public void prepare(MD5Digest digest, PreparedStatement stmt, InetAddress toExclude) throws InterruptedException {
            this.preparedQueries.put(digest, stmt);
            for (Session s : this.sessions) {
                s.manager.prepare(stmt.getQueryString(), toExclude);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepareAllQueries(Host host) throws InterruptedException {
            if (this.preparedQueries.isEmpty()) {
                return;
            }
            logger.debug("Preparing {} prepared queries on newly up node {}", (Object)this.preparedQueries.size(), (Object)host);
            try {
                Connection connection = this.connectionFactory.open(host);
                try {
                    try {
                        ControlConnection.waitForSchemaAgreement(connection, this.metadata);
                    }
                    catch (ExecutionException e) {
                        // empty catch block
                    }
                    HashMultimap perKeyspace = HashMultimap.create();
                    for (PreparedStatement ps : this.preparedQueries.values()) {
                        String keyspace = ps.getQueryKeyspace() == null ? "" : ps.getQueryKeyspace();
                        perKeyspace.put((Object)keyspace, (Object)ps.getQueryString());
                    }
                    for (String keyspace : perKeyspace.keySet()) {
                        if (!keyspace.isEmpty()) {
                            connection.setKeyspace(keyspace);
                        }
                        ArrayList<Connection.Future> futures = new ArrayList<Connection.Future>(this.preparedQueries.size());
                        for (String query : perKeyspace.get((Object)keyspace)) {
                            futures.add(connection.write(new PrepareMessage(query)));
                        }
                        for (Connection.Future future : futures) {
                            try {
                                future.get();
                            }
                            catch (ExecutionException e) {
                                logger.debug("Unexpected error while preparing queries on new/newly up host", (Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    connection.close(0L, TimeUnit.MILLISECONDS);
                }
            }
            catch (ConnectionException e) {
            }
            catch (AuthenticationException e) {
            }
            catch (BusyConnectionException busyConnectionException) {
                // empty catch block
            }
        }

        public void submitSchemaRefresh(final String keyspace, final String table) {
            logger.trace("Submitting schema refresh");
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Manager.this.controlConnection.refreshSchema(keyspace, table);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }

        public void refreshSchema(final Connection connection, final SimpleFuture<ResultSet> future, final ResultSet rs, final String keyspace, final String table) {
            if (logger.isDebugEnabled()) {
                logger.debug("Refreshing schema for {}{}", (Object)(keyspace == null ? "" : keyspace), (Object)(table == null ? "" : "." + table));
            }
            this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (!ControlConnection.waitForSchemaAgreement(connection, Manager.this.metadata)) {
                            logger.warn("No schema agreement from live replicas after {} ms. The schema may not be up to date on some nodes.", (Object)10000L);
                        }
                        ControlConnection.refreshSchema(connection, keyspace, table, Manager.this);
                    }
                    catch (Exception e) {
                        logger.error("Error during schema refresh ({}). The schema from Cluster.getMetadata() might appear stale. Asynchronously submitting job to fix.", (Object)e.getMessage());
                        Manager.this.submitSchemaRefresh(keyspace, table);
                    }
                    finally {
                        future.set(rs);
                    }
                }
            });
        }

        @Override
        public void handle(Message.Response response) {
            if (!(response instanceof EventMessage)) {
                logger.error("Received an unexpected message from the server: {}", (Object)response);
                return;
            }
            final Event event = ((EventMessage)response).event;
            logger.debug("Received event {}, scheduling delivery", (Object)response);
            this.scheduledTasksExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    block0 : switch (event.type) {
                        case TOPOLOGY_CHANGE: {
                            Event.TopologyChange tpc = (Event.TopologyChange)event;
                            switch (tpc.change) {
                                case NEW_NODE: {
                                    Manager.this.addHost(tpc.node.getAddress(), true);
                                    break;
                                }
                                case REMOVED_NODE: {
                                    Manager.this.removeHost(Manager.this.metadata.getHost(tpc.node.getAddress()));
                                    break;
                                }
                                case MOVED_NODE: {
                                    Manager.this.controlConnection.refreshNodeListAndTokenMap();
                                }
                            }
                            break;
                        }
                        case STATUS_CHANGE: {
                            Event.StatusChange stc = (Event.StatusChange)event;
                            switch (stc.status) {
                                case UP: {
                                    Host hostUp = Manager.this.metadata.getHost(stc.node.getAddress());
                                    if (hostUp == null) {
                                        Manager.this.addHost(stc.node.getAddress(), true);
                                        break;
                                    }
                                    Manager.this.onUp(hostUp);
                                    break;
                                }
                                case DOWN: {
                                    Host hostDown = Manager.this.metadata.getHost(stc.node.getAddress());
                                    if (hostDown == null) break;
                                    Manager.this.onDown(hostDown);
                                }
                            }
                            break;
                        }
                        case SCHEMA_CHANGE: {
                            Event.SchemaChange scc = (Event.SchemaChange)event;
                            switch (scc.change) {
                                case CREATED: {
                                    if (scc.table.isEmpty()) {
                                        Manager.this.submitSchemaRefresh(null, null);
                                        break block0;
                                    }
                                    Manager.this.submitSchemaRefresh(scc.keyspace, null);
                                    break block0;
                                }
                                case DROPPED: {
                                    if (scc.table.isEmpty()) {
                                        Manager.this.submitSchemaRefresh(null, null);
                                        break block0;
                                    }
                                    Manager.this.submitSchemaRefresh(scc.keyspace, null);
                                    break block0;
                                }
                                case UPDATED: {
                                    if (scc.table.isEmpty()) {
                                        Manager.this.submitSchemaRefresh(scc.keyspace, null);
                                        break block0;
                                    }
                                    Manager.this.submitSchemaRefresh(scc.keyspace, scc.table);
                                }
                            }
                        }
                    }
                }
            }, (long)this.delayForEvent(event), TimeUnit.SECONDS);
        }

        private int delayForEvent(Event event) {
            switch (event.type) {
                case TOPOLOGY_CHANGE: {
                    return 1;
                }
                case STATUS_CHANGE: {
                    Event.StatusChange stc = (Event.StatusChange)event;
                    if (stc.status != Event.StatusChange.Status.UP) break;
                    return 1;
                }
            }
            return 0;
        }
    }

    public static class Builder
    implements Initializer {
        private final List<InetAddress> addresses = new ArrayList<InetAddress>();
        private int port = 9042;
        private AuthProvider authProvider = AuthProvider.NONE;
        private LoadBalancingPolicy loadBalancingPolicy;
        private ReconnectionPolicy reconnectionPolicy;
        private RetryPolicy retryPolicy;
        private ProtocolOptions.Compression compression = ProtocolOptions.Compression.NONE;
        private SSLOptions sslOptions = null;
        private boolean metricsEnabled = true;
        private boolean jmxEnabled = true;
        private PoolingOptions poolingOptions = new PoolingOptions();
        private SocketOptions socketOptions = new SocketOptions();
        private boolean deferInitialization = false;

        @Override
        public List<InetAddress> getContactPoints() {
            return this.addresses;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder addContactPoint(String address) {
            try {
                this.addresses.add(InetAddress.getByName(address));
                return this;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public Builder addContactPoints(String ... addresses) {
            for (String address : addresses) {
                this.addContactPoint(address);
            }
            return this;
        }

        public Builder addContactPoints(InetAddress ... addresses) {
            for (InetAddress address : addresses) {
                this.addresses.add(address);
            }
            return this;
        }

        public Builder withLoadBalancingPolicy(LoadBalancingPolicy policy) {
            this.loadBalancingPolicy = policy;
            return this;
        }

        public Builder withReconnectionPolicy(ReconnectionPolicy policy) {
            this.reconnectionPolicy = policy;
            return this;
        }

        public Builder withRetryPolicy(RetryPolicy policy) {
            this.retryPolicy = policy;
            return this;
        }

        public Builder withCredentials(String username, String password) {
            this.authProvider = new PlainTextAuthProvider(username, password);
            return this;
        }

        public Builder withAuthProvider(AuthProvider authProvider) {
            this.authProvider = authProvider;
            return this;
        }

        public Builder withCompression(ProtocolOptions.Compression compression) {
            this.compression = compression;
            return this;
        }

        public Builder withoutMetrics() {
            this.metricsEnabled = false;
            return this;
        }

        public Builder withSSL() {
            this.sslOptions = new SSLOptions();
            return this;
        }

        public Builder withSSL(SSLOptions sslOptions) {
            this.sslOptions = sslOptions;
            return this;
        }

        public Builder withoutJMXReporting() {
            this.jmxEnabled = false;
            return this;
        }

        @Deprecated
        public PoolingOptions poolingOptions() {
            return this.poolingOptions;
        }

        public Builder withPoolingOptions(PoolingOptions options) {
            this.poolingOptions = options;
            return this;
        }

        @Deprecated
        public SocketOptions socketOptions() {
            return this.socketOptions;
        }

        public Builder withSocketOptions(SocketOptions options) {
            this.socketOptions = options;
            return this;
        }

        public Builder withDeferredInitialization() {
            this.deferInitialization = true;
            return this;
        }

        @Override
        public Configuration getConfiguration() {
            Policies policies = new Policies(this.loadBalancingPolicy == null ? Policies.defaultLoadBalancingPolicy() : this.loadBalancingPolicy, this.reconnectionPolicy == null ? Policies.defaultReconnectionPolicy() : this.reconnectionPolicy, this.retryPolicy == null ? Policies.defaultRetryPolicy() : this.retryPolicy);
            return new Configuration(policies, new ProtocolOptions(this.port, this.sslOptions).setCompression(this.compression), this.poolingOptions, this.socketOptions, this.authProvider, this.metricsEnabled ? new MetricsOptions(this.jmxEnabled) : null);
        }

        public Cluster build() {
            List<InetAddress> contactPoints = this.getContactPoints();
            if (contactPoints.isEmpty()) {
                throw new IllegalArgumentException("Cannot build a cluster without contact points");
            }
            return new Cluster(contactPoints, this.getConfiguration(), !this.deferInitialization);
        }
    }

    public static interface Initializer {
        public List<InetAddress> getContactPoints();

        public Configuration getConfiguration();
    }
}

