/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.cassandra.transport.Message;
import com.datastax.cassandra.transport.messages.ErrorMessage;
import com.datastax.cassandra.transport.messages.ExecuteMessage;
import com.datastax.cassandra.transport.messages.PrepareMessage;
import com.datastax.cassandra.transport.messages.QueryMessage;
import com.datastax.cassandra.transport.messages.ResultMessage;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    final Manager manager;

    Session(Cluster cluster, Collection<Host> hosts) {
        this.manager = new Manager(cluster, hosts);
    }

    public ResultSet execute(String query) {
        return this.execute(new SimpleStatement(query));
    }

    public ResultSet execute(Query query) {
        return this.executeAsync(query).getUninterruptibly();
    }

    public ResultSetFuture executeAsync(String query) {
        return this.executeAsync(new SimpleStatement(query));
    }

    public ResultSetFuture executeAsync(Query query) {
        if (query instanceof Statement) {
            return this.manager.executeQuery(new QueryMessage(((Statement)query).getQueryString(), ConsistencyLevel.toCassandraCL(query.getConsistencyLevel())), query);
        }
        assert (query instanceof BoundStatement) : query;
        BoundStatement bs = (BoundStatement)query;
        return this.manager.executeQuery(new ExecuteMessage(bs.statement.id, Arrays.asList(bs.values), ConsistencyLevel.toCassandraCL(query.getConsistencyLevel())), query);
    }

    public PreparedStatement prepare(String query) {
        Connection.Future future = new Connection.Future(new PrepareMessage(query));
        this.manager.execute(future, Query.DEFAULT);
        return this.toPreparedStatement(query, future);
    }

    public PreparedStatement prepare(Statement statement) {
        PreparedStatement prepared = this.prepare(statement.getQueryString());
        ByteBuffer routingKey = statement.getRoutingKey();
        if (routingKey != null) {
            prepared.setRoutingKey(routingKey);
        }
        prepared.setConsistencyLevel(statement.getConsistencyLevel());
        if (statement.isTracing()) {
            prepared.enableTracing();
        }
        prepared.setRetryPolicy(statement.getRetryPolicy());
        return prepared;
    }

    public void shutdown() {
        this.shutdown(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean shutdown(long timeout, TimeUnit unit) {
        try {
            return this.manager.shutdown(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public Cluster getCluster() {
        return this.manager.cluster;
    }

    private PreparedStatement toPreparedStatement(String query, Connection.Future future) {
        try {
            Message.Response response = (Message.Response)Uninterruptibles.getUninterruptibly((Future)((Object)future));
            switch (response.type) {
                case RESULT: {
                    ResultMessage rm = (ResultMessage)response;
                    switch (rm.kind) {
                        case PREPARED: {
                            ResultMessage.Prepared pmsg = (ResultMessage.Prepared)rm;
                            PreparedStatement stmt = PreparedStatement.fromMessage(pmsg, this.manager.cluster.getMetadata(), query, this.manager.poolsState.keyspace);
                            try {
                                this.manager.cluster.manager.prepare(pmsg.statementId, stmt, future.getAddress());
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            return stmt;
                        }
                    }
                    throw new DriverInternalError(String.format("%s response received when prepared statement was expected", new Object[]{rm.kind}));
                }
                case ERROR: {
                    ResultSetFuture.extractCause(ResultSetFuture.convertException(((ErrorMessage)response).error));
                    break;
                }
                default: {
                    throw new DriverInternalError(String.format("%s response received when prepared statement was expected", new Object[]{response.type}));
                }
            }
            throw new AssertionError();
        }
        catch (ExecutionException e) {
            ResultSetFuture.extractCauseFromExecutionException(e);
            throw new AssertionError();
        }
    }

    static class Manager
    implements Host.StateListener {
        final Cluster cluster;
        final ConcurrentMap<Host, HostConnectionPool> pools;
        final HostConnectionPool.PoolState poolsState;
        final AtomicBoolean isShutdown = new AtomicBoolean(false);

        public Manager(Cluster cluster, Collection<Host> hosts) {
            this.cluster = cluster;
            this.pools = new ConcurrentHashMap<Host, HostConnectionPool>(hosts.size());
            this.poolsState = new HostConnectionPool.PoolState();
            for (Host host : hosts) {
                try {
                    this.addOrRenewPool(host).get();
                }
                catch (ExecutionException e) {
                    throw new DriverInternalError(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public Connection.Factory connectionFactory() {
            return this.cluster.manager.connectionFactory;
        }

        public Configuration configuration() {
            return this.cluster.manager.configuration;
        }

        LoadBalancingPolicy loadBalancingPolicy() {
            return this.cluster.manager.loadBalancingPolicy();
        }

        ReconnectionPolicy reconnectionPolicy() {
            return this.cluster.manager.reconnectionPolicy();
        }

        public ListeningExecutorService executor() {
            return this.cluster.manager.executor;
        }

        private boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
            if (!this.isShutdown.compareAndSet(false, true)) {
                return true;
            }
            long start = System.nanoTime();
            boolean success = true;
            for (HostConnectionPool pool : this.pools.values()) {
                success &= pool.shutdown(timeout - Cluster.timeSince(start, unit), unit);
            }
            return success;
        }

        private ListenableFuture<?> addOrRenewPool(final Host host) {
            final HostDistance distance = this.cluster.manager.loadBalancingPolicy().distance(host);
            if (distance == HostDistance.IGNORED) {
                return Futures.immediateFuture(null);
            }
            return this.executor().submit(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Adding {} to list of queried hosts", (Object)host);
                    try {
                        HostConnectionPool previous = Manager.this.pools.put(host, new HostConnectionPool(host, distance, Manager.this));
                        if (previous != null) {
                            previous.shutdown();
                        }
                    }
                    catch (AuthenticationException e) {
                        logger.error("Error creating pool to {} ({})", (Object)host, (Object)e.getMessage());
                        Manager.this.cluster.manager.signalConnectionFailure(host, new ConnectionException(e.getHost(), e.getMessage()));
                    }
                    catch (ConnectionException e) {
                        logger.debug("Error creating pool to {} ({})", (Object)host, (Object)e.getMessage());
                        Manager.this.cluster.manager.signalConnectionFailure(host, e);
                    }
                }
            });
        }

        ListenableFuture<?> removePool(Host host) {
            final HostConnectionPool pool = (HostConnectionPool)this.pools.remove(host);
            if (pool == null) {
                return Futures.immediateFuture(null);
            }
            return this.executor().submit(new Runnable(){

                @Override
                public void run() {
                    pool.shutdown();
                }
            });
        }

        private void updateCreatedPools() {
            for (Host h : this.cluster.getMetadata().allHosts()) {
                HostDistance dist = this.loadBalancingPolicy().distance(h);
                HostConnectionPool pool = (HostConnectionPool)this.pools.get(h);
                if (pool == null) {
                    if (dist == HostDistance.IGNORED || !h.isUp()) continue;
                    this.addOrRenewPool(h);
                    continue;
                }
                if (dist == pool.hostDistance) continue;
                if (dist == HostDistance.IGNORED) {
                    this.removePool(h);
                    continue;
                }
                pool.hostDistance = dist;
            }
        }

        @Override
        public void onUp(Host host) {
            this.addOrRenewPool(host).addListener(new Runnable(){

                @Override
                public void run() {
                    Manager.this.updateCreatedPools();
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
        }

        @Override
        public void onDown(Host host) {
            this.removePool(host).addListener(new Runnable(){

                @Override
                public void run() {
                    Manager.this.updateCreatedPools();
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
        }

        @Override
        public void onAdd(Host host) {
            this.onUp(host);
        }

        @Override
        public void onRemove(Host host) {
            this.onDown(host);
        }

        public void setKeyspace(String keyspace) {
            long timeout = this.configuration().getSocketOptions().getConnectTimeoutMillis();
            try {
                ResultSetFuture future = this.executeQuery(new QueryMessage("use " + keyspace, ConsistencyLevel.DEFAULT_CASSANDRA_CL), Query.DEFAULT);
                Uninterruptibles.getUninterruptibly((Future)((Object)future), (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new DriverInternalError(String.format("No responses after %d milliseconds while setting current keyspace. This should not happen, unless you have setup a very low connection timeout.", timeout));
            }
            catch (ExecutionException e) {
                ResultSetFuture.extractCauseFromExecutionException(e);
            }
        }

        public void execute(RequestHandler.Callback callback, Query query) {
            new RequestHandler(this, callback, query).sendRequest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void prepare(String query, InetAddress toExclude) throws InterruptedException {
            Iterator i$ = this.pools.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entry = i$.next();
                if (((Host)entry.getKey()).getAddress().equals(toExclude)) continue;
                Connection c = null;
                try {
                    c = ((HostConnectionPool)entry.getValue()).borrowConnection(200L, TimeUnit.MILLISECONDS);
                    c.write(new PrepareMessage(query)).get();
                    continue;
                }
                catch (ConnectionException e) {
                    continue;
                }
                catch (BusyConnectionException e) {
                    continue;
                }
                catch (TimeoutException e) {
                    continue;
                }
                catch (ExecutionException e) {
                    logger.error(String.format("Unexpected error while preparing query (%s) on %s", query, entry.getKey()), (Throwable)e);
                    continue;
                }
                finally {
                    if (c == null) continue;
                    ((HostConnectionPool)entry.getValue()).returnConnection(c);
                    continue;
                }
                break;
            }
            return;
        }

        public ResultSetFuture executeQuery(Message.Request msg, Query query) {
            if (query.isTracing()) {
                msg.setTracingRequested();
            }
            ResultSetFuture future = new ResultSetFuture(this, msg);
            this.execute(future.callback, query);
            return future;
        }
    }
}

