/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.cassandra.transport.messages;

import com.datastax.cassandra.transport.Message;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.utils.MD5Digest;
import org.jboss.netty.buffer.ChannelBuffer;

public class ExecuteMessage
extends Message.Request {
    public static final Message.Codec<ExecuteMessage> codec = new Message.Codec<ExecuteMessage>(){

        public ExecuteMessage decode(ChannelBuffer body) {
            byte[] id = CBUtil.readBytes((ChannelBuffer)body);
            int count = body.readUnsignedShort();
            ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>(count);
            for (int i = 0; i < count; ++i) {
                values.add(CBUtil.readValue((ChannelBuffer)body));
            }
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel((ChannelBuffer)body);
            return new ExecuteMessage(id, values, consistency);
        }

        public ChannelBuffer encode(ExecuteMessage msg) {
            int vs = msg.values.size();
            CBUtil.BufferBuilder builder = new CBUtil.BufferBuilder(3, 0, vs);
            builder.add(CBUtil.bytesToCB((byte[])msg.statementId.bytes));
            builder.add(CBUtil.shortToCB((int)vs));
            for (ByteBuffer value : msg.values) {
                builder.addValue(value);
            }
            builder.add(CBUtil.consistencyLevelToCB((ConsistencyLevel)msg.consistency));
            return builder.build();
        }
    };
    public final MD5Digest statementId;
    public final List<ByteBuffer> values;
    public final ConsistencyLevel consistency;

    public ExecuteMessage(byte[] statementId, List<ByteBuffer> values, ConsistencyLevel consistency) {
        this(MD5Digest.wrap((byte[])statementId), values, consistency);
    }

    public ExecuteMessage(MD5Digest statementId, List<ByteBuffer> values, ConsistencyLevel consistency) {
        super(Message.Type.EXECUTE);
        this.statementId = statementId;
        this.values = values;
        this.consistency = consistency;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    public String toString() {
        return "EXECUTE " + this.statementId + " with " + this.values.size() + " values at consistency " + this.consistency;
    }
}

