/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.Assignment;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Using;
import com.datastax.driver.core.querybuilder.Utils;
import java.util.ArrayList;
import java.util.List;

public class Update
extends BuiltStatement {
    private final String keyspace;
    private final String table;
    private final Assignments assignments;
    private final Where where;
    private final Options usings;

    Update(String keyspace, String table) {
        this.keyspace = keyspace;
        this.table = table;
        this.assignments = new Assignments(this);
        this.where = new Where(this);
        this.usings = new Options(this);
    }

    Update(TableMetadata table) {
        super(table);
        this.keyspace = table.getKeyspace().getName();
        this.table = table.getName();
        this.assignments = new Assignments(this);
        this.where = new Where(this);
        this.usings = new Options(this);
    }

    @Override
    protected String buildQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append(".");
        }
        Utils.appendName(this.table, builder);
        if (!this.usings.usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(builder, " AND ", this.usings.usings);
        }
        if (!this.assignments.assignments.isEmpty()) {
            builder.append(" SET ");
            Utils.joinAndAppend(builder, ",", this.assignments.assignments);
        }
        if (!this.where.clauses.isEmpty()) {
            builder.append(" WHERE ");
            Utils.joinAndAppend(builder, " AND ", this.where.clauses);
        }
        return builder.toString();
    }

    public Assignments with(Assignment assignment) {
        return this.assignments.and(assignment);
    }

    public Assignments with() {
        return this.assignments;
    }

    public Where where(Clause clause) {
        return this.where.and(clause);
    }

    public Where where() {
        return this.where;
    }

    public Options using(Using using) {
        return this.usings.and(using);
    }

    public static class Options
    extends BuiltStatement.ForwardingStatement<Update> {
        private final List<Using> usings = new ArrayList<Using>();

        Options(Update statement) {
            super(statement);
        }

        public Options and(Using using) {
            this.usings.add(using);
            this.setDirty();
            return this;
        }

        public Assignments with(Assignment assignment) {
            return ((Update)this.statement).with(assignment);
        }

        public Where where(Clause clause) {
            return ((Update)this.statement).where(clause);
        }
    }

    public static class Where
    extends BuiltStatement.ForwardingStatement<Update> {
        private final List<Clause> clauses = new ArrayList<Clause>();

        Where(Update statement) {
            super(statement);
        }

        public Where and(Clause clause) {
            this.clauses.add(clause);
            ((Update)this.statement).maybeAddRoutingKey(clause.name(), clause.firstValue());
            this.setDirty();
            return this;
        }

        public Assignments with(Assignment assignment) {
            return ((Update)this.statement).with(assignment);
        }

        public Options using(Using using) {
            return ((Update)this.statement).using(using);
        }
    }

    public static class Assignments
    extends BuiltStatement.ForwardingStatement<Update> {
        private final List<Assignment> assignments = new ArrayList<Assignment>();

        Assignments(Update statement) {
            super(statement);
        }

        public Assignments and(Assignment assignment) {
            ((Update)this.statement).setCounterOp(assignment instanceof Assignment.CounterAssignment);
            this.assignments.add(assignment);
            this.setDirty();
            return this;
        }

        public Where where(Clause clause) {
            return ((Update)this.statement).where(clause);
        }

        public Options using(Using using) {
            return ((Update)this.statement).using(using);
        }
    }
}

