/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Using;
import com.datastax.driver.core.querybuilder.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class Batch
extends BuiltStatement {
    private final List<Statement> statements;
    private final Options usings;
    private ByteBuffer routingKey;

    Batch(Statement[] statements) {
        this.statements = statements.length == 0 ? new ArrayList<Statement>() : new ArrayList(statements.length);
        this.usings = new Options(this);
        for (int i = 0; i < statements.length; ++i) {
            this.add(statements[i]);
        }
    }

    @Override
    protected String buildQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isCounterOp() ? "BEGIN COUNTER BATCH" : "BEGIN BATCH");
        if (!this.usings.usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(builder, " AND ", this.usings.usings);
        }
        builder.append(" ");
        for (int i = 0; i < this.statements.size(); ++i) {
            String str = this.statements.get(i).getQueryString();
            builder.append(str);
            if (str.trim().endsWith(";")) continue;
            builder.append(";");
        }
        builder.append("APPLY BATCH;");
        return builder.toString();
    }

    public Batch add(Statement statement) {
        boolean isCounterOp;
        boolean bl = isCounterOp = statement instanceof BuiltStatement && ((BuiltStatement)statement).isCounterOp();
        if (this.isCounterOp == null) {
            this.setCounterOp(isCounterOp);
        } else if (this.isCounterOp() != isCounterOp) {
            throw new IllegalArgumentException("Cannot mix counter operations and non-counter operations in a batch statement");
        }
        this.statements.add(statement);
        this.setDirty();
        if (this.routingKey == null && statement.getRoutingKey() != null) {
            this.routingKey = statement.getRoutingKey();
        }
        return this;
    }

    public Options using(Using using) {
        return this.usings.and(using);
    }

    @Override
    public ByteBuffer getRoutingKey() {
        return this.routingKey;
    }

    public static class Options
    extends BuiltStatement.ForwardingStatement<Batch> {
        private final List<Using> usings = new ArrayList<Using>();

        Options(Batch statement) {
            super(statement);
        }

        public Options and(Using using) {
            this.usings.add(using);
            this.setDirty();
            return this;
        }

        public Batch add(Statement statement) {
            return ((Batch)this.statement).add(statement);
        }
    }
}

