/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

abstract class Utils {
    private static final Pattern cnamePattern = Pattern.compile("\\w+(?:\\[.+\\])?", 2);
    private static final Pattern fctsPattern = Pattern.compile("(?:count|writetime|ttl|token)\\(.*", 2);

    Utils() {
    }

    static StringBuilder joinAndAppend(StringBuilder sb, String separator, List<? extends Appendeable> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            values.get(i).appendTo(sb);
        }
        return sb;
    }

    static StringBuilder joinAndAppendNames(StringBuilder sb, String separator, List<String> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            Utils.appendName(values.get(i), sb);
        }
        return sb;
    }

    static StringBuilder joinAndAppendValues(StringBuilder sb, String separator, List<Object> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            Utils.appendValue(values.get(i), sb);
        }
        return sb;
    }

    static StringBuilder appendValue(Object value, StringBuilder sb) {
        return Utils.appendValue(value, sb, false);
    }

    static StringBuilder appendFlatValue(Object value, StringBuilder sb) {
        Utils.appendFlatValue(value, sb, false);
        return sb;
    }

    private static StringBuilder appendValue(Object value, StringBuilder sb, boolean rawValue) {
        if (Utils.appendValueIfLiteral(value, sb)) {
            return sb;
        }
        if (Utils.appendValueIfCollection(value, sb, rawValue)) {
            return sb;
        }
        if (rawValue) {
            return sb.append(value.toString());
        }
        return Utils.appendValueString(value.toString(), sb);
    }

    private static void appendFlatValue(Object value, StringBuilder sb, boolean rawValue) {
        if (Utils.appendValueIfLiteral(value, sb)) {
            return;
        }
        if (rawValue) {
            sb.append(value.toString());
        } else {
            Utils.appendValueString(value.toString(), sb);
        }
    }

    private static boolean appendValueIfLiteral(Object value, StringBuilder sb) {
        if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof UUID || value instanceof Boolean) {
            sb.append(value);
            return true;
        }
        if (value instanceof InetAddress) {
            sb.append(((InetAddress)value).getHostAddress());
            return true;
        }
        if (value instanceof Date) {
            sb.append(((Date)value).getTime());
            return true;
        }
        if (value == QueryBuilder.BIND_MARKER) {
            sb.append("?");
            return true;
        }
        return false;
    }

    private static boolean appendValueIfCollection(Object value, StringBuilder sb, boolean rawValue) {
        if (value instanceof List) {
            Utils.appendList((List)value, sb, rawValue);
            return true;
        }
        if (value instanceof Set) {
            Utils.appendSet((Set)value, sb, rawValue);
            return true;
        }
        if (value instanceof Map) {
            Utils.appendMap((Map)value, sb, rawValue);
            return true;
        }
        return false;
    }

    static StringBuilder appendCollection(Object value, StringBuilder sb) {
        boolean wasCollection = Utils.appendValueIfCollection(value, sb, false);
        assert (wasCollection);
        return sb;
    }

    static StringBuilder appendList(List<?> l, StringBuilder sb) {
        return Utils.appendList(l, sb, false);
    }

    private static StringBuilder appendList(List<?> l, StringBuilder sb, boolean rawValue) {
        sb.append("[");
        for (int i = 0; i < l.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            Utils.appendFlatValue(l.get(i), sb, rawValue);
        }
        sb.append("]");
        return sb;
    }

    static StringBuilder appendSet(Set<?> s, StringBuilder sb) {
        return Utils.appendSet(s, sb, false);
    }

    private static StringBuilder appendSet(Set<?> s, StringBuilder sb, boolean rawValue) {
        sb.append("{");
        boolean first = true;
        for (Object elt : s) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            Utils.appendFlatValue(elt, sb, rawValue);
        }
        sb.append("}");
        return sb;
    }

    static StringBuilder appendMap(Map<?, ?> m, StringBuilder sb) {
        return Utils.appendMap(m, sb, false);
    }

    private static StringBuilder appendMap(Map<?, ?> m, StringBuilder sb, boolean rawValue) {
        sb.append("{");
        boolean first = true;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            Utils.appendFlatValue(entry.getKey(), sb, rawValue);
            sb.append(":");
            Utils.appendFlatValue(entry.getValue(), sb, rawValue);
        }
        sb.append("}");
        return sb;
    }

    private static StringBuilder appendValueString(String value, StringBuilder sb) {
        return sb.append("'").append(value.replace("'", "''")).append("'");
    }

    static String toRawString(Object value) {
        return Utils.appendValue(value, new StringBuilder(), true).toString();
    }

    static StringBuilder appendName(String name, StringBuilder sb) {
        if (cnamePattern.matcher(name = name.trim()).matches() || name.startsWith("\"") || fctsPattern.matcher(name).matches()) {
            sb.append(name);
        } else {
            sb.append("\"").append(name).append("\"");
        }
        return sb;
    }

    static abstract class Appendeable {
        Appendeable() {
        }

        abstract void appendTo(StringBuilder var1);
    }
}

