/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class DCAwareRoundRobinPolicy
implements LoadBalancingPolicy {
    private final ConcurrentMap<String, CopyOnWriteArrayList<Host>> perDcLiveHosts = new ConcurrentHashMap<String, CopyOnWriteArrayList<Host>>();
    private final AtomicInteger index = new AtomicInteger();
    private final String localDc;
    private final int usedHostsPerRemoteDc;

    public DCAwareRoundRobinPolicy(String localDc) {
        this(localDc, 0);
    }

    public DCAwareRoundRobinPolicy(String localDc, int usedHostsPerRemoteDc) {
        this.localDc = localDc;
        this.usedHostsPerRemoteDc = usedHostsPerRemoteDc;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.index.set(new Random().nextInt(Math.max(hosts.size(), 1)));
        for (Host host : hosts) {
            String dc = this.dc(host);
            CopyOnWriteArrayList prev = (CopyOnWriteArrayList)this.perDcLiveHosts.get(dc);
            if (prev == null) {
                this.perDcLiveHosts.put(dc, new CopyOnWriteArrayList<Host>(Collections.singletonList(host)));
                continue;
            }
            prev.addIfAbsent(host);
        }
    }

    private String dc(Host host) {
        String dc = host.getDatacenter();
        return dc == null ? this.localDc : dc;
    }

    @Override
    public HostDistance distance(Host host) {
        String dc = this.dc(host);
        if (dc.equals(this.localDc)) {
            return HostDistance.LOCAL;
        }
        CopyOnWriteArrayList dcHosts = (CopyOnWriteArrayList)this.perDcLiveHosts.get(dc);
        if (dcHosts == null || this.usedHostsPerRemoteDc == 0) {
            return HostDistance.IGNORED;
        }
        return (dcHosts = (CopyOnWriteArrayList)dcHosts.clone()).subList(0, Math.min(dcHosts.size(), this.usedHostsPerRemoteDc)).contains(host) ? HostDistance.REMOTE : HostDistance.IGNORED;
    }

    @Override
    public Iterator<Host> newQueryPlan(Query query) {
        CopyOnWriteArrayList localLiveHosts = (CopyOnWriteArrayList)this.perDcLiveHosts.get(this.localDc);
        final List hosts = localLiveHosts == null ? Collections.emptyList() : (List)localLiveHosts.clone();
        final int startIdx = this.index.getAndIncrement();
        if (startIdx > 2147473647) {
            this.index.set(0);
        }
        return new AbstractIterator<Host>(){
            private int idx;
            private int remainingLocal;
            private Iterator<String> remoteDcs;
            private List<Host> currentDcHosts;
            private int currentDcRemaining;
            {
                this.idx = startIdx;
                this.remainingLocal = hosts.size();
            }

            protected Host computeNext() {
                if (this.remainingLocal > 0) {
                    --this.remainingLocal;
                    return (Host)hosts.get(this.idx++ % hosts.size());
                }
                if (this.currentDcHosts != null && this.currentDcRemaining > 0) {
                    --this.currentDcRemaining;
                    return this.currentDcHosts.get(this.idx++ % this.currentDcHosts.size());
                }
                if (this.remoteDcs == null) {
                    HashSet copy = new HashSet(DCAwareRoundRobinPolicy.this.perDcLiveHosts.keySet());
                    copy.remove(DCAwareRoundRobinPolicy.this.localDc);
                    this.remoteDcs = copy.iterator();
                }
                if (!this.remoteDcs.hasNext()) {
                    return (Host)this.endOfData();
                }
                String nextRemoteDc = this.remoteDcs.next();
                CopyOnWriteArrayList nextDcHosts = (CopyOnWriteArrayList)DCAwareRoundRobinPolicy.this.perDcLiveHosts.get(nextRemoteDc);
                if (nextDcHosts != null) {
                    this.currentDcHosts = (List)nextDcHosts.clone();
                    this.currentDcRemaining = Math.min(DCAwareRoundRobinPolicy.this.usedHostsPerRemoteDc, this.currentDcHosts.size());
                }
                return this.computeNext();
            }
        };
    }

    @Override
    public void onUp(Host host) {
        CopyOnWriteArrayList<Host> newMap;
        String dc = this.dc(host);
        CopyOnWriteArrayList<Host> dcHosts = (CopyOnWriteArrayList<Host>)this.perDcLiveHosts.get(dc);
        if (dcHosts == null && (dcHosts = this.perDcLiveHosts.putIfAbsent(dc, newMap = new CopyOnWriteArrayList<Host>(Collections.singletonList(host)))) == null) {
            return;
        }
        dcHosts.addIfAbsent(host);
    }

    @Override
    public void onDown(Host host) {
        CopyOnWriteArrayList dcHosts = (CopyOnWriteArrayList)this.perDcLiveHosts.get(this.dc(host));
        if (dcHosts != null) {
            dcHosts.remove(host);
        }
    }

    @Override
    public void onAdd(Host host) {
        this.onUp(host);
    }

    @Override
    public void onRemove(Host host) {
        this.onDown(host);
    }
}

