/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.exceptions.QueryExecutionException;

public class UnavailableException
extends QueryExecutionException {
    private final ConsistencyLevel consistency;
    private final int required;
    private final int alive;

    public UnavailableException(ConsistencyLevel consistency, int required, int alive) {
        super(String.format("Not enough replica available for query at consistency %s (%d required but only %d alive)", new Object[]{consistency, required, alive}));
        this.consistency = consistency;
        this.required = required;
        this.alive = alive;
    }

    public ConsistencyLevel getConsistency() {
        return this.consistency;
    }

    public int getRequiredReplicas() {
        return this.required;
    }

    public int getAliveReplicas() {
        return this.alive;
    }
}

