/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Codec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.marshal.MarshalException;

public class DataType {
    private final Name name;
    private final List<DataType> typeArguments;
    private static final Map<Name, DataType> primitiveTypeMap = new EnumMap<Name, DataType>(Name.class);
    private static final Set<DataType> primitveTypeSet;

    private DataType(Name name, List<DataType> typeArguments) {
        this.name = name;
        this.typeArguments = typeArguments;
    }

    public static DataType ascii() {
        return primitiveTypeMap.get((Object)Name.ASCII);
    }

    public static DataType bigint() {
        return primitiveTypeMap.get((Object)Name.BIGINT);
    }

    public static DataType blob() {
        return primitiveTypeMap.get((Object)Name.BLOB);
    }

    public static DataType cboolean() {
        return primitiveTypeMap.get((Object)Name.BOOLEAN);
    }

    public static DataType counter() {
        return primitiveTypeMap.get((Object)Name.COUNTER);
    }

    public static DataType decimal() {
        return primitiveTypeMap.get((Object)Name.DECIMAL);
    }

    public static DataType cdouble() {
        return primitiveTypeMap.get((Object)Name.DOUBLE);
    }

    public static DataType cfloat() {
        return primitiveTypeMap.get((Object)Name.FLOAT);
    }

    public static DataType inet() {
        return primitiveTypeMap.get((Object)Name.INET);
    }

    public static DataType cint() {
        return primitiveTypeMap.get((Object)Name.INT);
    }

    public static DataType text() {
        return primitiveTypeMap.get((Object)Name.TEXT);
    }

    public static DataType timestamp() {
        return primitiveTypeMap.get((Object)Name.TIMESTAMP);
    }

    public static DataType uuid() {
        return primitiveTypeMap.get((Object)Name.UUID);
    }

    public static DataType varchar() {
        return primitiveTypeMap.get((Object)Name.VARCHAR);
    }

    public static DataType varint() {
        return primitiveTypeMap.get((Object)Name.VARINT);
    }

    public static DataType timeuuid() {
        return primitiveTypeMap.get((Object)Name.TIMEUUID);
    }

    public static DataType list(DataType elementType) {
        return new DataType(Name.LIST, (List<DataType>)ImmutableList.of((Object)elementType));
    }

    public static DataType set(DataType elementType) {
        return new DataType(Name.SET, (List<DataType>)ImmutableList.of((Object)elementType));
    }

    public static DataType map(DataType keyType, DataType valueType) {
        return new DataType(Name.MAP, (List<DataType>)ImmutableList.of((Object)keyType, (Object)valueType));
    }

    public Name getName() {
        return this.name;
    }

    public List<DataType> getTypeArguments() {
        return this.typeArguments;
    }

    public ByteBuffer parse(String value) {
        try {
            return Codec.getCodec(this).fromString(value);
        }
        catch (MarshalException e) {
            throw new InvalidTypeException(String.format("Cannot parse '%s' as a %s value (%s)", value, this, e.getMessage()));
        }
    }

    public boolean isCollection() {
        return this.name.isCollection();
    }

    public Class<?> asJavaClass() {
        return this.getName().asJavaClass();
    }

    public static Set<DataType> allPrimitiveTypes() {
        return primitveTypeSet;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.name, this.typeArguments});
    }

    public final boolean equals(Object o) {
        if (!(o instanceof DataType)) {
            return false;
        }
        return this.name == ((DataType)o).name && ((Object)this.typeArguments).equals(((DataType)o).typeArguments);
    }

    public String toString() {
        switch (this.name) {
            case LIST: 
            case SET: {
                return (Object)((Object)this.name) + "<" + this.typeArguments.get(0) + ">";
            }
            case MAP: {
                return (Object)((Object)this.name) + "<" + this.typeArguments.get(0) + ", " + this.typeArguments.get(1) + ">";
            }
        }
        return this.name.toString();
    }

    static {
        for (Name name : Name.values()) {
            if (name.isCollection()) continue;
            primitiveTypeMap.put(name, new DataType(name, Collections.<DataType>emptyList()));
        }
        primitveTypeSet = ImmutableSet.copyOf(primitiveTypeMap.values());
    }

    public static enum Name {
        ASCII(String.class),
        BIGINT(Long.class),
        BLOB(ByteBuffer.class),
        BOOLEAN(Boolean.class),
        COUNTER(Long.class),
        DECIMAL(BigDecimal.class),
        DOUBLE(Double.class),
        FLOAT(Float.class),
        INET(InetAddress.class),
        INT(Integer.class),
        TEXT(String.class),
        TIMESTAMP(Date.class),
        UUID(UUID.class),
        VARCHAR(String.class),
        VARINT(BigInteger.class),
        TIMEUUID(UUID.class),
        LIST(List.class),
        SET(Set.class),
        MAP(Map.class);

        final Class<?> javaType;

        private Name(Class<?> javaType) {
            this.javaType = javaType;
        }

        public boolean isCollection() {
            switch (this) {
                case LIST: 
                case SET: 
                case MAP: {
                    return true;
                }
            }
            return false;
        }

        public Class<?> asJavaClass() {
            return this.javaType;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

