/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthInfoProvider;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.SimpleFuture;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.StreamIdGenerator;
import com.datastax.driver.core.TransportException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Frame;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.CredentialsMessage;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.QueryMessage;
import org.apache.cassandra.transport.messages.StartupMessage;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connection
extends org.apache.cassandra.transport.Connection {
    public static final int MAX_STREAM_PER_CONNECTION = 128;
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private static final String CQL_VERSION = "3.0.0";
    private static final Connection.Tracker EMPTY_TRACKER = new Connection.Tracker(){

        public void addConnection(Channel ch, org.apache.cassandra.transport.Connection connection) {
        }

        public void closeAll() {
        }
    };
    public final InetAddress address;
    private final String name;
    private final Channel channel;
    private final Factory factory;
    private final Dispatcher dispatcher = new Dispatcher();
    public final AtomicInteger inFlight = new AtomicInteger(0);
    private final AtomicInteger writer = new AtomicInteger(0);
    private volatile boolean isClosed;
    private volatile String keyspace;
    private volatile boolean isDefunct;
    private volatile ConnectionException exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection(String name, InetAddress address, Factory factory) throws ConnectionException, InterruptedException {
        super(EMPTY_TRACKER);
        this.address = address;
        this.factory = factory;
        this.name = name;
        ClientBootstrap bootstrap = factory.newBootstrap();
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new PipelineFactory(this));
        ChannelFuture future = bootstrap.connect((SocketAddress)new InetSocketAddress(address, factory.getPort()));
        this.writer.incrementAndGet();
        try {
            this.channel = future.awaitUninterruptibly().getChannel();
            this.factory.allChannels.add((Object)this.channel);
            if (!future.isSuccess()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("[%s] Error connecting to %s%s", name, address, Connection.extractMessage(future.getCause())));
                }
                throw new TransportException(address, "Cannot connect", future.getCause());
            }
        }
        finally {
            this.writer.decrementAndGet();
        }
        logger.trace("[{}] Connection opened successfully", (Object)name);
        this.initializeTransport();
        logger.trace("[{}] Transport initialized and ready", (Object)name);
    }

    private static String extractMessage(Throwable t) {
        if (t == null || t.getMessage().isEmpty()) {
            return "";
        }
        return " (" + t.getMessage() + ")";
    }

    private void initializeTransport() throws ConnectionException, InterruptedException {
        HashMap<String, String> options = new HashMap<String, String>(){
            {
                this.put("CQL_VERSION", Connection.CQL_VERSION);
            }
        };
        ProtocolOptions.Compression compression = this.factory.configuration.getProtocolOptions().getCompression();
        if (compression != ProtocolOptions.Compression.NONE) {
            options.put("COMPRESSION", compression.toString());
            this.setCompressor(compression.compressor());
        }
        StartupMessage startup = new StartupMessage((Map)options);
        try {
            Message.Response response = (Message.Response)this.write((Message.Request)startup).get();
            block1 : switch (response.type) {
                case READY: {
                    break;
                }
                case ERROR: {
                    throw this.defunct(new TransportException(this.address, String.format("Error initializing connection: %s", ((ErrorMessage)response).error.getMessage())));
                }
                case AUTHENTICATE: {
                    CredentialsMessage creds = new CredentialsMessage();
                    creds.credentials.putAll(this.factory.authProvider.getAuthInfos(this.address));
                    Message.Response authResponse = (Message.Response)this.write((Message.Request)creds).get();
                    switch (authResponse.type) {
                        case READY: {
                            break block1;
                        }
                        case ERROR: {
                            throw new AuthenticationException(this.address, ((ErrorMessage)response).error.getMessage());
                        }
                    }
                    throw this.defunct(new TransportException(this.address, String.format("Unexpected %s response message from server to a CREDENTIALS message", authResponse.type)));
                }
                default: {
                    throw this.defunct(new TransportException(this.address, String.format("Unexpected %s response message from server to a STARTUP message", response.type)));
                }
            }
        }
        catch (BusyConnectionException e) {
            throw new DriverInternalError("Newly created connection should not be busy");
        }
        catch (ExecutionException e) {
            throw this.defunct(new ConnectionException(this.address, "Unexpected error during transport initialization", e.getCause()));
        }
    }

    public boolean isDefunct() {
        return this.isDefunct;
    }

    public ConnectionException lastException() {
        return this.exception;
    }

    ConnectionException defunct(ConnectionException e) {
        this.exception = e;
        this.isDefunct = true;
        this.dispatcher.errorOutAllHandler(e);
        return e;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) throws ConnectionException {
        if (keyspace == null) {
            return;
        }
        if (this.keyspace != null && this.keyspace.equals(keyspace)) {
            return;
        }
        try {
            logger.trace("[{}] Setting keyspace {}", (Object)this.name, (Object)keyspace);
            Message.Response response = (Message.Response)Uninterruptibles.getUninterruptibly((java.util.concurrent.Future)((Object)this.write((Message.Request)new QueryMessage("USE \"" + keyspace + "\"", ConsistencyLevel.DEFAULT_CASSANDRA_CL))));
            switch (response.type) {
                case RESULT: {
                    this.keyspace = keyspace;
                    break;
                }
                default: {
                    this.defunct(new ConnectionException(this.address, String.format("Problem while setting keyspace, got %s as response", response)));
                    break;
                }
            }
        }
        catch (ConnectionException e) {
            throw this.defunct(e);
        }
        catch (BusyConnectionException e) {
            logger.error("Tried to set the keyspace on busy connection. This should not happen but is not critical");
        }
        catch (ExecutionException e) {
            throw this.defunct(new ConnectionException(this.address, "Error while setting keyspace", e));
        }
    }

    public Future write(Message.Request request) throws ConnectionException, BusyConnectionException {
        Future future = new Future(request);
        this.write(future);
        return future;
    }

    public void write(ResponseCallback callback) throws ConnectionException, BusyConnectionException {
        Message.Request request = callback.request();
        if (this.isDefunct) {
            throw new ConnectionException(this.address, "Write attempt on defunct connection");
        }
        if (this.isClosed) {
            throw new ConnectionException(this.address, "Connection has been closed");
        }
        request.attach((org.apache.cassandra.transport.Connection)this);
        ResponseHandler handler = new ResponseHandler(this.dispatcher, callback);
        this.dispatcher.add(handler);
        request.setStreamId(handler.streamId);
        logger.trace("[{}] writing request {}", (Object)this.name, (Object)request);
        this.writer.incrementAndGet();
        this.channel.write((Object)request).addListener(this.writeHandler(request, handler));
    }

    private ChannelFutureListener writeHandler(final Message.Request request, final ResponseHandler handler) {
        return new ChannelFutureListener(){

            public void operationComplete(ChannelFuture writeFuture) {
                Connection.this.writer.decrementAndGet();
                if (!writeFuture.isSuccess()) {
                    logger.debug("[{}] Error writing request {}", (Object)Connection.this.name, (Object)request);
                    Connection.this.dispatcher.removeHandler(handler.streamId);
                    TransportException ce = writeFuture.getCause() instanceof ClosedChannelException ? new TransportException(Connection.this.address, "Error writing: Closed channel") : new TransportException(Connection.this.address, "Error writing", writeFuture.getCause());
                    handler.callback.onException(Connection.this, Connection.this.defunct(ce));
                } else {
                    logger.trace("[{}] request sent successfully", (Object)Connection.this.name);
                }
            }
        };
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        logger.trace("[{}] closing connection", (Object)this.name);
        this.isClosed = true;
        if (!this.isDefunct) {
            while (this.writer.get() > 0) {
                Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        this.channel.close().awaitUninterruptibly();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String toString() {
        return String.format("Connection[%s, inFlight=%d, closed=%b]", this.name, this.inFlight.get(), this.isClosed);
    }

    public void validateNewMessage(Message.Type type) {
    }

    public void applyStateTransition(Message.Type requestType, Message.Type responseType) {
    }

    public ClientState clientState() {
        return null;
    }

    private static class PipelineFactory
    implements ChannelPipelineFactory {
        private static final Message.ProtocolDecoder messageDecoder = new Message.ProtocolDecoder();
        private static final Message.ProtocolEncoder messageEncoder = new Message.ProtocolEncoder();
        private static final Frame.Decompressor frameDecompressor = new Frame.Decompressor();
        private static final Frame.Compressor frameCompressor = new Frame.Compressor();
        private static final Frame.Encoder frameEncoder = new Frame.Encoder();
        private static final Connection.Tracker tracker = new Connection.Tracker(){

            public void addConnection(Channel ch, org.apache.cassandra.transport.Connection connection) {
            }

            public void closeAll() {
            }
        };
        private final Connection connection;
        private final Connection.Factory cfactory;

        public PipelineFactory(final Connection connection) {
            this.connection = connection;
            this.cfactory = new Connection.Factory(){

                public Connection newConnection(Connection.Tracker tracker) {
                    return connection;
                }
            };
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("frameDecoder", (ChannelHandler)new Frame.Decoder(tracker, this.cfactory));
            pipeline.addLast("frameEncoder", (ChannelHandler)frameEncoder);
            pipeline.addLast("frameDecompressor", (ChannelHandler)frameDecompressor);
            pipeline.addLast("frameCompressor", (ChannelHandler)frameCompressor);
            pipeline.addLast("messageDecoder", (ChannelHandler)messageDecoder);
            pipeline.addLast("messageEncoder", (ChannelHandler)messageEncoder);
            pipeline.addLast("dispatcher", (ChannelHandler)this.connection.dispatcher);
            return pipeline;
        }
    }

    public static interface DefaultResponseHandler {
        public void handle(Message.Response var1);
    }

    private static class ResponseHandler {
        public final int streamId;
        public final ResponseCallback callback;

        public ResponseHandler(Dispatcher dispatcher, ResponseCallback callback) throws BusyConnectionException {
            this.streamId = dispatcher.streamIdHandler.next();
            this.callback = callback;
        }
    }

    static interface ResponseCallback {
        public Message.Request request();

        public void onSet(Connection var1, Message.Response var2);

        public void onException(Connection var1, Exception var2);
    }

    static class Future
    extends SimpleFuture<Message.Response>
    implements ResponseCallback {
        private final Message.Request request;
        private volatile InetAddress address;

        public Future(Message.Request request) {
            this.request = request;
        }

        @Override
        public Message.Request request() {
            return this.request;
        }

        @Override
        public void onSet(Connection connection, Message.Response response) {
            this.address = connection.address;
            super.set(response);
        }

        @Override
        public void onException(Connection connection, Exception exception) {
            super.setException(exception);
        }

        public InetAddress getAddress() {
            return this.address;
        }
    }

    private class Dispatcher
    extends SimpleChannelUpstreamHandler {
        public final StreamIdGenerator streamIdHandler = new StreamIdGenerator();
        private final ConcurrentMap<Integer, ResponseHandler> pending = new ConcurrentHashMap<Integer, ResponseHandler>();

        private Dispatcher() {
        }

        public void add(ResponseHandler handler) {
            ResponseHandler old = this.pending.put(handler.streamId, handler);
            assert (old == null);
        }

        public void removeHandler(int streamId) {
            this.pending.remove(streamId);
            this.streamIdHandler.release(streamId);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            if (!(e.getMessage() instanceof Message.Response)) {
                logger.error("[{}] Received unexpected message: {}", (Object)Connection.this.name, e.getMessage());
                Connection.this.defunct(new TransportException(Connection.this.address, "Unexpected message received: " + e.getMessage()));
            } else {
                Message.Response response = (Message.Response)e.getMessage();
                int streamId = response.getStreamId();
                logger.trace("[{}] received: {}", (Object)Connection.this.name, e.getMessage());
                if (streamId < 0) {
                    ((Connection)Connection.this).factory.defaultHandler.handle(response);
                    return;
                }
                ResponseHandler handler = (ResponseHandler)this.pending.remove(streamId);
                this.streamIdHandler.release(streamId);
                if (handler == null) {
                    logger.error("[{}] No handler set for stream {} (this is a bug, either of this driver or of Cassandra, you should report it)", (Object)Connection.this.name, (Object)streamId);
                    return;
                }
                handler.callback.onSet(Connection.this, response);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("[%s] connection error", Connection.this.name), e.getCause());
            }
            if (Connection.this.writer.get() > 0) {
                return;
            }
            Connection.this.defunct(new TransportException(Connection.this.address, "Unexpected exception triggered", e.getCause()));
        }

        public void errorOutAllHandler(ConnectionException ce) {
            Iterator iter = this.pending.values().iterator();
            while (iter.hasNext()) {
                ((ResponseHandler)iter.next()).callback.onException(Connection.this, ce);
                iter.remove();
            }
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
            if (Connection.this.isClosed) {
                this.errorOutAllHandler(new TransportException(Connection.this.address, "Channel has been closed"));
            } else {
                Connection.this.defunct(new TransportException(Connection.this.address, "Channel has been closed"));
            }
        }
    }

    public static class Factory {
        private final ExecutorService bossExecutor = Executors.newCachedThreadPool();
        private final ExecutorService workerExecutor = Executors.newCachedThreadPool();
        private final ChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)this.bossExecutor, (Executor)this.workerExecutor);
        private final ChannelGroup allChannels = new DefaultChannelGroup();
        private final ConcurrentMap<Host, AtomicInteger> idGenerators = new ConcurrentHashMap<Host, AtomicInteger>();
        public final DefaultResponseHandler defaultHandler;
        public final Configuration configuration;
        public final AuthInfoProvider authProvider;

        public Factory(Cluster.Manager manager, AuthInfoProvider authProvider) {
            this(manager, manager.configuration, authProvider);
        }

        private Factory(DefaultResponseHandler defaultHandler, Configuration configuration, AuthInfoProvider authProvider) {
            this.defaultHandler = defaultHandler;
            this.configuration = configuration;
            this.authProvider = authProvider;
        }

        public int getPort() {
            return this.configuration.getProtocolOptions().getPort();
        }

        public Connection open(Host host) throws ConnectionException, InterruptedException {
            InetAddress address = host.getAddress();
            String name = address.toString() + "-" + this.getIdGenerator(host).getAndIncrement();
            return new Connection(name, address, this);
        }

        private AtomicInteger getIdGenerator(Host host) {
            AtomicInteger old;
            AtomicInteger g = (AtomicInteger)this.idGenerators.get(host);
            if (g == null && (old = this.idGenerators.putIfAbsent(host, g = new AtomicInteger(1))) != null) {
                g = old;
            }
            return g;
        }

        private ClientBootstrap newBootstrap() {
            Integer sendBufferSize;
            Integer receiveBufferSize;
            Boolean tcpNoDelay;
            Integer soLinger;
            Boolean reuseAddress;
            ClientBootstrap b = new ClientBootstrap(this.channelFactory);
            SocketOptions options = this.configuration.getSocketOptions();
            b.setOption("connectTimeoutMillis", (Object)options.getConnectTimeoutMillis());
            Boolean keepAlive = options.getKeepAlive();
            if (keepAlive != null) {
                b.setOption("keepAlive", (Object)keepAlive);
            }
            if ((reuseAddress = options.getReuseAddress()) != null) {
                b.setOption("reuseAddress", (Object)reuseAddress);
            }
            if ((soLinger = options.getSoLinger()) != null) {
                b.setOption("soLinger", (Object)soLinger);
            }
            if ((tcpNoDelay = options.getTcpNoDelay()) != null) {
                b.setOption("tcpNoDelay", (Object)tcpNoDelay);
            }
            if ((receiveBufferSize = options.getReceiveBufferSize()) != null) {
                b.setOption("receiveBufferSize", (Object)receiveBufferSize);
            }
            if ((sendBufferSize = options.getSendBufferSize()) != null) {
                b.setOption("sendBufferSize", (Object)sendBufferSize);
            }
            return b;
        }

        public void shutdown() {
            this.allChannels.close();
            this.channelFactory.releaseExternalResources();
        }
    }
}

