/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.db.DbOpsClient;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.exception.ChangeDataCaptureNotFoundException;
import com.dtsx.astra.sdk.db.exception.KeyspaceNotFoundException;
import com.dtsx.astra.sdk.streaming.AstraStreamingClient;
import com.dtsx.astra.sdk.streaming.domain.CdcDefinition;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class DbCdcsClient
extends AbstractApiClient {
    private static final TypeReference<List<CdcDefinition>> TYPE_LIST_CDC = new TypeReference<List<CdcDefinition>>(){};
    private final Database db;

    public DbCdcsClient(String token, String databaseId) {
        this(token, AstraEnvironment.PROD, databaseId);
    }

    public DbCdcsClient(String token, AstraEnvironment env, String databaseId) {
        super(token, env);
        Assert.hasLength(databaseId, "databaseId");
        this.db = new DbOpsClient(token, env, databaseId).get();
    }

    public Stream<CdcDefinition> findAll() {
        ApiResponseHttp res = this.GET(this.getEndpointDatabaseCdc());
        if (404 == res.getCode()) {
            return Stream.of(new CdcDefinition[0]);
        }
        return JsonUtils.unmarshallType(res.getBody(), TYPE_LIST_CDC).stream();
    }

    public Optional<CdcDefinition> findById(String cdcId) {
        Assert.hasLength(cdcId, "cdc identifier");
        return this.findAll().filter(cdc -> cdc.getConnectorName().equals(cdcId)).findFirst();
    }

    public Optional<CdcDefinition> findByDefinition(String keyspace, String table, String tenant) {
        Assert.hasLength(keyspace, "keyspace");
        Assert.hasLength(table, "table");
        Assert.hasLength(tenant, "tenant");
        return this.findAll().filter(cdc -> cdc.getKeyspace().equals(keyspace) && cdc.getDatabaseTable().equals(table) && cdc.getTenant().equals(tenant)).findFirst();
    }

    public void create(String keyspace, String table, String tenant, int topicPartition) {
        Assert.hasLength(keyspace, "keyspace");
        if (!this.db.getInfo().getKeyspaces().contains(keyspace)) {
            throw new KeyspaceNotFoundException(this.db.getId(), keyspace);
        }
        new AstraStreamingClient(this.token, this.environment).tenant(tenant).cdc().create(this.db.getId(), keyspace, table, topicPartition);
    }

    public void delete(String cdcId) {
        this.delete(this.findById(cdcId).orElseThrow(() -> new ChangeDataCaptureNotFoundException(cdcId, this.db.getId())));
    }

    public void delete(String keyspace, String table, String tenant) {
        this.delete(this.findByDefinition(keyspace, table, tenant).orElseThrow(() -> new ChangeDataCaptureNotFoundException(keyspace, table, tenant, this.db.getId())));
    }

    private void delete(CdcDefinition cdc) {
        new AstraStreamingClient(this.token, this.environment).tenant(cdc.getTenant()).cdc().delete(this.db.getId(), cdc.getKeyspace(), cdc.getDatabaseTable());
    }

    private String getEndpointDatabaseCdc() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/streaming/astra-cdc/databases/" + this.db.getId();
    }
}

