/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.time;

import com.datasqrl.time.TimeTumbleWindowFunction;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;

public class EndOfYear
extends TimeTumbleWindowFunction {
    public EndOfYear() {
        super(ChronoUnit.YEARS, ChronoUnit.DAYS);
    }

    @Override
    public Instant eval(Instant instant) {
        return ZonedDateTime.ofInstant(instant, ZoneOffset.UTC).with(TemporalAdjusters.firstDayOfNextYear()).truncatedTo(ChronoUnit.DAYS).minusNanos(1L).toInstant();
    }

    @Override
    public Instant eval(Instant instant, Long multiple, Long offset) {
        ZonedDateTime time;
        if (multiple == null) {
            multiple = 1L;
        }
        if (offset == null) {
            offset = 0L;
        }
        time = (long)(time = ZonedDateTime.ofInstant(instant, ZoneOffset.UTC).truncatedTo(ChronoUnit.DAYS)).getDayOfYear() > offset ? time.with(TemporalAdjusters.firstDayOfNextYear()) : time.with(TemporalAdjusters.firstDayOfYear());
        int modulus = multiple.intValue();
        int yearsToAdd = (modulus - time.getYear() % modulus) % modulus;
        time = time.plusYears(yearsToAdd).plusDays(offset);
        return time.minusNanos(1L).toInstant();
    }
}

